C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, ntrco, nrec,  
     :     nreco, iform, ist, iend, irs, ire, ns, ne, Xzero, deltaX,  
     :     Xmax, HdrWrd, num_mnemonics, Type, mirror, num_mirror_inside,
     :     num_mirror_outside, dead, distap, verbos )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer    nsamp, nsi, ntrc, ntrco, nrec, nreco, iform
      integer    ist, iend, ns, ne, num_mnemonics
      integer    num_mirror_inside, num_mirror_outside

      real       Xzero, deltaX, Xmax

      character  ntap*(*), otap*(*), Type*(*), distap*(*)
      character*6 HdrWrd(num_mnemonics)

      logical    mirror, dead, verbos

c declare local variables

      integer length

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name   =  ',ntap(1:length)
      else
        write(LERR,*) ' input data set        =  stdin'
      endif
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '

      if (distap .ne. ' ' ) then
         write(LERR,*)' '
         write(LERR,*)' Input Distance Parameters'
         write(LERR,*)' '
         length = lenth(distap)
         write(LERR,*) ' distance data set name   =  ', distap(1:length)
         write(LERR,*)' '
      endif

      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*) ' output data set name    =  ',otap(1:length)
      else
        write(LERR,*) ' output data set         =  stdout'
      endif
      write(LERR,*) ' start record            =  ', irs 
      write(LERR,*) ' end record              =  ', ire 
      write(LERR,*) ' number of records out   =  ', nreco
      write(LERR,*) ' start trace             =  ', ns 
      write(LERR,*) ' end trace               =  ', ne 
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      write(LERR,*)' '
      write(LERR,*) ' X(0)                    = ', Xzero
      write(LERR,*) ' dx                      = ', deltaX
      write(LERR,*) ' X(max)                  = ', Xmax
      write(LERR,*) ' number of traces out    =  ', ntrco
      if ( mirror ) then
         write(LERR,*)' '
         write(LERR,*) ' using mirror extrapolation'
         write(LERR,*) ' number of inside traces to mirror = ',
     :     num_mirror_inside
         write(LERR,*) ' number of outside traces to mirror = ',
     :     num_mirror_outside
         write(LERR,*)' '
      endif
      if ( dead ) then
         write(LERR,*)' '
         write(LERR,*) ' filling in dead traces only'
         write(LERR,*)' '
      endif
      if ( num_mnemonics .gt. 0 ) then
         write(LERR,*) ' Additional Headers entries to interpolate are:'
         write(LERR,*) ' '
         do i = 1, num_mnemonics
            write(LERR,'(1x,a6)') HdrWrd(i)
         enddo
      endif

      write(LERR,*) ' '
      if ( Type .eq. 'linear' ) then
         write(LERR,*) ' Using linear interpolation'
      elseif ( Type .eq. 'FFT' ) then
         write(LERR,*) ' Using unequal spaced FFT interpolation'
      else
         write(LERR,*) ' Using cubic spline interpolation'
      endif

      write(LERR,*) ' '
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end
