/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* PROGRAM TO CALCULATE TRAVEL TIMES IN 2D MEDIA */
/* AUTHOR: John E. Vidale */
/* OVERHAULED IN 11-90 TO ALLOW RECURSIVE CORRECTION (SEE VIDALE, 1991) */
/* Modified for fortran subroutine entry - W.may 11/30/90 */

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <localsys.h>
 
float  fs0;   /* SHOT POSITION IN X (if in real units)*/
float fzs;    /* SHOT POSITION IN Z (if in real units)*/
int sbox=1;   /* RADIUS OF INNER STRAIGHT RAY */
int tfint;

#define dt(x,z) timing[(x) + (z)* *nx]
#define ds(x,z)  slow[(x) + (z)* *nx]

#if defined( SUNSYSTEM ) || defined( CONVEXSYSTEM )
void fd135_(nx,nz,izbeg,izend,ixbeg,ixend,h,s0,zs,slow,timing)
#else
#ifdef CRAYSYSTEM
void FD135(nx,nz,izbeg,izend,ixbeg,ixend,h,s0,zs,slow,timing)

#else		/* this covers the RS6000 and IBM */
void fd135(nx,nz,izbeg,izend,ixbeg,ixend,h,s0,zs,slow,timing)
#endif
#endif
 
int *nx;       /* X-DIMENSION OF MESH */
int *nz;       /* Z-DIMENSION OF MESH */
float *h;      /* SPATIAL MESH INTERVAL (units consistant with vel)*/
int  *s0;      /* SHOT POSITION IN X (if in grid points)*/
int  *zs;      /* SHOT POSITION IN Z (if in grid points)*/
int  *izbeg;   /* BEGINNING Z FOR COMPUTATION ( in grid pts) */
int  *izend;   /* ENDING Z FOR COMPUTATION ( in grid pts) */
int  *ixbeg;   /* BEGINNING X  FOR CONPUTATION (in grid points) */
int  *ixend;   /* ENDING X  FOR CONPUTATION (in grid points) */
float slow[], timing[];
 
/* ARRAY ORDERING ( x(ix,iz) = x[ ix + iz* *nx ] IN 1D ARRAY ) */
/* VELOCITY AND TRAVELTIME IS IN SAME ORDER */
 
{
 int mzup, mzdn, zup, zdn, xlt, xrt, nbox, k, ix, iz;
/* register float *slow, *timing; */
 float edge1(), dist;
 float rtt, junk1, junk2;
 int j, vfint, layerd=15;
 
 fs0 = (float)*s0;
 fzs = (float)*zs;
 fprintf (stderr,"nx = %d nz = %d ", *nx, *nz);
 fprintf (stderr,"s0 = %d zs = %d ", *s0, *zs);
 fprintf (stderr,"sbox = %d ", sbox);
 fprintf (stderr,"h = %f ", *h);
 if(*s0 > *nx-1){
  fprintf(stderr,"Source off grid to the right, try again.\n");
  exit(-1);
 }
 if(*zs > *izend-1){
  fprintf(stderr,"Source off bottom of grid, try again.\n");
  exit(-1);
 }
 
 /* INITIALIZE ALL POINTS TO -1, (NEGATIVE WILL MEAN POINT IS SO FAR */
 /* UNTIMED, SO AVOID TINKERING TO SOLVE FOR NEGATIVE TIMES */
 for(j=0;j<*nx * *nz;j++) timing[j] = -1.0;
 
 /* CONVERT VELOCITIES TO SLOWNESSES */
 for(k=0; k<*nx * *nz; k++) slow[k] = *h/slow[k];
 
 /* TIME POINTS NEAR SOURCE WITH STRAIGHT RAYS */
 for(ix = -sbox ; ix < sbox + 1; ix++)
  for(iz= -sbox; iz < sbox + 1; iz++){
   if((*s0+ix>=0) && (*s0+ix<*ixend) && (*zs+iz>=0) && (*zs+iz< *izend))
    if(ix != 0 || iz != 0){
     dist = sqrt( ix*ix + iz*iz );
     dt(*s0+ix,*zs+iz) = 0.5*(ds(*s0,*zs) + ds(*s0+ix,*zs+iz)) * dist;
    }
   /* SOME NONSENSE FOR SINGULAR SOURCE LOCATION */
   else
    dt(*s0,*zs) = 0;
  }
 
 /* SET POINTERS TO NEXT CONCENTRIC BOX, AND COUNT BOXES */
 zup = (*zs-1-sbox >=   0  ? *zs-1-sbox : -1 );
 zdn = (*zs+1+sbox <=  *izend-1 ? *zs+1+sbox :  *izend );
 xlt = (*s0-1-sbox >=    0 ? *s0-1-sbox : -1 );
 xrt = (*s0+1+sbox <= *ixend-1 ? *s0+1+sbox : *ixend );
 if(zup == -1) mzup = 0;
 else mzup = zup;
 if(zdn ==  *izend) mzdn =  *izend-1;
 else mzdn = zdn;
 nbox= 0;
 if(*s0-1-sbox > nbox) nbox= *s0-2;
 if(*zs-1-sbox > nbox) nbox= *zs-2;
 if( (*ixend-*ixbeg+1)-*s0-1-sbox > nbox) nbox= (*ixend-*ixbeg+1)-*s0-2;
 if( *izend-*zs-1-sbox > nbox) nbox=  *izend-*zs-2;

 /* LOOP OVER BOXES */
 for(k=0; k<=nbox; k++)
 {
  if( k%100 == 0)
  fprintf(stderr,"box=%d out of %d xlt=%d xrt=%d zup=%d zdn=%d\n",
   k, nbox, xlt, xrt, zup, zdn);
   
  /* TOP EDGE, Z=zup */
  if(zup >= 0)
   timerow(xrt-xlt-1,*nx,1,&timing[xlt+1+ *nx*mzup],&slow[xlt+1+ *nx*mzup]);
  /* BOTTOM EDGE, z=zdn */
  if(zdn <  *izend)
   timerow(xrt-xlt-1,- *nx,1,&timing[xlt+1+ *nx*mzdn],&slow[xlt+1+ *nx*mzdn]);
  /* LEFT EDGE, x=xlt */
  if(xlt >= *ixbeg-1)
   timerow(mzdn-mzup+1,1, *nx,&timing[xlt+ *nx*mzup],&slow[xlt+ *nx*mzup]);
  /* RIGHT EDGE, x=xrt */
  if(xrt <  *ixend)
   timerow(mzdn-mzup+1,-1, *nx,&timing[xrt+ *nx*mzup],&slow[xrt+ *nx*mzup]);
  
  /* EXPAND THE BOX */
  if(xlt >= *ixbeg-1) xlt--;
  if(zup >= 0) zup--;
  if(xrt < *ixend) xrt++;
  if(zdn < *izend) zdn++;
  
  /* KEEP UPPER AND LOWER LIMITS ON COLUMN CALCULATION CORRECT */
  if(zup == -1) mzup = 0;
  else mzup = zup;
  if(zdn == *izend) mzdn = *izend-1;
  else mzdn = zdn;
 }
}


float edge1(ta,tb,tc,hs)
float ta, tb, tc, hs;
{
 float td, diff, arg;
/*
#ifndef CONVEXSYSTEM
 double sqrt();
#endif
*/
 diff= 0.5*(tc- tb);
 arg= hs*hs - diff*diff;
 /* PATHOLOGICAL CASE, ASSUME SOMETHING SIMPLE */
 if(arg < 0.0)
 {
  td = ta + hs;
  return(td);
 }
 td= ta + sqrt( (double)(arg));
 return(td);
}
/* EXTRAPOLATE TRAVELTIMES TO NEXT ROW OR COLUMN */
timerow(len,norm,tang,t,s)
float *t, *s; /* ARRAYS WITH SLOWNESS AND TRAVELTIME */
int len; /* NUMBER OF POINTS IN ROW */
int norm; /* INCREMENT IN DIRECTION NORMAL TO ROW (POSITIVE INWARD) */
int tang; /* INCREMENT IN TANGENTIAL DIRECTION */
{
 int i, j, fredo, bredo, update, updatd, go_on;
 float guess, diff, avs, argu, *ss, *tt, *ch;
#ifndef CONVEXSYSTEM
 double fabs();
#endif
 fredo = bredo = 0;
 /* CHECK WHETHER UPPER OR LEFT END HAS NORMAL REFRACTION */
 if(t[norm] <= t[norm+tang])
  t[0] = t[norm] + 0.5*(s[0] + s[norm]);
 /* SWEEP FORWARD (TANGENTIALLY) ACROSS INTERIOR OF ROW */
 t += tang;
 s += tang;
 for(i=0;i<len-1;i++,t+=tang,s+=tang){
  if((t[norm] >= t[norm-tang]) || (i == len-2)){
   /* TIME INCREASING WITH SWEEP */
   /* NO BACK CORRECTION NECESSARY */
   if(fredo==0){
    if(t[-tang] < 0 || (t[norm] < t[norm-tang]))
     /* NORMAL DIFFRACTION MUST BE ASSUMED */
     t[0] = t[norm] + 0.5*(s[0] + s[norm]);
    else{
     diff = t[norm] - t[-tang];
     avs = 0.25*(s[0]+s[-tang]+s[norm]+s[norm-tang]);
     argu = 2.0*avs*avs - diff*diff;
     if(argu >= 0)
      /* BASIC CORNER CALCULATION */
      t[0] = t[norm-tang] + sqrt(argu);
     else{
      /* TANG. DIFFRACTION MUST BE ASSUMED */
      t[0] = t[-tang] + 0.5*(s[0] + s[-tang]);
      if(t[0] < t[norm]) fredo = 2;
     }
    }
   }
   /* BACK CORRECTION NECESSARY */
   if(fredo != 0){
    /* SEE IF NORMAL CALCULATION WILL WORK */
    /* (THEN PERHAPS fredo WILL RETURN TO 0) */
    if(t[-tang] < 0 || (t[norm] < t[norm-tang]))
     /* NORMAL DIFFRACTION MUST BE ASSUMED */
     t[0] = t[norm] + 0.5*(s[0] + s[norm]);
    else{
     diff = t[norm] - t[-tang];
     avs = 0.25*(s[0]+s[-tang]+s[norm]+s[norm-tang]);
     argu = 2.0*avs*avs - diff*diff;
     if(argu >= 0)
      /* BASIC CORNER CALCULATION */
      t[0] = t[norm-tang] + sqrt(argu);
     else
      /* TANG. DIFFRACTION MUST BE ASSUMED */
      t[0] = t[-tang] + 0.5*(s[0] + s[-tang]);
    }
    /* STORE OLD TIMES TO SEE WHICH CHANGE MUCH */
    /* IN RECURSIVE CORRECTION */
    ch = (float *) malloc (sizeof(float)*fredo);
    for(j=0, tt=t; j<fredo; j++, tt += norm)
     ch[j] = tt[0];
    /* DO BACK CORRECTION */
    rtimerow(fredo,-tang,norm,&t[0],&s[0]);
    tt = t + fredo*norm;
    ss = s + fredo*norm;
    /* SEE WHETHER BACK CORRECTION IS NECESSARY FURTHER IN */
    update = 1;
    updatd = 0;
    while((tt[-tang] >= tt[-norm-tang]) && update == 1){
     diff = tt[-norm] - t[-tang];
     avs = 0.25*(ss[0]+ss[-tang]+ss[-norm]+ss[-norm-tang]);
     argu = 2.0*avs*avs - diff*diff;
     if(argu >= 0)
      guess = tt[-norm-tang] + sqrt(argu);
     else
      guess = tt[-norm] + 0.5*(ss[0]+ss[-norm]);
     update = 0;
     if(guess <= tt[0]){
      tt[0] = guess;
      fredo++;
      tt += norm;
      ss += norm;
      update = 1;
      updatd = 1;
     }
    }
    /* fprintf(stderr,"Forward sweep recurs. corr. of %d points, tang=%d, norm=%d, len=%d, i=%d\n",
     fredo, tang, norm, len, i); */
    /* SEE WHETHER BACK CORRECTION LENGTH CAN BE SHORTENED */
    if(updatd == 0){
     /* CHECK FROM INNERMOST POINT BACK OUT */
     tt=&t[(fredo-1)*norm];
     ss=&s[(fredo-1)*norm];
     go_on = 1;
/*     for(j=(fredo-1); j >= 0, go_on;j--,tt-=norm,ss-=norm){ */
     for(j=(fredo-1); (j >= 0) && go_on;j--,tt-=norm,ss-=norm){
      /* CHANGE IS IGNORABLE IF < 10% OF SPACING*SLOWNESS */
      if(fabs(ch[j] - tt[0]) > 0.10*ss[0]) go_on = 0;
      else{
       /* fprintf(stderr,"Dropping fredo from %d to %d\n",fredo,j); */
       fredo = j;
      }
     }
     /* fredo == 1 DOESN'T MAKE MUCH SENSE */
     if(fredo==1) fredo=2;
    }
    free(ch);
   }
  }
  else if(t[norm] <= t[norm+tang])
   /* EDGE CALCULATION */
   t[0] = edge1(t[norm],t[norm-tang],t[norm+tang],
    0.5*(s[0]+s[norm]));
 }
 /* SWEEP BACK ACROSS INTERIOR OF ROW */
 t -= 2*tang;
 s -= 2*tang;
 for(i=0;i<len-1;i++,t-=tang,s-=tang){
  if(t[norm] >= t[norm+tang]){
   /* TIME INCREASING WITH SWEEP */
   if(bredo == 0){
    /* NO BACK CORRECTION NECESSARY */
    diff = t[norm] - t[tang];
    avs = 0.25*(s[0]+s[tang]+s[norm]+s[norm+tang]);
    argu = 2.0*avs*avs - diff*diff;
    /* ALLOW POSSIBILITY THAT POINT IS TIMED FROM BOTH SIDES */
    if(argu >= 0)
     /* BASIC CORNER CALCULATION */
     guess = t[norm+tang] + sqrt(argu);
    else
     /* TANGENTIAL DIFFRACTION MUST BE ASSUMED */
     guess = t[tang] + 0.5*(s[0] + s[tang]);
    if(guess < t[0] || t[0] < 0)
     t[0] = guess;
    if(t[0] < t[norm]) bredo = 2;
   }
   /* BACK CORRECTION NECESSARY */
   if(bredo != 0){
    /* SEE IF NORMAL CALCULATION WILL WORK */
    /* (THEN PERHAPS bredo WILL RETURN TO 0) */
    diff = t[norm] - t[tang];
    avs = 0.25*(s[0]+s[tang]+s[norm]+s[norm+tang]);
    argu = 2.0*avs*avs - diff*diff;
    /* ALLOW POSSIBILITY THAT POINT IS TIMED FROM BOTH SIDES */
    if(argu >= 0)
     /* BASIC CORNER CALCULATION */
     guess = t[norm+tang] + sqrt(argu);
    else
     /* TANGENTIAL DIFFRACTION MUST BE ASSUMED */
     guess = t[tang] + 0.5*(s[0] + s[tang]);
    if(guess < t[0] || t[0] < 0)
     t[0] = guess;
    /* STORE OLD TIMES TO SEE WHICH CHANGE MUCH */
    /* IN RECURSIVE CORRECTION */
    ch = (float *) malloc (sizeof(float)*bredo);
    for(j=0, tt=t; j<bredo; j++, tt += norm)
     ch[j] = tt[0];
    /* DO BACK CORRECTION */
    rtimerow(bredo,tang,norm,&t[0],&s[0]);
    tt = t + bredo*norm;
    ss = s + bredo*norm;
    /* SEE WHETHER BACK CORRECTION IS NECESSARY FURTHER IN */
    update = 1;
    updatd = 0;
    while((tt[tang] >= tt[-norm+tang]) && update == 1){
     diff = tt[-norm] - t[tang];
     avs = 0.25*(ss[0]+ss[tang]+ss[-norm]+ss[-norm+tang]);
     argu = 2.0*avs*avs - diff*diff;
     if(argu >= 0)
      guess = tt[-norm+tang] + sqrt(argu);
     else
      guess = tt[-norm] + 0.5*(ss[0]+ss[-norm]);
     update = 0;
     if(guess <= tt[0]){
      tt[0] = guess;
      bredo++;
      tt += norm;
      ss += norm;
      update = 1;
      updatd = 1;
     }
    }
    /* fprintf(stderr,"Reverse sweep recurs. corr. of %d points, tang=%d, norm=%d, len=%d, i=%d\n",
     bredo, tang, norm, len, i); */
    /* SEE WHETHER BACK CORRECTION LENGTH CAN BE SHORTENED */
    if(updatd == 0){
     /* CHECK FROM INNERMOST POINT BACK OUT */
     tt=&t[(bredo-1)*norm];
     ss=&s[(bredo-1)*norm];
     go_on = 1;
/*     for(j=(bredo-1); j >= 0, go_on;j--,tt-=norm,ss-=norm){ */
     for(j=(bredo-1); (j >= 0) && go_on;j--,tt-=norm,ss-=norm){
      /* CHANGE IS IGNORABLE IF < 10% OF SPACING*SLOWNESS */
      if(fabs(ch[j] - tt[0]) > 0.10*ss[0]) go_on = 0;
      else{
       /* fprintf(stderr,"Dropping bredo from %d to %d\n",bredo,j); */
       bredo = j;
      }
     }
     /* bredo == 1 DOESN'T MAKE MUCH SENSE */
     if(bredo==1) bredo=2;
    }
    free(ch);
   }  
  }
 }
}
/* RECURSIVELY CORRECT TRAVELTIMES BACK INTO INTERIOR */
rtimerow(len,norm,tang,t,s)
float *t, *s; /* ARRAYS WITH SLOWNESS AND TRAVELTIME */
int len; /* NUMBER OF POINTS IN ROW */
int norm; /* INCREMENT IN DIRECTION NORMAL TO ROW (POSITIVE INWARD) */
int tang; /* INCREMENT IN TANGENTIAL DIRECTION */
{
 int i;
 float guess, diff, avs, argu;
 /* START WITH NORMAL REFRACTION */
 /* BUT ONLY USE TIMES THAT ARE EARLIER THAN EXISTING TIMES */
 guess = t[norm] + 0.5*(s[0] + s[norm]);
 if((guess < t[0]) || (t[0] < 0)) t[0] = guess;
 /* SWEEP FORWARD ACROSS INTERIOR OF ROW */
 t += tang;
 s += tang;
 for(i=0;i<len-1;i++,t+=tang,s+=tang){
  if(t[norm] >= t[norm-tang]){
   /* TIME INCREASING WITH SWEEP */
   /* BASIC CORNER CALCULATION */
   diff = t[norm] - t[-tang];
   avs = 0.25*(s[0]+s[-tang]+s[norm]+s[norm-tang]);
   argu = 2.0*avs*avs - diff*diff;
   if(argu > 0)
    guess = t[norm-tang] + sqrt(argu);
   else
    guess = t[-tang] + 0.5*(s[0] + s[-tang]);
   if(guess < t[0] || t[0] < 0)
    t[0] = guess;
  }
  else if(t[norm] < t[norm+tang]){
   /* EDGE CALCULATION */
   guess = edge1(t[norm],t[norm-tang],t[norm+tang],
    0.5*(s[0]+s[norm]));
   if(guess < t[0] || t[0] < 0)
    t[0] = guess;
  }
 }
 /* SWEEP BACK ACROSS INTERIOR OF ROW */
 t -= 2*tang; s -= 2*tang;
 for(i=0;i<len-1;i++,t-=tang,s-=tang){
  if(t[norm] >= t[norm+tang]){
   /* TIME INCREASING WITH SWEEP */
   /* BASIC CORNER CALCULATION */
   diff = t[norm] - t[tang];
   avs = 0.25*(s[0]+s[tang]+s[norm]+s[norm+tang]);
   argu = 2.0*avs*avs - diff*diff;
   if(argu > 0)
    guess = t[norm+tang] + sqrt(argu);
   else
    guess = t[norm] + 0.5*(s[0] + s[norm]);
   if(guess < t[0] || t[0] < 0)
    t[0] = guess;
  }
 }
}

