C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C     PROGRAM MODULE  fft2d
C
C**********************************************************************C
C
C fft2d READS SEISMIC TRACE DATA FROM AN INPUT FILE, record-by-record,
C performs a fft2d phase shift migration,
C and writes the results to otap
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <ut_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LBYTES, NBYTES,obytes
      integer     argis, ordfft
      integer     nsampo, ns, ne, irs, ire
      integer     errcod, abort
      INTEGER     itrh
      REAL        xtr(SZLNHD),ctr(SZLNHD), data
      complex     wrk2, wrk6
      pointer     (wkaddr, data(1))
      pointer     (wkadr2, wrk2(1))
      pointer     (wkadr6, wrk6(1))
      pointer     (wkitrh, itrh(1))
      CHARACTER   NAME * 80, ntap * 256, otap * 256
      logical     verbos,query,heap,first,revers
 
c     EQUIVALENCE ( ITR(129), xtr (1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'FFT2D: 2-d forward/reverse fft'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /
      DATA first/.true./
c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help ()
           stop
      endif
c------------------------------------
c  open printout file
c------------------------------------
#include <f77/open.h>
C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE ARGUMENT STRING
C**********************************************************************C
      call cmdln (ntap,otap,ist,iend,ns,ne,irs,ire,verbos,
     1            revers)
C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )
      lbytes = 0
      call rtape ( luin, itr, lbyte )
      lbytes = lbyte
      if(lbytes .eq. 0) then
         write(LERR,*)'FFT2D: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt    ( ITR , LBYTE, NAME, 80, LERR        )
c---------------------------------
c  save key header values
#include <f77/saveh.h>

      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,1)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,1)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,1)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,1)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,1)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,1)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,1)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,1)
c----------------------------------
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c
c - I think this is supposed to be ire and irs - j.m.wade 8/21/92
c
c     nrecc=nred-nrst+1
      nrecc=ire-irs+1
      ist=ist/nsi
      iend=iend/nsi
      ntr = ne - ns + 1
      ntro = ntr
      if(ist .lt. 1) ist=1
      if(iend .lt. 1) iend=nsamp
c---------------------------
c  check to see if
c  samp int is in micro secs
      dt = float(nsi) * unitsc
      if (revers) then
         ntpad = nsamp
         nxpad = ntrc/2
         inc = 2
         ns = 1
         ne = ntrc
      else
         nu = ordfft( nsamp )
         ntpad = 2 ** nu
         nu = ordfft( ntro )
         nxpad = 2 ** nu
         inc = 1
      endif
c------------------------------------------------------
c  save headers: exchange # traces/rec & # samples/rec
       call savew( itr, 'NumRec', nrecc , LINHED)
       if (revers) then
          call saver( itr, 'OrNTRC', ntr   , LINHED)
          call saver( itr, 'OrNSMP', nsampo, LINHED)
          call savew( itr, 'NumTrc', ntr   , LINHED)
          call savew( itr, 'NumSmp', nsampo, LINHED)
          ntro = ntr
          obytes = SZTRHD + SZSMPD * nsampo
       else
          call savew( itr, 'OrNSMP', nsamp , LINHED)
          call savew( itr, 'OrNTRC', ntrc  , LINHED)
          call savew( itr, 'NumSmp', ntpad , LINHED)
          call savew( itr, 'NumTrc', 2*nxpad , LINHED)
          ntro = nxpad
          obytes = SZTRHD + SZSMPD * ntpad
       endif
c----------------------------------------------------------------
c  change output bytes to reflect change from real to cmplx values
c---------------------------------
c  verbos printout
      if(verbos) then
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc
        write(LERR,*) ' Traces per Record  =  ', ntro
        write(LERR,*) ' Records per Line   =  ', nrec
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' Output # samples   =  ', ntpad
        if (revers) then
           write(LERR,*) ' Output # traces    =  ', ntr
           write(LERR,*) ' nxpad              =  ', nxpad
        else
           write(LERR,*) ' Output # traces    =  ', 2*nxpad
        endif
        write(LERR,*) ' Output records     =  ', nrecc
        write(LERR,*) ' Reverse Transform? =  ', revers
      endif
c-----------------------------------------------
c  adjust historical line header & write header
      call savhlh ( itr, lbyte, lbyout )
 
      call wrtape(luout,itr,lbyout)
c------------------------------------------------
c  skip to start record
      call recskp(1,irs-1,luin,ntrc,itr)
c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.
c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92
      itemi = ITRWRD * ntrc
      call galloc (wkitrh, itemi*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkaddr, ntpad*nxpad*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkadr2, 2*ntpad*nxpad*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkadr6, (ntpad+1)*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      if (.not. heap) then
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi*SZSMPD,'  bytes'
         write(LERR,*) ntpad*nxpad*SZSMPD,'  bytes'
         write(LERR,*) 2*ntpad*nxpad*SZSMPD,'  bytes'
         write(LERR,*) ntpad*SZSMPD,'  bytes'
         go to 999
      else
         write(LERR,*)'Allocated workspace:'
         write(LERR,*) itemi*SZSMPD,'  bytes'
         write(LERR,*) ntpad*nxpad*SZSMPD,'  bytes'
         write(LERR,*) 2*ntpad*nxpad*SZSMPD,'  bytes'
         write(LERR,*) ntpad*SZSMPD,'  bytes'
      endif
c---------------------------------------------------
C**********************************************************************C
C
C     READ RECORD, DO 2-D FFT, WRITE OUTPUT RECORD
C
C**********************************************************************C
 
      DO 100 JJ = irs, ire
c-------------------------------
c  skip to desired trace
c-------------------------------
             call trcskp(jj,1,ns-1,luin,ntrc,itr)
c--------------------------------------------------
c  read record & store
c----------------------
           nlive = 0
           ic = 0
           DO 99 KK = ns, ne, inc
                 nbytes = 0
                 CALL RTAPE  ( LUIN , ITR, NBYTES         )
                 if(nbytes .eq. 0) then
                    write(LERR,*)'WARNING'
                    write(LERR,*)'End of file on input:'
                    write(LERR,*)'  rec= ',jj,'  trace= ',kk
                    go to 59
                 endif
                 call vmov  (itr(ITHWP1), 1, xtr, 1, nsamp)
                 call saver2(itr,ifmt_StaCor,l_StaCor,
     1                       ln_StaCor, istatic   , 1)
                 call saver2(itr,ifmt_DstSgn,l_DstSgn,
     1                       ln_DstSgn, istatic   , 1)
                 if (istatic .eq. 30000) then
                    call vclr (xtr,1,nsamp)
                 else
                    nlive = nlive + 1
                 endif
                 ic = ic + 1
c-------------------
c  store record in
c  long vector
                 istrc = (ic-1)* nsamp
                 if (revers) then
                    call vmov (xtr,1,ctr,1,nsamp)
                    call rtape (luin,itr,nbytes)
                    call vmov  (itr(ITHWP1), 1, xtr, 1, nsamp)
                    call cvcomb (ctr,1,xtr,1,wrk2(istrc+1),2,nsamp)
                 else
                    call vmov (xtr,1,data(istrc+1),1,nsamp)
                 endif
c-------------------
c  save tr headers
                 ishdr = (ic-1)* ITRWRD
                 call vmov (itr, 1, itrh(ishdr+1), 1, ITRWRD)
 
   99      CONTINUE
   59      ntrk = ic
           if (ntrk .ne. ntr) then
               if (ntrk .eq. 0) go to 999
               write(LERR,*)'WARNING:'
               write(LERR,*)'read ',ntrk,' traces from record ',jj
               write(LERR,*)'instead of ',ntr
               write(LERR,*)'processing continuing'
c              ntro = ntrk
           endif
c--------------------------------------------------
c-------------------
c   do 2-d fft
              call fft2dee (data,nsamp,ntrc,ntpad,nxpad,wrk2,wrk6,
     1                      revers)
c------------------------------------------------
c  extract output
c  data from complex matrix, move bytes into
c  real output vector
           DO 199 KK = 1, ntro
c--------------------
c  get back headers
                 if (kk .le. ntro) then
                     ishdr = (kk-1) * ITRWRD
                     call vmov (itrh(ishdr+1), 1, itr, 1, ITRWRD)
                 endif
                 call savew2(itr,ifmt_TrcNum,l_TrcNum,
     1                       ln_TrcNum, kk , 1)
                 istrc = (kk-1) * ntpad
                 IF (revers) THEN
                    call vmov (data(istrc+1),1,itr(ITHWP1),1,nsampo)
                    CALL WRTAPE  ( LUOUT , ITR, OBYTES         )
                 ELSE
c----------------
c  extract reals
                    call vreal (wrk2(istrc+1),2,itr(ITHWP1),1,ntpad)
                    CALL WRTAPE  ( LUOUT , ITR, OBYTES         )
c----------------
c  extract imags
                    call vimag (wrk2(istrc+1),2,itr(ITHWP1),1,ntpad)
                    CALL WRTAPE  ( LUOUT , ITR, OBYTES         )
                 ENDIF
 
  199      CONTINUE
c------------------------------------------------
           if(verbos) then
              write(LERR,*) 'fft2d processed Record=  ',jj
           endif
c--------------------------------------------------
c  skip to the end of current record: trace # ntrc
c--------------------------------------------------
             call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
  100 CONTINUE
  999 continue
       call lbclos(luin)
       call lbclos(luout)
      END
c------------------------------
c  online help section
c------------------------------
      subroutine  help
#include <f77/iounit.h>
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for fft2d:  2-d fft'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-s[ist]    -- start time (ms)         (first samp)'
        write(LER,*)'-e[iend]   -- end time (ms)            (last samp)'
        write(LER,*)'-ns[ns]    -- start trace #                (first)'
        write(LER,*)'-ne[ne]    -- end trace #                   (last)'
        write(LER,*)'-rs[irs]   -- start record                 (first)'
        write(LER,*)'-re[ire]   -- end record                    (last)'
        write(LER,*)'-R         -- inverse transform'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        fft2d -N[] -O[] -s[] -e[] -ns[] -ne[]'
        write(LER,*)'             -rs[] -re[] -[-R] -V'
        write(LER,*)' '
      return
      end
c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ist   - I      start sample
c    iend   - I      stop sample
c     irs   - I      start record
c     ire   - I      stop end record
c      ns   - I      start trace
c      ne   - I      end trace
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,ist,iend,ns,ne,irs,ire,verbos,
     1                  revers)

#include <f77/iounit.h>

      character  ntap*(*), otap*(*)
      integer    argis,ist,iend,irs,ire,ns,ne
      logical    verbos, revers
          call argstr('-N',ntap,' ',' ') 
          call argstr('-O',otap,' ',' ') 
          call argi4('-s',ist,1,1)
          call argi4('-e',iend,0,0)
          call argi4('-ns',ns,1,1)
          call argi4('-ne',ne,0,0)
          call argi4('-rs',irs,1,1)
          call argi4('-re',ire,0,0)
          revers = (argis('-R') .gt. 0)
          verbos = (argis('-V') .gt. 0)
      return
      end
