C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fft2dee (rdata,nsamp,ntrc,nt,nx,cdata,work,
     1                     revers)

c  routine to do 2-d fft

c  input

c      rdata  -  matrix of real input data
c      nsamp  -  # samps in rdata
c       ntrc  -  # traces in rdata
c         nt  -  power of 2 time samples
c         nx  -  power of 2 # traces
c     revers  -  reverse transform

c output

c      cdata  -  matrix of complex transformed values
#include <f77/iounit.h>


      	integer	 nt, nx, nsamp, ntrc

      	real 	 rdata(nsamp,ntrc), work(*)
        complex  cdata(nt,nx)
        logical  revers


      	zero = 0.0
      	one = 1.0
      	two = 2.0
        nth = nt/2
        czero = cmplx(0.,0.)
        fnt = nt
        ntnyq = nt/2
        fnx = nx
        nxnyq = nx/2
        rntnx = 1./float(nt*nx)

c------------
c  	.. Fourier transform:  (t,x) --> (w,k)
        IF (.not.revers) THEN

            do  1  j = 1, ntrc
               do  2  i = 1, nsamp
                      cdata(i,j) = cmplx( rdata(i,j), 0.0 )
2              continue
1          continue

           call ft2d(nt,nx,cdata,1.,-1.,sqrt(1./fnt),sqrt(1./fnx),work)

        ELSE

           call ft2d(nt,nx,cdata,-1.,1.,sqrt(1./fnt),sqrt(1./fnx),work)

        ENDIF


c------------
c  scale 2-d fft
        do  10  j = 1, nx

                call cvsmul (cdata(1,j), 2, rntnx, cdata(1,j), 2, nt)

10      continue

        IF (revers) THEN

            do  5  j = 1, nx
               do  4  i = 1, nt
                      rdata(i,j) = real( cdata(i,j) )
4              continue
5          continue

        ENDIF


      return
      end
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
