C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine xt2ap(uin,uout,xomega,
     1                 xomegatr,hbegin,lenhed,lenwin,ntfft,
     2                 ntr,ntrwin,ns,ne,nxfft,ist,iend,maxt,liverec)

      integer hbegin

      real    uin(hbegin:maxt,ntr)       
      real    uout(hbegin:ntfft,-nxfft/2:nxfft/2-1)      
c
      complex  xomega(ntfft/2,nxfft)
      complex  xomegatr(nxfft,ntfft/2)
      logical  liverec
c__________________________________________________________________
c     copy trace headers from input data to output data.
c     copy last trace header into padded zone.
c__________________________________________________________________
      itrout=-nxfft/2-1
      do 5000 itr=ns,ne                     
       itrout=itrout+1       
       call vmov(uin(hbegin,itr),1,uout(hbegin,itrout),1,lenhed)
5000  continue
      itrnext=itrout+1
      do 7000 itrout=itrnext,nxfft/2-1      
       call vmov(uin(hbegin,ne),1,uout(hbegin,itrout),1,lenhed)
7000  continue
      if(.not. liverec) then
c___________________________________________________________________
c        dead record. zero the output and return.                   
c___________________________________________________________________
         do 9000 kx=-nxfft/2,+nxfft/2-1
          do 8000 j=1,ntfft
           uout(j,kx)=0.
8000      continue
9000     continue
         return
      endif
c___________________________________________________________________
c     move data up and zero out end of array.                       
c___________________________________________________________________
      do 10000 itr=ns,ne    
       call vmov(uin(ist,itr),1,uin(1,itr),1,lenwin)
       call vclr(uin(lenwin+1,itr),1,ntfft-lenwin)
10000 continue
c___________________________________________________________________
c     transform from t --> omega (out of place)       
c___________________________________________________________________
      itrout=0
      do 20000 itr=ns,ne    
       itrout=itrout+1
       call rfftb(uin(1,itr),xomega(1,itrout),ntfft,+1)
       call rfftsc(xomega(1,itrout),ntfft,2,1)
20000 continue
c___________________________________________________________________
c     transpose data.                                 
c     zero out extra traces to allow for fft.   
c___________________________________________________________________
      do 40000 iomega=1,ntfft/2
       do 30000 ix=1,ntrwin 
        xomegatr(ix,iomega)=xomega(iomega,ix)
30000  continue
       do 35000 ix=ntrwin+1,nxfft
        xomegatr(ix,iomega)=(0.,0.)
35000  continue
40000 continue
c___________________________________________________________________
c     transform from x --> kx (in place)              
c___________________________________________________________________
      do 60000 iomega=1,ntfft/2
       call cfft(xomegatr(1,iomega),nxfft,+1) 
       call cfftsc(xomegatr(1,iomega),nxfft)
60000 continue
c___________________________________________________________________
c     remap principle period from (1:nxfft) to (-nxfft/2:nxfft/2-1)
c     copy data in upside down.
c     pack amplitude in positions (1:ntfft/2)
c     pack phase     in positions (ntfft/2+1:ntfft)
c___________________________________________________________________
      do 80000 kx=1,nxfft
       if(kx .gt. nxfft/2) then
          kxout=kx-nxfft-1   
       else
          kxout=kx-1
       endif
       iamp=ntfft/2+1
       iphase=ntfft+1
       do 70000 iomega=1,ntfft/2 
        iamp=iamp-1           
        iphase=iphase-1       
        uout(iamp,kxout)=abs(xomegatr(kx,iomega))
        if(uout(iamp,kxout) .eq. 0.) then
           uout(iphase,kxout)=0.
        else
           uout(iphase,kxout)=
     1     atan2(aimag(xomegatr(kx,iomega)),real(xomegatr(kx,iomega))) 
        endif
70000  continue
80000 continue
c
      return
      end
