C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fft2dee (rdata,nsamp,ntrc,nt,ntt,nx,
     1                    lenitabt,lenrtabt,rtabt,rtabx,itabt,
     2                    itabx,ipwrt,ipwrx,cdata,initt,initx,
     3                    lenitabx,lenrtabx)

c  routine to do 2-d fft

c  input

c      rdata  -  matrix of real input data
c      nsamp  -  # samps in rdata
c       ntrc  -  # traces in rdata
c         nt  -  power of 2 time samples
c         nx  -  power of 2 # traces
c     revers  -  reverse transform

c output

c      cdata  -  matrix of complex transformed values
#include <f77/iounit.h>
#include <f77/lhdrsz.h>


      	integer	 nt, nx, nsamp, ntrc, ntt

      	real 	 rdata(ntt, nx)
        complex  cdata(nt , nx)
      	real 	 rtabt (lenrtabt), rtabx (lenrtabx)
        integer  itabt (lenitabt), itabx (lenitabx)
        integer  ipwrt (4), ipwrx (4)
        complex  workc(2*SZLNHD)

        ntmid = ntt / 2
        nxmid = nx  / 2
c------------
c  	.. Fourier transform:  (y,x) --> (ky,kx)

        do  j = 1, nx
           do  i = 1, nt
              cdata (i,j) = cmplx (0.,0.)
           enddo
        enddo
        do  i = 1, nt
           workc (i) = cmplx (0.0, 0.0)
        enddo

        do     j = 1, ntrc
           do     i = 1, nsamp
              workc (i) = cmplx (rdata(i,j), 0.0)
           enddo
           do     i = nsamp+1, nt
              workc (i) = cmplx (0.0, 0.0)
           enddo
           
c----
c   power of 2 Math Adv calls
c              call  cfft  (workc, nt, +1)
c              call cfftsc (workc, nt)

c----
c   equivalent
c   mixed radix call
c   in dimension T
c   (transform & normalization)
c   (init must = 1 first time through to build sine & cos tables)
c----
           call cfftm  (workc, 2, nt, 1, initt, itabt, rtabt, ierr)
           initt = 0
           call cfftss (workc, 2, nt)

           do  i = 1, nt
              cdata (i,j) = workc(i)
           enddo
        enddo

        do  i = 1, nt
           workc (i) = cmplx (0.0, 0.0)
        enddo


        do  i = 1, nt
           do  j = 1, nx
              workc(j) = cdata(i,j)
           enddo

c----
c   power of 2 Math Adv calls
c              call cfft   (workc, nx, +1)
c              call cfftsc (workc, nx)

c----
c   equivalent
c   mixed radix call
c   in dimension X
c   (transform & normalization)
c   (init must = 1 first time through to build sine & cos tables)
c----
           call cfftm  (workc, 2, nx, 1, initx, itabx, rtabx, ierr)
           initx = 0
           call cfftss (workc, 2, nx)

           do  j = 1, nx
              cdata (i, j) = workc (j)
           enddo
        enddo

        do  kx = 1, nx

           if (kx .gt. nxmid) then
              kxout = kx - nxmid
           else

c if nx/2 is non-integer the mapping needs to change slightly.  The following
c checks the modulus 2 of nx and reacts accordingly.
             
              if ( mod(nx,2) .gt. 0 ) then
                 kxout = nxmid + kx + 1
              else
                 kxout = nxmid + kx
              endif
           endif
           ix = kxout

           do  kt = 1, nt

              if (kt .gt. nt/2) then

c if nt/2 is non-integer the mapping needs to change slightly.  The following
c checks the modulus 2 of nt and reacts accordingly.

                 if ( mod(nt,2) .gt. 0 ) then
                    ktout = kt - nt/2 - 1
                 else
                    ktout = kt - nt/2 
                 endif
              else
                 ktout = nt/2 + kt
              endif

              if ( mod(nt,2) .gt. 0 ) then
                 iamp   = nt  - ktout
                 iphase = ntt - ktout
              else
                 iamp   = nt  - ktout + 1
                 iphase = ntt - ktout + 1
              endif

              rdata(iamp, ix  ) = cabs ( cdata(kt,kx) )

              if (rdata(iamp, ix  ) .eq. 0.) then
                 rdata(iphase, ix  ) = 0.
              else
                 rdata(iphase, ix  ) =
     1                atan2 ( aimag(cdata(kt,kx)),
     2                real(cdata(kt,kx))  )
              endif
           enddo
        enddo

      return
      end
