C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C     PROGRAM MODULE  fftxy
C
C
C fftxy READS SEISMIC TRACE DATA FROM AN INPUT FILE, record-by-record,
C performs a mixed radix forward or reverse fft and writes the results 
c to otap.
c
c--------------------------------------------------------------------
c
c Changes
c
c June 1/95 : added mod(nt,2), mod(nx,2) logic to fft2dee and fft2ree
c             to prevent erroneous array mapping when using mixed radix
c             algorithm.[Garossino]
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( 2*SZLNHD )
      INTEGER     LHED( 2*SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LBYTES, NBYTES,obytes
      integer     argis
      integer     nsampo, irs, ire
      integer     errcod, abort, ipwrt (4), ipwrx (4)

      REAL        xtr(2*SZLNHD), data, rtabt, rtabx
      complex     wrk1
      integer     itrh, itabt, itabx
      pointer     (wkaddr , data (1))
      pointer     (wkadr1 , wrk1 (1))
      pointer     (wkitrh , itrh (1))
c----
c   mixed radix allocs
c----
      pointer     (wkitabt, itabt(1))
      pointer     (wkitabx, itabx(1))
      pointer     (wkrtabt, rtabt(1))
      pointer     (wkrtabx, rtabx(1))

      CHARACTER   NAME * 5, ntap * 256, otap * 256
      CHARACTER   domain * 2
#include <f77/pid.h>
      logical     verbos,query,heap,first,revers
 
c     EQUIVALENCE ( ITR(129), xtr (1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'FFTXY'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /
      DATA first/.true./

c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help ()
           stop
      endif

c------------------------------------
c  open printout file
c------------------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE ARGUMENT STRING
C**********************************************************************C
      call cmdln (ntap,otap,irs,ire,verbos,
     1            revers)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )

      lbytes = 0
      call rtape ( luin, itr, lbyte )
      lbytes = lbyte
      if(lbytes .eq. 0) then
         write(LERR,*)'FFTXY: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt    ( ITR , LBYTE, NAME, 5, LERR        )

c---------------------------------
c  save key header values
#include <f77/saveh.h>
      if(nsamp .gt. 2*SZLNHD) nsamp=2*SZLNHD
c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c----------------------------------

c-----
c     ensure that command line values are compatible with data set
c-----
      if (irs .le. 1) irs = 1
      if (ire .gt. nrec) irs = nrec
      if (ire .lt. 1) ire = nrec
      if (irs .gt. ire) then
         write(LER,*)'FATAL: start rec cannot be > end rec'
         stop
      endif

      nrecc  = ire-irs+1
      nsampo = nsamp

c---------------------------
c  check to see if
c  samp int is in micro secs

      dt = float(nsi) * unitsc
      call saver( itr, 'DgTrkS', domain, LINHED)


      IF (revers) THEN

         if (domain .ne. 'kk') then
            write(LERR,*)'Input data set not result of a forward'
            write(LERR,*)'fftxy.  This is a fatal error'
            stop
         endif
         call saver( itr, 'OrNTRC',   ntrco , LINHED)
         call saver( itr, 'OrNSMP',   nsampo, LINHED)

         nfft  = nsamp
         nffx  = ntrc

         nt    = nsamp / 2
         nt2   = nsamp
         nx    = ntrc

         domain = 'xt'

      ELSE

c----
c   get power of 2, 3, or 5 from input X & T lengths for mixed radix
c   FFTs
c----
         nfftmin = 1.01 * nsamp
         nffxmin = 1.01 * ntrc
         call ncfft(nfftmin,5,nfft ,ipwrt)
         call ncfft(nffxmin,5,nffx ,ipwrx)

         write(LERR,*)' '
         write(LERR,*)'Y/T Direction Radix Powers:'
         write(LERR,*)(ipwrt(ii),ii=1,4)
         write(LERR,*)' '
         write(LERR,*)'X   Direction Radix Powers:'
         write(LERR,*)(ipwrx(ii),ii=1,4)
         write(LERR,*)' '

         nt    = nfft
         nt2   = 2 * nfft
         nx    = nffx

         ntrco  = nx
         nsampo = nt2
         domain = 'kk'

      ENDIF

c----
c  lengths of sime & cos tables are alloc'd based on the max of the
c  x & t dimensions
c----
c     if(SZSMPD .eq. 4) then
         lenitabt = 2 * nfft + 34
         lenrtabt = 2 * nfft + 13
         lenitabx = 2 * nffx + 34
         lenrtabx = 2 * nffx + 13
c     else
c        lenitab = max (2*max(nfft,nffx), max(nfft,nffx) + 34)
c        lenrtab = max (2*max(nfft,nffx), 3*(max(nfft,nffx)/2) + 13)
c     endif

c------------------------------------------------------
c  save headers: exchange # traces/rec & # samples/rec
       call savew( itr, 'NumRec', nrecc , LINHED)
       call savew( itr, 'DgTrkS', domain, LINHED)

       if (revers) then
          call savew( itr, 'NumTrc',   ntrco , LINHED)
          call savew( itr, 'NumSmp',   nsampo, LINHED)
       else
          call savew( itr, 'OrNTRC',   ntrc  , LINHED)
          call savew( itr, 'NumSmp',   nsampo, LINHED)
          call savew( itr, 'NumTrc',   ntrco , LINHED)
          call savew( itr, 'OrNSMP',   nsamp , LINHED)
       endif

c----------------------------------------------------------------
c  change output bytes to reflect change from real to cmplx values
          obytes = SZTRHD + SZSMPD * nsampo

c---------------------------------
c  verbos printout
c     if(verbos) then
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc
        write(LERR,*) ' Records per Line   =  ', nrec
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' FFT pad # samples (Y) =  ', nfft
        write(LERR,*) ' FFT pad # samples (X) =  ', nffx
        write(LERR,*) ' FFT int  table length = ', lenitabt,lenitabx
        write(LERR,*) ' FFT flt  table length = ', lenrtabt,lenrtabx
        write(LERR,*) ' Output # traces    =  ', ntrco
        write(LERR,*) ' Output # samples   =  ', nsampo
        write(LERR,*) ' Output records     =  ', nrecc
        write(LERR,*) ' Reverse Transform? =  ', revers
c     endif

c-----------------------------------------------
c  adjust historical line header & write header
      call savhlh ( itr, lbyte, lbyout )
 
      call wrtape(luout,itr,lbyout)

c------------------------------------------------
c  skip to start record
      call recskp(1,irs-1,luin,ntrc,itr)

c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

      itemi = nx * ITRWRD
      itemd = nx * nt2
      itemc = nx * nt * 2

      call galloc (wkitrh, itemi*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkaddr, itemd*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkadr1, itemc*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkitabt, lenitabt*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkitabx, lenitabx*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkrtabt, lenrtabt*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkrtabx, lenrtabx*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi*SZSMPD,'  bytes'
         write(LERR,*) itemd*SZSMPD,'  bytes'
         write(LERR,*) itemc*SZSMPD,'  bytes'
         write(LERR,*) lenitabt*SZSMPD,'  bytes'
         write(LERR,*) lenitabx*SZSMPD,'  bytes'
         write(LERR,*) lenrtabt*SZSMPD,'  bytes'
         write(LERR,*) lenrtabx*SZSMPD,'  bytes'
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) itemi*SZSMPD,'  bytes'
         write(LER ,*) itemd*SZSMPD,'  bytes'
         write(LER ,*) itemc*SZSMPD,'  bytes'
         write(LER ,*) lenitabt*SZSMPD,'  bytes'
         write(LER ,*) lenitabx*SZSMPD,'  bytes'
         write(LER ,*) lenrtabt*SZSMPD,'  bytes'
         write(LER ,*) lenrtabx*SZSMPD,'  bytes'
         go to 999
      else
         write(LERR,*)'Allocated workspace:'
         write(LERR,*) itemi*SZSMPD,'  bytes'
         write(LERR,*) itemd*SZSMPD,'  bytes'
         write(LERR,*) itemc*SZSMPD,'  bytes'
         write(LERR,*) lenitabt*SZSMPD,'  bytes'
         write(LERR,*) lenitabx*SZSMPD,'  bytes'
         write(LERR,*) lenrtabt*SZSMPD,'  bytes'
         write(LERR,*) lenrtabx*SZSMPD,'  bytes'
      endif
c---------------------------------------------------

C**********************************************************************C
C
C     READ RECORD, DO 2-D FFT, WRITE OUTPUT RECORD
C
C**********************************************************************C
 
      DO 100 JJ = irs, ire

c--------------------------------------------------
c  read record & store
c----------------------
           initt = 1
           initx = 1
           nlive = 0
           ic    = 0

           DO 99 KK = 1, ntrc

                 nbytes = 0
                 CALL RTAPE  ( LUIN , ITR, NBYTES         )
                 if(nbytes .eq. 0) then
                    write(LERR,*)'WARNING'
                    write(LERR,*)'End of file on input:'
                    write(LERR,*)'  rec= ',jj,'  trace= ',kk
                    go to 999
                 endif
                  call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)
                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istatic, TRACEHEADER)

                 call detmut (xtr, im, nsamp)
                 if (im .eq. nsamp) istatic = 30000

                 if (istatic .eq. 30000) then
                    call vclr (xtr,1,nsamp)
                    if (.not.revers)
     1              call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     2                          30001  , TRACEHEADER)
                 else
                    nlive = nlive + 1
                 endif
                 ic = ic + 1
c-------------------
c  store record in
c  long vector
                 istrc = (ic-1) * nt2
                 ishdr = (ic-1) * ITRWRD

                 call vmov (lhed,1, itrh(ishdr+1),1,ITRWRD)

                 call vmov (xtr,1,data(istrc+1),1,nsamp)

   99      CONTINUE

c--------------------------------------------------

c-------------------
c   do 2-d fft unless the record or slice has no live samples

           IF ( nlive .gt. 0 ) THEN

             if (revers) then

                 call fft2ree (data,nsampo,ntrco,nt,nt2,nx,
     1                         lenitabt,lenrtabt,rtabt,rtabx,itabt,
     2                         itabx,ipwrt,ipwrx,wrk1,initt,initx,
     3                         lenitabx,lenrtabx)
              else

                 call fft2dee (data,nsamp,ntrc,nt,nt2,nx,
     1                         lenitabt,lenrtabt,rtabt,rtabx,itabt,
     2                         itabx,ipwrt,ipwrx,wrk1,initt,initx,
     3                         lenitabx,lenrtabx)
              endif

           ELSE

              call vclr (data, 1, itemd)

           ENDIF
c------------------------------------------------
c  extract output
c  data from complex matrix, move bytes into
c  real output vector

           DO 199 KK = 1, ntrco

c--------------------
c  get back headers
                 ishdr = (kk-1) * ITRWRD
                 call vmov (itrh(ishdr+1),1,lhed,1,ITRWRD)

                 if (revers) then
                    call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          istatic, TRACEHEADER)
                    if (istatic .eq. 30001)
     1              call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          30000  , TRACEHEADER)
                 endif

                 istrc = (kk-1) * nt2

                 call vmov (data(istrc+1),1,lhed(ITHWP1),1,nsampo)
                 CALL WRTAPE  ( LUOUT , ITR, OBYTES         )
 
  199      CONTINUE
c------------------------------------------------

           if(verbos) then
              write(LERR,*) 'fftxy processed Record=  ',jj
           endif

  100 CONTINUE

  999 continue
       call lbclos(luin)
       call lbclos(luout)
      END

c------------------------------
c  online help section
c------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for fftxy:  2-d fft'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-rs[irs]   -- start record                 (first)'
        write(LER,*)'-re[ire]   -- end record                    (last)'
        write(LER,*)'-R         -- inverse transform'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        fftxy -N[] -O[] '
        write(LER,*)'             -rs[] -re[] -[-R] -V'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ist   - I      start sample
c    iend   - I      stop sample
c     irs   - I      start record
c     ire   - I      stop end record
c      ns   - I      start trace
c      ne   - I      end trace
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,irs,ire,verbos,
     1                  revers)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      integer    argis,irs,ire
      logical    verbos, revers

          call argstr('-N',ntap,' ',' ') 
          call argstr('-O',otap,' ',' ') 
          call argi4('-rs',irs,1,1)
          call argi4('-re',ire,0,0)
          revers = (argis('-R') .gt. 0)
          verbos = (argis('-V') .gt. 0)

      return
      end
