C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gaussj (a, n, np, b, m, mp)

#include <f77/iounit.h>

c   linear equation solver by gauss-jordan elimination of

c                    AX = B

c   A is NxN input matrix stored in physical dimension array NPxNP
c   B is an input matrix NPxMP.
c   on output A is replaced by by its matrix inverse and B is replaced
c   by the matrix of solution vectors X

      parameter (nmax = 50)

      dimension A(np,np), B(np,mp), ipiv(nmax), indxr(nmax), indxc(nmax)

      do  11  j = 1, n
          ipiv(j) = 0
11    continue

      do  22  i = 1, n
          big = 0.
          do  13  j = 1, n
              if (ipiv(j) .ne. 1) then
                 do  12  k = 1, n
                     if (ipiv(k) .eq. 0) then
                        if (abs(A(j,k)) .ge. big) then
                           big = abs(A(j,k))
                           irow = j
                           icol = k
                        endif
                     elseif( ipiv(k) .gt. 1) then
                       write(LERR,*)'subroutine gaussj: singular matrix'
                       return
                     endif
12               continue
              endif
13        continue

          ipiv(icol) = ipiv(icol) + 1

          if (irow .ne. icol) then
             do  14  L = 1, n
                 dum = A(irow, L)
                 A(irow, L) = A(icol, L)
                 A(icol, L) = dum
14           continue

             do  15  L = 1, m
                 dum = B(irow, L)
                 B(irow, L) = B(icol, L)
                 B(icol, L) = dum
15           continue
          endif

          indxr(i) = irow
          indxc(i) = icol
          if (A(icol,icol) .eq. 0.) then
             write(LERR,*)'subroutine gaussj: singular matrix'
             return
          endif

          pivinv = 1./A(icol,icol)
          A(icol,icol) = 1.

          do  16  L = 1, n
              A(icol, L) = A(icol, L) * pivinv
16        continue

          do  17  L = 1, m
              B(icol, L) = B(icol, L) * pivinv
17        continue

          do  21  LL = 1, n
              if (LL .ne. icol) then
                 dum = A(LL,icol)
                 A(LL,icol) = 0.
                 do  18  L = 1, n
                     A(LL,L) = A(LL,L) - A(icol,L) * dum
18               continue

                 do  19  L = 1, m
                     B(LL,L) = B(LL,L) - B(icol,L) * dum
19               continue

              endif
21        continue

22    continue

      do  24  L = n, 1, -1
          if (indxr(L) .ne. indxc(L)) then
             do  23  k = 1, n
                 dum = A(k,indxr(L))
                 A(k,indxr(L)) = A(k,indxc(L))
                 A(k,indxc(L)) = dum
23           continue
          endif
24    continue

      return
      end
      
