C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      Program fk
c______________________________________________________________________
c     Least Square Discrete F-K Transform for Unequally Spaced Seismic
c     Data.
c
c     Kurt J. Marfurt, Tulsa EPTG.
c     March 23, 1996
c______________________________________________________________________
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      parameter (maxs=0 000 002)
      parameter (pi=3.1415926)
      dimension s(maxs)
      pointer   (pntrs,s)

      integer     hbegin
      integer     sheader(SZLNHD)

      integer     argis, ordfft

      character*256 file_in,file_out     
      character*2 name
      character*2 domain
      real        cputim(20),waltim(20)
#include <f77/pid.h>
c
      logical     verbose,query,revers,interpolate,liverec
      logical     eod,forward,smooth,nomute,cost_leader
 
      data name     /'FK'/                                 
c_______________________________________________________________
c     initialize timing arrays.
c_______________________________________________________________
      do 10000 j=1,20
       cputim(j)=0.
       waltim(j)=0.
10000 continue
      call timstr(vtot,wtot)
      call timstr(v1,w1)
c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help ()
           stop
      endif
c------------------------------------
c  open printout file
c------------------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE ARGUMENT STRING
C**********************************************************************C
c__________________________________________________________________
c     be sure -spread option is searched for before -s option!
c     (longer one first)
c__________________________________________________________________
      call argstr('-N',file_in,' ',' ')
      call argstr('-O',file_out,' ',' ')
      call argr4('-spread',spread,0.,0.)
      call argr4('-dxmin',dxmin,0.,0.)  
      call argr4('-prew',white,5.,5.)
      call argi4('-s',ist,1,1)
      call argi4('-e',iend,0,0)
      cost_leader=(argis('-CL') .gt. 0)
      revers=(argis('-R') .gt. 0)
      smooth=(argis('-S') .gt. 0)
      nomute=(argis('-nomute') .gt. 0)
      interpolate=(argis('-I') .gt. 0)
      verbose=(argis('-V') .gt. 0)
      forward=.not. revers
      white=.01*white
C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
c_______________________________________________________________________
c     forward transform
c_______________________________________________________________________
      call getln(luin,file_in,'r',0 )
      call getln(luout,file_out,'w',1 )

      lbytes = 0
      call rtape(luin,sheader,lbyte)
      lbytes = lbyte
      if(lbytes .eq. 0) then
         write(lerr,*)'FK: no header read on unit ',file_in
         write(lerr,*)'FATAL'
         write(lerr,*)'Check existence of file & rerun'
         stop
      endif
      call hlhprt(sheader,lbyte,name,len(name),lerr)
c
c______________________________________________________________________
c     read off relevant arguments from line header
c______________________________________________________________________
      call saver(sheader,'NumRec',nrec,LINEHEADER)
      call saver(sheader,'NumSmp',nsamp,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      call saver(sheader, 'UnitSc', unitsc, LINEHEADER)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(sheader, 'UnitSc', unitsc, LINEHEADER)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('MulSkw',ifmt_MulSkw,l_MulSkw,ln_MulSkw,TRACEHEADER)
 
      hbegin=1-ITRWRD
c
c     check to see if samp int is in micro secs
c______________________________________________________________________
      dt = float(nsi) * unitsc
      if(ire .lt. 1) ire=nrec
      ist=ist/nsi
      iend=iend/nsi
      if(ist .le. 0) ist=1
c______________________________________________________________________
c     save headers:
c     store original number of traces  under keyword 'OrNTRC'
c     store original number of samples under keyword 'TmSlIn'
c______________________________________________________________________
      call savew(sheader,'NumRec',nrec,LINEHEADER)
      if (revers) then
         ntfft = nsamp
         call saver( sheader,'OrNTRC',ntr,LINEHEADER)
         call saver(sheader,'TmSlIn',nsamp,LINEHEADER)
         call saver(sheader,'NmSpMi',spread,LINEHEADER)
         call saver(sheader,'NumTrc',nkx,LINEHEADER)
         if(iend .lt. 1) iend=nsamp
         lenwin=iend-ist+1
      else
         call saver(sheader,'NumTrc',ntr,LINEHEADER)
         if(iend .lt. 1) iend=nsamp
         lenwin=iend-ist+1
         nu = ordfft(lenwin)
         ntfft = 2 ** nu
      endif
      
      if(spread .le. 0.) then
         if(revers) then
            write(lerr,*) 'error lineheader values NmSpMi !'
            write(lerr,*) 'if you ran forward transform '
     1             //'before 3/18/93'
            write(lerr,*) 'please rerun and send hate mail to zkjm01'
            write(lerr,*) 'or use utop to put spread in NmSpMi'  
            write(lerr,*) 'header changed to accomidate long spreads'
         else
            write(lerr,*) 'error in command line argument!'
         endif
         write(lerr,*) 'spread must be a positive number!'      
         write(lerr,*) 'spread entered as : ',spread              
         close(lerr)
         call exit(666)
      endif
c______________________________________________________________________
c     calculate average trace spacing.
c______________________________________________________________________
      if(ntr .gt. 1) then
         dxavg=spread/(ntr-1)
      else
         write(lerr,*) 'error in routine fk!'
         write(lerr,*) 'cannot take an fk filter of single trace'
     1                 //' records!'
         call exitfu(1666)
      endif
      if(dxmin .le. 0.) then
         dxmin=dxavg
      endif
      dk=pi/spread    
      if(.not. revers) then
         wavelength_min=2.*dxmin
         akxmax=pi/wavelength_min
         kmax=nint(akxmax/dk)
         kmin=-kmax         
         nkx=kmax-kmin+1
      else
         kmax=nkx/2
         kmin=-nkx/2
      endif

       
c
      if (revers) then
         domain='xt'
         call savew(sheader,'DgTrkS',domain,LINEHEADER)
         call savew(sheader,'NumSmp',nsamp,LINEHEADER)
         call savew(sheader,'NumTrc',ntr,LINEHEADER)
      else
         domain='fk'
         call savew(sheader,'DgTrkS',domain,LINEHEADER)
         call savew( sheader,'TmSlIn',nsamp,LINEHEADER)
         call savew( sheader,'NumSmp',ntfft,LINEHEADER)
         call savew( sheader,'NumTrc',nkx,LINEHEADER)
         call savew( sheader,'OrNTRC',ntr,LINEHEADER)
         call savew( sheader,'NmSpMi',spread,LINEHEADER)
      endif
c
      maxt=max(ntfft,iend,nsamp)
c______________________________________________________________________
c     print relevant variables.
c______________________________________________________________________
        write(lerr,*) 
        write(lerr,*) 'files'         
        write(lerr,*) 'file_in : ',file_in    
        write(lerr,*) 'file_out : ',file_out    
        write(lerr,*)
        write(lerr,*)' Values read from input data set line header'
        write(lerr,*)
        write(lerr,*) ' samples/trace      =  ', nsamp
        write(lerr,*) ' start sample       =  ', ist  
        write(lerr,*) ' end   sample       =  ', iend 
        write(lerr,*) ' samples in window  =  ', lenwin
        write(lerr,*) ' fft length in time =  ', ntfft 
        write(lerr,*) ' trace buffer length=  ', maxt  
        write(lerr,*)
        write(lerr,*) ' Sample Interval    =  ', nsi  
        write(lerr,*) ' Traces per Record  =  ', ntr
        write(lerr,'(a40,f12.3)') 'spread',spread,'dxavg',dxavg,
     1                            'dxmin',dxmin 
        write(lerr,*) ' nkx              =  ', nkx 
        write(lerr,*) ' kmin               =  ', kmin
        write(lerr,*) ' kmax               =  ', kmax
        write(lerr,*) ' minimum wavenumber =  ', kmin*dk 
        write(lerr,*) ' maximum wavenumber =  ', kmax*dk 
        write(lerr,*) ' wavenumber increment= ', dk 
        write(lerr,*) ' prewhitening       =  ', white*100
        write(lerr,*) ' delta   wavenumber =  ', dk    
        write(lerr,*) ' Records per Line   =  ', nrec
        if (revers) then
           write(lerr,*) ' Output # traces    =  ', ntr
           write(lerr,*) ' Output # samples   =  ', nsamp
        else
           write(lerr,*) ' Output # traces    =  ', nkx
           write(lerr,*) ' Output # samples   =  ', ntfft
        endif
      write(lerr,*) ' Output records     =  ', nrec
      write(lerr,*) ' Reverse Transform? =  ', revers
      write(lerr,*) ' dont be a cost leader (use least squares)?',
     1                cost_leader
      write(lerr,*) ' dont apply early mutes?     ',nomute
      write(lerr,*) ' smooth early mutes ?         ',smooth
c______________________________________________________________________
c     adjust historical line header & write header
c______________________________________________________________________
      call savhlh(sheader,lbyte,lbyout )
      call wrtape(luout,sheader,lbyout)
c______________________________________________________________________
c     calculate memory requirements
c     keep data buffered out to fft sizes, even if we don't need them.
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
      lenu =nkx*(maxt+ITRWRD)
      lenwork=ntfft*nkx       
      lenf=2*nkx*nkx            
c____________________________________________________________________
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('uin',l_uin,l_free,lenu,lerr)
      call mapmem('uout',l_uout,l_free,lenu,lerr)
      call mapmem('ufx',l_ufx,l_free,lenwork,lerr)
      call mapmem('ufk',l_ufk,l_free,lenwork,lerr)
      call mapmem('udft',l_udft,l_free,lenwork,lerr)
      call mapmem('dist',l_dist,l_free,ntr,lerr)                     
      call mapmem('xtemp',l_xtemp,l_free,ntr,lerr)                     
      call mapmem('iorder',l_iorder,l_free,ntr,lerr)                     
      call mapmem('xwgt',l_xwgt,l_free,nkx,lerr)                     
      call mapmem('live',l_live,l_free,ntr,lerr)                     
      call mapmem('delf',l_delf,l_free,2*nkx,lerr)                     
      call mapmem('f',l_f,l_free,lenf,lerr)                     
      call mapmem('ftf',l_ftf,l_free,nkx,lerr)                     
      call mapmem('muteend',l_muteend,l_free,nkx,lerr)
      call mapmem('mutesm',l_mutesm,l_free,nkx,lerr)
      call mapmem('u',l_u,l_free,ntfft*nkx,lerr)
      call mapmem('s',l_s,l_free,ntfft*nkx,lerr)
      call mapmem('v',l_v,l_free,ntfft,lerr)
      call mapmem('r',l_r,l_free,ntfft,lerr)
      call mapmem('rc',l_rc,l_free,ntfft,lerr)
      call mapmem('e',l_e,l_free,ntfft,lerr)
      call mapmem('ec',l_ec,l_free,ntfft,lerr)
      call mapmem('temp',l_temp,l_free,ntfft,lerr)
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)
         write(lerr,*)'program FK aborted'
         stop 101
      endif
c_____________________________________________________________
c     calculate length of trace in integer*2 words.
c     calculate number of bytes in output trace
c     calculate trace header position of key variables.
c_____________________________________________________________
c     lenu2=lntrhd+maxt*i2fact
      lenu2=ITRWRD+maxt
      if(revers) then
         nbyptr=(nsamp+ITRWRD)*szsmpd
      else
         nbyptr=(ntfft+ITRWRD)*szsmpd
      endif
      lentr2=ITRWRD+maxt

c
      if(revers) then
c________________________________________________________________
c        clear out all traces.
c        reverse transformed traces will overwrite the window 
c        window (ist:iend,ns:ne)
c________________________________________________________________
         call clrgather(s(l_uin),hbegin,maxt,ntr)
      endif
      do 50000 jrec=1,nrec  
c________________________________________________________________
c      read in seismic gather.
c________________________________________________________________
       call timstr(v1,w1)
       call rdgather(s(l_uin),s(l_uin),hbegin,maxt, 
     1               lenu2,ntr,luin,lerr,eod,itr,jrec,
     2               s(l_dist),s(l_live),s(l_xwgt),interpolate,
     3               s(l_xtemp),s(l_iorder),liverec,
     4               l_StaCor,l_RecNum,l_DstSgn,l_MulSkw,
     5               ifmt_StaCor,ifmt_RecNum,ifmt_DstSgn,ifmt_MulSkw,
     6               ln_StaCor,ln_RecNum,ln_DstSgn,ln_MulSkw,
     7               spread,irecnum,revers,forward,nsamp)                   
       call timend(cputim(1),v1,v2,waltim(1),w1,w2)
       if(eod) then       
          write(lerr,*)'error!'  
          write(lerr,*)'read ',itr,' traces from record ',jrec,
     1                 ' instead of ',ntr  
          write(lerr,*)'file unit number = ',luin
          write(lerr,*)'file name = ',file_in   
          go to 99000
       endif
       if(verbose) write(lerr,*) 'process record ',jrec,
     1                                ' liverec =',liverec
       if(liverec) then
          if(forward) then
c________________________________________________________________
c            forward fft from (x,t) to (kx,omega)
c________________________________________________________________
             call xt2ap(s(l_uin),s(l_uout),s(l_ufx),s(l_udft),
     1                  hbegin,ITRWRD,lenwin,ntfft,
     2                  ntr,nkx,ist,iend,maxt,
     3                  s(l_ufk),s(l_f),s(l_delf),s(l_live),
     4                  kmin,kmax,s(l_xwgt),dk,s(l_dist),jrec,
     5                  s(l_s),s(l_v),s(l_r),s(l_e),s(l_ec),
     6                  s(l_temp),s(l_rc),s(l_ftf),cost_leader,
     7                  white,cputim,waltim,verbose)
       else
c________________________________________________________________
c            inverse fft from (kx,omega) to (x,t)
c________________________________________________________________
             call ap2xt(s(l_uin),s(l_uout),s(l_uout),s(l_ufx),
     1                  hbegin,ITRWRD,lenwin,ntfft,lentr2,
     2                  ntr,nkx,ist,iend,maxt,
     3                  s(l_ufk),s(l_f),s(l_delf),s(l_live),
     4                  kmin,kmax,s(l_xwgt),dk,s(l_dist),l_MulSkw)
          endif 
       endif 
c________________________________________________________________
c      update trace headers
c      output data
c________________________________________________________________
       if(.not. revers) then
          call hdupdatf(s(l_uout),kmin,kmax,dk,irecnum,
     1                  l_recnum,l_trcnum,l_stacor,l_DstUsg,lenu2,
     2                  ifmt_StaCor,ifmt_RecNum,ifmt_DstUsg,ifmt_TrcNum,
     3                  ln_StaCor,ln_RecNum,ln_DstUsg,ln_TrcNum)

          call timstr(v1,w1)
          call wrgather(s(l_uout),s(l_uout),hbegin,maxt,
     1               s(l_mutesm),s(l_muteend),forward,smooth,nomute,
     2                  lentr2,nkx,nbyptr,luout,l_MulSkw,
     3                  ifmt_MulSkw,ln_MulSkw)
          call timend(cputim(2),v1,v2,waltim(2),w1,w2)
       else
          call hdupdat(s(l_uout),ntr,irecnum,1, 
     1                 l_recnum,l_trcnum,l_stacor,lenu2,
     2                 ifmt_StaCor,ifmt_RecNum,ifmt_TrcNum,
     3                 ln_StaCor,ln_RecNum,ln_TrcNum)
          call timstr(v1,w1)
          call wrgather(s(l_uout),s(l_uout),hbegin,maxt,
     1              s(l_mutesm),s(l_muteend),forward,smooth,nomute,
     2                  lentr2,ntr,nbyptr,luout,l_MulSkw,
     3                  ifmt_MulSkw,ln_MulSkw)
          call timend(cputim(2),v1,v2,waltim(2),w1,w2)
       endif
50000 continue
99000 continue
c_____________________________________________________________
c     write out timing statistics.
c_____________________________________________________________
      call timend(cputim(20),vtot,V2,waltim(20),wtot,W2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'read in data',cputim(1),waltim(1),
     2         'write out data',cputim(2),waltim(2),
     3         'temporal fft',cputim(3),waltim(3),
     4         'calculate spatial f mx.',cputim(4),waltim(4),
     4         'spatial ft (projection)',cputim(5),waltim(5),
     5         'spatial ft (least squares)',cputim(6),waltim(6),
     5         'map u to amp/phase',cputim(7),waltim(7),
     6         'total',cputim(20),waltim(20)
c_____________________________________________________________
c     close data files
c___________________________________________________________
      call lbclos(luin)
      call lbclos(luout)
c
      write(lerr,*) 'normal completion of routine fk'
      write(LER ,*) 'normal completion of routine fk'
      close(lerr)
      call exit(0)
      end

c------------------------------
c  online help section
c------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for fk:  2-d Fourier '
     1                   //' transform'
        write(LER,*)' '
        write(LER,*)'-Delimeter[argument]........................(def)' 
        write(LER,*)' '
        write(LER,*)' '
        write(LER,*)'-N[file_in] -- input space/time (x,t) data set'
        write(LER,*)'-O[file_out] -- output amplitude/phase (omega,kx)'
     1                         //' data set'
        write(ler,*)
        write(ler,*)' additional command line arguments:'           
        write(ler,*)
        write(LER,*)'-s[ist]    -- start time (ms)         (first samp)'
        write(LER,*)'-e[iend]   -- end time (ms)            (last samp)'
        write(LER,*)'-spread[]  -- spread length (m,ft)    (no default)'
        write(LER,*)'-dxmin[]   -- minimum group spacing   (average dx)'
        write(ler,*)'              (used in defining kmax)'
        write(LER,*)'-R         -- inverse transform flag     (.false.)'
        write(ler,*)'-S         -- smooth early mutes on inverse '
     1                           //'(.false.)'
        write(LER,*)'-I         -- interpolate dead traces '
     1                     //'on inverse (.false.)'
        write(ler,*)'-nomute    -- dont reapply early mutes (apply)'
        write(ler,*)'-CL        -- be a Cost Leader and perform a '
     1                    //' projection vs least squares transform'
        write(LER,*)'-V         -- verbose output'
        write(LER,*)'Usage:'
        write(LER,*)'        fk -N[] -O[] -spread[] -dxmin[]'
        write(ler,*)'           -s[] -e[] -[R,S,I,CL,nomute,V]  '
        write(LER,*)' '

      return
      end
