C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getftf(ftf,ft,live,nkx,ntr,white)         
c_______________________________________________________________________
C     accumulate normal equations in Toeplitz matrix form.
c
c              T 
c     [FTF]=[F] [F]
c_______________________________________________________________________
c     fourier transform operator matrix.                         
c_______________________________________________________________________
      complex  ft(nkx,ntr)         
      complex  ftf(nkx)
      complex  f
c
      logical  live(ntr)
c_______________________________________________________________________
c     initialize
c_______________________________________________________________________
      do 10000 jkx=1,nkx
       ftf(jkx)=(0.,0.)
10000 continue
      ftf(1)=(1.,0.)
c_______________________________________________________________________
c     divide out the f(ifl) component of the ftf transform.
c     recall Fourier transform is Hermetian - hence diagonal is real!
c_______________________________________________________________________
      do 40000 jtr=1,ntr
       if(live(jtr)) then
          f=conjg(ft(1,jtr))
          do 20000 jkx=1,nkx                 
           ftf(jkx)=ftf(jkx)+f*ft(jkx,jtr)                  
20000     continue
       endif
40000 continue
c
      return
      end
