C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine xt2ap(utx,uout,ufx,udft,
     1                 hbegin,jtrWRD,lenwin,ntfft,
     2                 ntr,nkx,ist,iend,maxt,
     3                 ufk,ft,delf,live,
     4                 kmin,kmax,xwgt,dk,dist,jrec,
     5		       s,v,r,e,ec,
     6                 temp,rc,ftf,cost_leader,
     7                 white,cputim,waltim,verbose)
      integer hbegin
c
      real       utx(hbegin:maxt,ntr)       
      real       uout(hbegin:ntfft,kmin:kmax)               
c
      complex    ufx(ntfft/2,ntr)         
      complex    ufk(ntfft/2,kmin:kmax)
      complex    udft(ntfft/2,kmin:kmax)
      complex    ft(kmin:kmax,ntr)
      complex    ftf(kmin:kmax)
      complex    delf(ntr)
      real       dist(ntr)
      real       xwgt(ntr)
      logical    live(ntr)
      logical    verbose
      logical    cost_leader
c_______________________________________________________________
c     work arrays for weiner levinson recursion formula.
c_______________________________________________________________
      complex    s(ntfft/2,kmin:kmax)
      complex    v(ntfft),r(ntfft)
      complex    e(ntfft),ec(ntfft)
      complex    temp(ntfft),rc(ntfft)
c__________________________________________________________________
c     timing arrays.
c__________________________________________________________________
      real       cputim(*),waltim(*)
c__________________________________________________________________
c     copy trace headers from input data to output data.
c     copy last trace header into padded zone.
c__________________________________________________________________
      call timstr(v1,w1)
      k=kmin-1
      do 5000 jtr=1,ntr                     
       k=k+1
       call vmov(utx(hbegin,jtr),1,uout(hbegin,k),1,jtrWRD)
5000  continue
c___________________________________________________________________
c     move data up and zero out end of array.                       
c___________________________________________________________________
      do 10000 jtr=1,ntr    
       call vmov(utx(ist,jtr),1,utx(1,jtr),1,lenwin)
       call vclr(utx(lenwin+1,jtr),1,ntfft-lenwin)
10000 continue
c___________________________________________________________________
c     transform from t --> omega (out of place)       
c___________________________________________________________________
      do 20000 jtr=1,ntr    
       call rfftb(utx(1,jtr),ufx(1,jtr),ntfft,+1)
       call rfftsc(ufx(1,jtr),ntfft,2,1)
20000 continue
      call timend(cputim(3),v1,v2,waltim(3),w1,w2)
c___________________________________________________________________
c     calculate x-k transform Fourier coefficient matrix.
c___________________________________________________________________
      call timstr(v1,w1)
      call getf(ft,delf,live,kmin,kmax,xwgt,dk,dist,ntr,+1)
      call timend(cputim(4),v1,v2,waltim(4),w1,w2)
c___________________________________________________________________
c     transform from x --> k.                         
c___________________________________________________________________
      call timstr(v1,w1)
      call vclr(ufk,1,(kmax-kmin+1)*ntfft)
      do 50000 jtr=1,ntr
       do 45000 k=kmin,kmax
        do 43000 jf=1,ntfft/2
        ufk(jf,k)=ufk(jf,k)+ft(k,jtr)*ufx(jf,jtr)
43000   continue
45000  continue
50000 continue
      call timend(cputim(5),v1,v2,waltim(5),w1,w2)
      if(cost_leader) then
c___________________________________________________________________
c        assume that the slow Fourier transform is orthogonal.
c        pack the results into amplitude and phase vectors.
c___________________________________________________________________
         call timstr(v1,w1)
         write(87,*) 'cost leader'
         write(87,'(2a10,a14)') 'jf','jk','ufk'
          write(87,'(2i10,2e14.5)')((jf,jk,ufk(jf,jk),
     1                             jk=kmin,kmax,20),jf=100,600,100)
         call pack(ufk,uout,kmax-kmin+1,ntfft,hbegin)
         call timend(cputim(7),v1,v2,waltim(7),w1,w2)
      else  
c___________________________________________________________________
c        perform the least squares Discrete Fourier Transform 
c 
c                   T
c        1. form [F] [F]
c
c                    T    -1   T
c        2. form ([F] [F])  [F]
c
c        3. pack the results into amplitude and phase vectors.
c___________________________________________________________________
         call timstr(v1,w1)
         call getftf(ftf,ft,live,kmax-kmin+1,ntr,white)
         if(verbose) then
            ftfmax=0.
            do 60000 jkx=kmin+1,kmax
             ftfmax=max(ftfmax,abs(ftf(jkx)))
60000       continue
            ratio=ftfmax/abs(ftf(kxmin))
            write(lerr,*) 'record = ',jrec,' ftf ratio = ',ratio
         endif
         ifl=1
         ifh=ntfft/2
         write(88,'(2a10,a14)') 'jf','jk','ufk'
          fact=abs(ufk(100,kmin))
          write(88,'(2i10,2e14.5)')((jf,jk,ufk(jf,jk)/fact,
     1                           jf=1,ntfft/2,100),jk=kmin,kmax,10)
         call toeplitz(kmax-kmin+1,ftf,ufk,udft,s,ifl,ifh,
     1                 v,r,e,ec,temp,rc)
         write(89,'(2a10,a14)') 'jf','jk','udft'
          write(89,'(2i10,2e14.5)') ((jf,jk,udft(jf,jk),
     1                           jf=1,ntfft/2,100),jk=kmin,kmax,10)

         call timend(cputim(6),v1,v2,waltim(6),w1,w2)
         call timstr(v1,w1)
         call pack(udft,uout,kmax-kmin+1,ntfft,hbegin)
         call timend(cputim(7),v1,v2,waltim(7),w1,w2)
      endif
c
      return
      end
