C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Normalize( ntrco, RadialLiveSamples, RadialSum )

c normalize radial power spectra based on number of live samples 
c contributing to each bin and the circumference of each bin.  This
c will normalize taking area of bin into account.

c declare variables passed from calling routine

      integer ntrco

      real RadialLiveSamples(ntrco), RadialSum(ntrco) 

c declare local variables

      real Pi, MaxAmp, MinAmp, LogMaxAmp

c initialize variables 

      Pi = 4. * atan(1.0)
      MaxAmp = 0.
      MinAmp = 1.e30
      LogMaxAmp = -10000.0

c normalize on circumference and maximum amplitude and number of live samples

      do i = 1, ntrco

c watch out for unpopulated bins

         if ( RadialLiveSamples(i) .gt. 1.e-32 ) then
            RadialSum(i) = RadialSum(i) / 
     :           ( 2. * Pi * float(i) * RadialLiveSamples(i) )
         else
            RadialSum(i) = 0.0
         endif

c go for power spectral estimate so don't forget to square the amplitude 

         RadialSum(i) = RadialSum(i) ** 2

c find max and min

         if ( RadialSum(i) .gt. MaxAmp ) MaxAmp = RadialSum(i)
         if ( RadialSum(i) .lt. MinAmp .and.
     :        RadialLiveSamples(i) .gt. 1.e-32 ) MinAmp = RadialSum(i)
      enddo

      do i = 1, ntrco

c make sure no values < 1.0 so that no negative log values result

         if ( MinAmp .gt. 1.e-32 ) 
     :        RadialSum(i) =  RadialSum(i) / MinAmp

         if ( RadialSum(i) .le. 1.e-32 ) then
            RadialSum(i) = 0.0
         else
            RadialSum(i) = alog( RadialSum(i) )
         endif

c determine maximum amplitude 

         if ( RadialSum(i) .gt. LogMaxAmp .and. 
     :        RadialSum(i) .gt. 1.e-32) LogMaxAmp = RadialSum(i)
      enddo

c normalize on max amplitude

      do i = 1, ntrco
         if ( abs(LogMaxAmp) .gt. 1.e-32 )
     :        RadialSum(i) = RadialSum(i) / LogMaxAmp
      enddo 

      return
      end
      
