C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ScanParameters ( NyquistX, NyquistY, ntrc, nsampAmp, 
     :     nbins, dKX, dKY, dKR, RadialNyquist, ntrco, nsampo )

c this routine determines the number of output traces and samples to 
c be used in the spectral display.  It also determines the X and Y 
c wavenumber sampling intervals to use in radial amplitude summation.
c
c here increasing x is in the direction of increasing trace.  Increasing
c y is in the direction of increasing sample.

      integer ntrc, nsampAmp, nbins, ntrco, nsampo

      real NyquistX, NyquistY, RadialNyquist, dKX, dKY, dKR

c declare local variables

      integer  Xcenter, Ycenter

c determine number of output traces and sample as a function of the number
c used on input [accounting for mixed radix transform used in fftxy].  Xcenter
c and Ycenter are the number of samples from the origin out to Nyquist in both
c the x [trace] and y [sample] directions.  The dKX and dKY calculated are for
c the INPUT dataset NOT the output spectra.  The delta_radial frequency is a function
c of the maximum radial frequency sqrt[NyquistX**2 + NyquistY**2] divided by
c the number of output traces.  This is the default bin size.  Once I get this
c running I might put in an option to allow the user to specify a bin size on the
c command line.

      if ( mod(ntrc,2) .eq. 0 ) then
         Xcenter  = ( ntrc / 2 ) + 1
      else
         Xcenter = ( ntrc / 2 )
      endif

      if ( mod(nsampAmp,2) .gt. 0 ) then
         Ycenter = nsampAmp / 2 + 1
      else
         Ycenter = nsampAmp / 2 
      endif

c determine wavenumber sample interval along both the KX and KY axes.      

      dKX = NyquistX / float(Xcenter)
      dKY = NyquistY / float(Ycenter)

c determine number of output traces and samples to use to keep a 
c relatively square looking radial power spectra plot

      if ( nbins .gt. 0 ) then
         ntrco = nbins
         nsampo = nbins
      else
         if ( Xcenter .ge. Ycenter ) then
            ntrco = Xcenter
            nsampo = Xcenter
         else
            ntrco = Ycenter
            nsampo = Ycenter
         endif
      endif

c Since we want to sum ALL the input space, which is not radial by design,
c i.e. has corner spaces, then we must calculate the radial nyquist out past
c both KX and KY maxima and allow summation into the corners of the spectra.
c The output radial spacial interval will then be a function of the radial
c Nyquist and the number of output traces.


      RadialNyquist = sqrt( NyquistX**2 + NyquistY**2 )
      dKR = RadialNyquist / float(ntrco)

      return
      end
