C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ---
c  Program FKRAD : [Kx,Ky] radial frequency display
c  Author: Paul G. A. Garossino [Dec:1993]
c ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ---

c Program Changes :

c August 95: major rewrite to allow for mixed radix transform in fftxy
c            Garossino.  Reordered loops for much faster execution.  Have
c            picked up an ieee inexact exception on some choices of ntrc.
c            Can't for the life of me see what has caused this.  It doesn't
c            seem to affect the output but does put up the annoying ieee error.
c            For instance an input spectra with nsamp=900 and ntrc=160 
c            causes an ieee inexact.  If I keep nsamp=900 and change the 
c            input ntrc=215 things are fine.  This is just a single example
c            I'm sure there are lots more.

    
c
c usp system variables
c

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c basic USP variables

      integer     lhed( SZLNHD )
      integer     nsamp, nsampo, nsi, ntrc, ntrco, nrec, nreco, irs, ire
      integer     iform, luin, lbytes, nbytes, luout, obytes
      integer     KK, JJ, argis

      character   name*5, ntap*255, otap*255

      logical     verbos

c program variables defined with dynamic memory allocation

      integer     Headers, IndexHeader, IndexTrace
      integer     errcd1, errcd2, errcd3, errcd4, errcd5, abort
      integer     HeaderSize, RecordSize, ntrc_mem, nsamp_mem

      real        InputFftxy, RadialSum, RadialLiveSamples, Frequencies

      pointer     (memadr_Headers, Headers(200000))
      pointer     (memadr_InputFftxy, InputFftxy(200000))
      pointer     (memadr_RadialSum, RadialSum(200000))
      pointer     (memadr_RadialLiveSamples, RadialLiveSamples(200000))
      pointer     (memadr_Frequencies, Frequencies(200000))

c program variables defined with static memory allocation

      integer     nsampAmp, nbins
      integer     ifmt_ILClIn, l_ILClIn, ln_ILClIn
      integer     ifmt_CLClIn, l_CLClIn, ln_CLClIn
      integer     TrcNum, ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer     DpPtLt, ifmt_DpPtLt, l_DpPtLt, ln_DpPtLt

      real        NyquistX, NyquistY, dX, dY
      real        Fscalar, dKX, dKY, dKR, RadialNyquist

c Initialize Required Variables

      data name/'FKRAD'/
      data abort/1/
      data lbytes/0/
      data nbytes/0/
      data dX/0./
      data dY/0./
      data dKX/0./
      data dKY/0./
      verbos = .false.

c get online help if requested

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 )then
         call help()
         stop
      endif

c open printout

#include <f77/open.h>

c read program parameters from command line argument string

      call cmdln ( ntap, otap, irs, ire, dX, dY, nbins, verbos ) 
  
c open input/output datasets

      call getln ( luin, ntap, 'r', 0)
      call getln ( luout, otap, 'w', 1)

c read and update line header, write line header, save key parameters.

      lbytes=0

      call rtape  ( luin, lhed, lbytes )

      if(lbytes .eq. 0) then
         write(LERR,*)'FKRAD: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

      call saver(lhed, 'NumSmp', nsamp, LINHED)
      call saver(lhed, 'SmpInt', nsi  , LINHED)
      call saver(lhed, 'Format', iform, LINHED)
      call saver(lhed, 'NumTrc', ntrc , LINHED)
      call saver(lhed, 'NumRec', nrec , LINHED)
      call saver(lhed, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(lhed, 'UnitSc', unitsc, LINHED)
      endif

c pick up sample interval from line header if not already defined on 
c command line.  These values may have been set by xyz2sis.

      if ( abs(dX) .lt. 1.e-30 ) then
         call savelu ( 'ILClIn', ifmt_ILClIn, l_ILClIn, ln_ILClIn, 
     :        LINEHEADER )
         call saver2 ( lhed, ifmt_ILClIn, l_ILClIn, ln_ILClIn, dX, 
     :        LINEHEADER )
      endif 

      if ( abs(dY) .lt. 1.e-30 ) then
         call savelu( 'CLClIn', ifmt_CLClIn, l_CLClIn, ln_CLClIn, 
     :        LINEHEADER )
         call saver2( lhed, ifmt_CLClIn, l_CLClIn, ln_CLClIn, dY, 
     :        LINEHEADER )
      endif

c use unity as a default if all else fails.  Although this would be bad
c if the program parameters where set in terms of absolute wavenumber
c here we work in a relative sense anyway so at least some kind of processing
c may be done.

      if ( abs(dX) .lt. 1.e-30 ) dX = 1.0
      if ( abs(dY) .lt. 1.e-30 ) dY = 1.0

c watch out for negative sample intervals that may arise due to decrementing
c grids brought in through xyz2sis and propagated through fftxy.  This has
c occured with a couple of Potential Fields datasets from the UK.

      dX = abs(dX)
      dY = abs(dY)

c initialize pointer to trace header variable to hold upper bin frequency

      call savelu ( 'TrcNum', ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :     TRACEHEADER)
      call savelu ( 'DpPtLt', ifmt_DpPtLt, l_DpPtLt, ln_DpPtLt, 
     :     TRACEHEADER)

c print Historical Line header to printfile and update to line header

      call hlhprt ( lhed , lbytes, name, 5, LERR )

c Check Defaults and validity of command line entries

      call cmdchk ( ns, ne, irs, ire, ntrc, nrec )
      
      if ( ire .eq. 0 ) ire = nrec
      nreco = ire - irs + 1

c since radial frequencies are samples through all quadrants only one
c output trace per frequency is required.  The frequency axis will be 
c either half the number of input traces or half the number of input 
c samples whichever is larger unless the number of bins is specified
c on the command line.

c adjust nsamp to skip reading phase information from input file

      nsampAmp = nsamp / 2 

c calculate spatial Nyquist frequency in both X and Y directions

      NyquistX = 1. / ( 2. * dX )
      NyquistY = 1. / ( 2. * dY )

c determine dKX and dKY for the input dataset.  Also determine the
c output samples per trace [nsampo] and traces per record [ntrco] 
c for the radial power spectra display.

      call ScanParameters ( NyquistX, NyquistY, ntrc, nsampAmp, nbins, 
     :     dKX, dKY, dKR, RadialNyquist, ntrco, nsampo )

c update historical line header & output header

      obytes = SZTRHD + SZSMPD * nsampo

      call savew (lhed, 'NumRec' , nreco, LINHED)
      call savew (lhed, 'NumTrc' , ntrco, LINHED)
      call savew (lhed, 'NumSmp' , nsampo, LINHED)

      call savhlh ( lhed, lbytes, lbyout )
      call wrtape ( luout, lhed, lbyout )

c echo input parameters to printout

      call verbal ( ntap, otap, nrec, ntrc, nsamp, nsi, iform, irs, ire, 
     :     nreco, ntrco, nsampo, nsampAmp, dX, dY, dKX, dKY, dKR, 
     :     NyquistX, NyquistY, RadialNyquist, verbos )

c  Dynamic Memory Allocation

      if ( ntrco .gt. ntrc ) then
         ntrc_mem = ntrco
      else
         ntrc_mem = ntrc
      endif

      if ( nsampo .gt. nsampAmp ) then
         nsamp_mem = nsampo
      else
         nsamp_mem = nsampAmp
      endif

      HeaderSize = ntrc_mem * ITRWRD 
      RecordSize= ntrc_mem * nsamp_mem

      call galloc (memadr_Headers, HeaderSize * SZSMPD, errcd1, 
     :     abort)
      call galloc (memadr_InputFftxy, RecordSize * SZSMPD, errcd2, 
     :     abort)
      call galloc (memadr_RadialSum, RecordSize * SZSMPD, errcd3, 
     :     abort)
      call galloc (memadr_RadialLiveSamples, RecordSize * SZSMPD, 
     :     errcd4, abort)
      call galloc (memadr_Frequencies, HeaderSize * SZSMPD, errcd5, 
     :     abort)
 
      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or. 
     :     errcd3 .ne. 0 .or. 
     :     errcd4 .ne. 0 .or. 
     :     errcd5 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2*HeaderSize* SZSMPD,' bytes'
         write(LERR,*) 3*RecordSize* SZSMPD,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2*HeaderSize* SZSMPD,' bytes'
         write(LER,*) 3*RecordSize* SZSMPD,'  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2*HeaderSize* SZSMPD,' bytes'
         write(LERR,*) 3*RecordSize* SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

c Skip Down to User Defined Start Time Slice

      call recskp(1,irs-1,luin,ntrc,lhed)

c PROCESS RECORDS

      DO JJ = irs,ire

c initialize  arrays

         call vclr ( InputFftxy, 1, RecordSize )
         call vclr ( RadialSum, 1, RecordSize )
         call vclr ( RadialLiveSamples, 1, RecordSize )

c Load Record

         IndexHeader = 1 - ITRWRD
         IndexTrace = 1 - nsampAmp

c PROCESS TRACES

         DO KK = 1 , ntrc

            nbytes = 0
            call rtape( luin, lhed, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Unexpected End Of File on input:'
               write(LERR,*)'at rec= ',jj,'  trace= ',kk
               go to 999
            endif

c     advance array indices for this trace

            IndexHeader = IndexHeader + ITRWRD
            IndexTrace = IndexTrace + nsampAmp

c load headers 

            call vmov (lhed,1,Headers(IndexHeader),1,ITRWRD)

c load time series 

            call vmov(lhed(ITHWP1),1,InputFftxy(IndexTrace),1,nsampAmp)

         ENDDO

c form  display 

         call SumRadialFreq ( InputFftxy, ntrc, nsampAmp, RadialSum, 
     :        RadialLiveSamples, ntrco ,dKX, dKY, dKR )
  
c normalize on maximum cumulative amplitude if requested

         call Normalize ( ntrco, RadialLiveSamples, RadialSum )

c clear the input data for re-use

         call vclr ( InputFftxy, 1, RecordSize ) 

c build the output amplitude display

        call HistogramOut ( ntrco, nsampo, RadialSum, InputFftxy )

c calculate radial wavenumber of each output trace

         call HeaderOut ( ntrco, dKR, Frequencies )

c Output data

         IndexHeader = 1 - ITRWRD
         IndexTrace = 1 - nsampo

         Fscalar = 1000.0 / Frequencies(ntrco)

         DO  KK = 1, ntrco

            IndexHeader = IndexHeader + ITRWRD
            IndexTrace = IndexTrace + nsampo

c restore header [watch out for ntrco > ntrc]

            if ( KK .le. ntrc ) then
               call vmov ( Headers(IndexHeader), 1, lhed(1), 1, ITRWRD )
            else
               IndexHeader = (ntrc - 1) * ITRWRD + 1
               call vmov ( Headers(IndexHeader), 1, lhed(1), 1, ITRWRD )
            endif

c load bin top frequency to trace header entry TrcNum
c load frequency scalar to DpPtLt

            TrcNum = nint ( Frequencies(kk) * Fscalar )
            DpPtLt = nint ( Fscalar )
            call savew2 ( lhed, ifmt_TrcNum, l_TrcNum, ln_TrcNum, TrcNum
     :           , TRACEHEADER)
            call savew2 ( lhed, ifmt_DpPtLt, l_DpPtLt, ln_DpPtLt, DpPtLt
     :           , TRACEHEADER)

c move  radial frequency trace to output array

            call vmov(InputFftxy(IndexTrace), 1, lhed(ITHWP1), 1, 
     :           nsampo )

c output radial frequency trace

            call wrtape ( luout, lhed, obytes )
         ENDDO
      ENDDO

 999  continue

c clean up
      
      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)'Normal Termination, processed ',nreco,' record(s) wi
     :th ',ntrc,' traces'
      write(LER,*)'FKRAD: Normal Termination'

      stop
      end
