C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ---
c  Program FKSHAPE : [Kx,Ky] radial frequency shaping from pickfile control
c  Author: Paul G. A. Garossino [Jan:1993]
c ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ---

c program changes

c     August 95: updated to handle mixed radix fft output from fftxy
c     Garossino
c
c usp system variables
c

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c basic USP variables

      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, nreco, irs, ire, iform
      integer     luin , lbytes, nbytes, luout, obytes
      integer     KK, JJ, argis, start, end

      character   name*7, ntap*255, otap*255

      logical     verbos

c program variables defined with dynamic memory allocation

      integer     Headers
      integer     errcd1, errcd2, errcd3, errcd4, errcd5, errcd6, abort
      integer     itemHeader, itemRecord, itemMask
      integer     IndexHeader, IndexTrace, indexMask

      real        InputFftxy, OutputFftxy, Trace, Sample, AmpMask

      pointer     (memadr_Headers, Headers(200000))
      pointer     (memadr_InputFftxy, InputFftxy(200000))
      pointer     (memadr_OutputFftxy, OutputFftxy(200000))
      pointer     (memadr_Trace, Trace(200000))
      pointer     (memadr_Sample, Sample(200000))
      pointer     (memadr_AmpMask, AmpMask(200000))

c program variables defined with static memory allocation

      integer     nbins, Index(2*SZSMPM,2), lupick, leptap
      integer     NumPicks, NumSegs, FF, nrecofilt
      integer     ifmt_ILClIn, l_ILClIn, ln_ILClIn
      integer     ifmt_CLClIn, l_CLClIn, ln_CLClIn
      integer     nsampAmp, StartRec, EndRec, exp_ntrco
      integer     Bin1, Bin2, Bin3, Bin4

      real        NyquistX, NyquistY, dX, dY
      real        Exponent, dKX, dKY, dKR

      character   ptap*255, PickType*7

      logical     Difference

c Initialize Required Variables

      data name/'FKSHAPE'/
      data abort/0/
      data lbytes/0/
      data nbytes/0/
      data dX/0./
      data dY/0./
      data verbos/.false./
      data Difference/.false./

c following variable is here for forward compatibility with xsd header value
c at pick location input and the PickInit() subroutine

      data PickType/'pick'/

c get online help if requested

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
          call help()
          stop
      endif

c open printout

#include <f77/open.h>

c read program parameters from command line argument string

      call cmdln( ntap, otap, ptap, irs, ire, dX, dY, Difference, nbins, 
     :     StartRec, EndRec, Exponent, Bin1, Bin2, Bin3, Bin4, verbos )

c open pickfile and get memory allocation parameters only if in use

      if ( ptap .ne. ' ' ) then
         call alloclun(lupick)
         leptap = lenth(ptap)
	 if (leptap .eq. 0) go to 990
         open ( lupick, file=ptap(1:leptap), status='old', err=990)
         call PickInit ( lupick, NumPicks, NumSegs, nbins, PickType )
      endif

c open input/output datasets

      call getln ( luin, ntap, 'r', 0)
      call getln ( luout, otap, 'w', 1)

c read and update line header, write line header, save key parameters.

      lbytes=0

      call rtape  ( luin, lhed, lbytes )

      if(lbytes .eq. 0) then
         write(LERR,*)'FKSHAPE: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

      call saver(lhed, 'NumSmp', nsamp, LINHED)
      call saver(lhed, 'SmpInt', nsi  , LINHED)
      call saver(lhed, 'Format', iform, LINHED)
      call saver(lhed, 'NumTrc', ntrc , LINHED)
      call saver(lhed, 'NumRec', nrec , LINHED)
      call saver(lhed, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(lhed, 'UnitSc', unitsc, LINHED)
      endif

c pick up sample interval from line header if not already defined on 
c command line

      if ( abs(dX) .lt. 1.e-30 ) then
         call savelu ( 'ILClIn', ifmt_ILClIn, l_ILClIn, ln_ILClIn, 
     :        LINEHEADER )
         call saver2 ( lhed, ifmt_ILClIn, l_ILClIn, ln_ILClIn, dX, 
     :        LINEHEADER )
      endif 

      if ( abs(dX) .lt. 1.e-30 ) dX = 1.0

      if ( abs(dY) .lt. 1.e-30 ) then
         call savelu( 'CLClIn', ifmt_CLClIn, l_CLClIn, ln_CLClIn, 
     :        LINEHEADER )
         call saver2( lhed, ifmt_CLClIn, l_CLClIn, ln_CLClIn, dY, 
     :        LINEHEADER )
      endif

      if ( abs(dY) .lt. 1.e-30 ) dY = 1.0

      dX = abs(dX)
      dY = abs(dY)

c print Historical Line header to printfile and update to line header

      call hlhprt ( lhed , lbytes, name, 7, LERR )

c Check Defaults and validity of command line entries
      
      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 ) ire = nrec
      nreco = ire - irs + 1

      if(StartRec .eq. 0)then
         start = irs
      else
         start = StartRec
      endif

       if(EndRec .eq. 0)then
         end = ire
      else
         end = EndRec 
      endif

c set numsegs if pickfile not being used

      if ( ptap .eq. ' ' ) numsegs = 1
      
c calculate spatial Nyquist frequency in both X and Y directions

      NyquistX = 1. / ( 2. * dX )
      NyquistY = 1. / ( 2. * dY )

c determine X and Y wavenumber scan scalars and the number of 
c output samples per trace and traces per record

      nsampAmp = nsamp / 2

      call ScanParameters ( NyquistX, NyquistY, ntrc, nsampAmp, dKX, 
     :     dKY, dKR, nbins, exp_ntrco)

      if ( ptap .eq. ' ' .and. nbins .eq. 0 ) nbins = exp_ntrco

c update historical line header & output header

      obytes = SZTRHD + SZSMPD * nsamp

      if ( NumSegs .gt. 1 .and.  ptap .ne. ' ' ) then
         nrecofilt = ( end - start + 1 ) * NumSegs
         call savew(lhed, 'NumRec', nrecofilt, LINHED)
      else
         call savew(lhed, 'NumRec', nreco, LINHED)
      endif

      call savew (lhed, 'NumTrc' , ntrc, LINHED)
      call savew (lhed, 'NumSmp' , nsamp, LINHED)

      call savhlh ( lhed, lbytes, lbyout )
      call wrtape(luout,lhed,lbyout)

c echo input parameters to printout

      call verbal ( irs, ire, nsamp, ntrc, nsi, nrec, ntap, otap, ptap,  
     :     iform, dX, dY, NumSegs, nbins, start, end, Exponent, Bin1, 
     :     Bin2, Bin3, Bin4, verbos)

c  Dynamic Memory Allocation
c  note : SZSMPD is the native
c  size of a float or int in bytes

      itemHeader = ntrc * ITRWRD 
      itemRecord = ntrc * nsamp
      itemMask = NumSegs * ntrc * nsampAmp

      call galloc (memadr_Headers, itemHeader * SZSMPD, errcd1, abort)
      call galloc (memadr_InputFftxy, itemRecord * SZSMPD, errcd2, 
     :     abort)
      call galloc (memadr_OutputFftxy, itemRecord * SZSMPD, errcd3, 
     :     abort)
      call galloc (memadr_AmpMask, itemMask * SZSMPD, errcd6, abort)
 
      if ( errcd1 .ne. 0 
     :     .or. errcd2 .ne. 0 
     :     .or. errcd3 .ne. 0
     :     .or. errcd6 .ne. 0
     :     ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 1*itemHeader * SZSMPD,' bytes'
         write(LERR,*) 2*itemRecord  * SZSMPD,'  bytes'
         write(LERR,*) 1*itemMask  * SZSMPD,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 1*itemHeader * SZSMPD,' bytes'
         write(LER,*) 2*itemRecord  * SZSMPD,'  bytes'
         write(LER,*) 1*itemMask  * SZSMPD,'  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 1*itemHeader * SZSMPD,' bytes'
         write(LERR,*) 2*itemRecord * SZSMPD,'  bytes'
         write(LERR,*) 1*itemMask  * SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

c initialize pick file memory if required

      if ( ptap .ne. ' ' ) then
         ItemPick = NumSegs * NumPicks
         call galloc (memadr_Trace, itemPick * SZSMPD, errcd4, abort)
         call galloc (memadr_Sample, itemPick * SZSMPD, errcd5, abort)

         if ( errcd4 .ne. 0 
     :        .or. errcd5 .ne. 0
     :        ) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) 2*itemPick * SZSMPD,'  bytes'
            write(LERR,*)' '
            go to 999
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) 2*itemPick * SZSMPD,'  bytes'
            write(LERR,*)' '
         endif

         call vclr(Trace,1,NumSegs*NumPicks)
         call vclr(Sample,1,NumSegs*NumPicks)

c before reading data go ahead and read pickfile data if required

         call ReadPick ( lupick, Index, Trace, Sample, NumSegs,  
     :        PickType, ntrc, verbos)

      endif

c initialize arrays

      call vclr( AmpMask, 1, itemMask )
      call vclr( InputFftxy, 1, itemRecord )
      call vclr( OutputFftxy, 1, itemRecord )

c build filter masks for all input segments

      if ( ptap .ne. ' ' ) then

         indexMask = 1 - ( nsampAmp * ntrc )
         do i = 1, NumSegs

            indexMask = indexMask + ( nsampAmp * ntrc )

            call BuildAmpMask ( i, Index, Trace, Sample, 
     :           itemPick, NumSegs, AmpMask(indexMask), nsamp, ntrc, 
     :           nbins, nsampAmp, dKX, dKY, dKR )
        
         enddo

      else
      
         call BuildExpMask (AmpMask, ntrc, nsampAmp, dKX, dKY, 
     :        dKR, Exponent, Bin1, Bin2, Bin3, Bin4, nbins )

      endif
         
c skip to first record to process

      call recskp ( 1, irs-1, luin, ntrc, lhed )

      DO JJ = irs,ire

c initialize input memory

         call vclr ( InputFftxy, 1, itemRecord )

c LOAD RECORD

         IndexHeader = 1 - ITRWRD
         IndexTrace = 1 - nsamp

c process traces

         DO KK = 1 , ntrc
            nbytes = 0
            call rtape( luin, lhed, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Unexpected End Of File on input:'
               write(LERR,*)'at rec= ',jj,'  trace= ',kk
               go to 999
            endif

c     advance array indices for this trace

            IndexHeader = IndexHeader + ITRWRD
            IndexTrace = IndexTrace + nsamp

c load headers 

            call vmov (lhed, 1, Headers(IndexHeader), 1, ITRWRD )

c load time series 

            call vmov ( lhed(ITHWP1), 1, InputFftxy(IndexTrace), 1, 
     :           nsamp )

         ENDDO

c if this record falls within the records to process then process 
c otherwise pass untouched.

         IF ( JJ .ge. start .and. JJ .le. end ) then

c build and apply shaping filters as required
 
            indexMask = 1 - (nsampAmp * ntrc)

            DO FF = 1, NumSegs

               indexMask = indexMask + (nsampAmp * ntrc)

c apply mask to log10 of input data then return inverse log

               call vclr ( OutputFftxy, 1, itemRecord )
               call ShapeSpectrum ( ntrc, nsamp, InputFftxy, OutputFftxy 
     :              ,nsampAmp, AmpMask(indexMask), Difference )

c Output resulting record

               IndexHeader = 1 - ITRWRD
               IndexTrace = 1 - nsamp

               do  KK = 1,ntrc

                  IndexHeader = IndexHeader + ITRWRD
                  IndexTrace = IndexTrace + nsamp

                  if ( KK .le. ntrc ) then
                     call vmov ( Headers(IndexHeader), 1, lhed(1), 1, 
     :                    ITRWRD )
                  else
                     IndexHeader = (ntrc - 1) * ITRWRD + 1
                     call vmov ( Headers(IndexHeader), 1, lhed(1), 1, 
     :                    ITRWRD )
                  endif

                  call vmov(OutputFftxy(IndexTrace), 1, lhed(ITHWP1), 1, 
     :                 nsamp )

c output filtered data

                  call wrtape ( luout, lhed, obytes )
               enddo
            ENDDO

         ELSE

c Output passed record with no processing

            IndexHeader = 1 - ITRWRD
            IndexTrace = 1 - nsamp

            do  KK = 1,ntrc

               IndexHeader = IndexHeader + ITRWRD
               IndexTrace = IndexTrace + nsamp
               
               if ( KK .le. ntrc ) then
                  call vmov ( Headers(IndexHeader), 1, lhed(1), 1, 
     :                 ITRWRD )
               else
                  IndexHeader = (ntrc - 1) * ITRWRD + 1
                  call vmov ( Headers(IndexHeader), 1, lhed(1), 1, 
     :                 ITRWRD )
               endif
               
               call vmov(InputFftxy(IndexTrace), 1, lhed(ITHWP1), 1, 
     :              nsamp )

               call wrtape ( luout, lhed, obytes )
            enddo

         ENDIF

      ENDDO

c clean up
      
      call lbclos ( luin )
      call lbclos ( luout )
      if(ptap .ne. ' ') close ( lupick )

      write(LERR,*)'Normal Termination, processed ',nreco,' record(s) wi
     :th ',ntrc,' traces'
      write(LER,*)'FKSHAPE: Normal Termination'

      stop

 999  continue

c clean up
      
      call lbclos ( luin )
      call lbclos ( luout )
      if(ptap .ne. ' ') close ( lupick )

      write(LERR,*)'Abnormal Termination, processed ',nreco,' record(s) 
     :with ',ntrc,' traces'
      write(LER,*)'FKSHAPE: Abnormal Termination'

      stop
 990  continue
      write(LERR,*)'FKSHAPE: Error opening pick file ', ptap(1:leptap)     
      write(LERR,*)'          Check existance/permissions and try again'
      write(LERR,*)'FATAL'        
      write(LER,*)'FKSHAPE: Error opening pick file ', ptap(1:leptap)     
      write(LER,*)'          Check existance/permissions and try again'
      write(LER,*)'FATAL' 
      stop
      end
      



 
