C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c
c Subroutine to extract a window from a gather
c It automatically knows how to handle off the end cases on both axes
c
c
c
        subroutine extractD(in,out,n1,n2,n1w,n2w,f1,f2)
c
        implicit none
c
        integer n1,n2
        integer n1w,n2w
        integer f1,f2
        integer ii1,ii2,i1,i2
c
        real       in(n1,n2)
        complex    out(n1w,n2w)
c
        do i2=1,n2w
c
           ii2=f2-1+i2
c
           if(ii2 .lt. 1 .or. ii2 .gt. n2)then
c
             do i1=1,n1w
                out(i1,i2)=cmplx(0.,0.)
             end do
c
           else
c
             do i1=1,n1w
                ii1=f1-1+i1
                if(ii1 .lt. 1 .or. ii1 .gt. n1)then
                   out(i1,i2)=cmplx(0.,0.)
                else
                   out(i1,i2)=cmplx(in(ii1,ii2),0.)
                end if
             end do
c
           end if
c
        end do
c
c all done
c
        return
        end
