C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c
c subroutine to interpolate frequencies and wavenumbers by a factor of
c 
c
	subroutine stretch(D,A,Atmp,n1,n2,two_n1,two_n2,
     1                     n1_tab, n2_tab, two_n1_tab, two_n2_tab)
c
	implicit none
c
	integer	n1,n2,two_n1,two_n2
	integer	i1,i2, ierr, isz, nmax, iabort, item
c
        real    n1_tab(*), n2_tab(*), two_n1_tab(*), two_n2_tab(*)

	complex tmp,tmp2
        pointer (wktmp , tmp (1))
        pointer (wktmp2, tmp2(1))
        
	complex	D(n1,n2)
	complex Atmp(n1,two_n2)
	complex A(two_n1,two_n2)

        ierr   = 0
        iabort = 0
        call sizefloat (isz)
        nmax = max(n1,n2,two_n1,two_n2)
        item = 2 * isz * nmax
        call galloc (wktmp , item, ierr, iabort)
        call galloc (wktmp2, item, ierr, iabort)
c
c
c first step, stretch the 2 axis
c
	do i1=1,n1
c
	   do i2=1,n2
		tmp(i2)=D(i1,i2)
	   end do
c
c	   call cefftp(tmp,n2,1)
           call cfftx (tmp, 2, n2, 1, 0, n2_tab, ierr)
c
	   do i2=1,n2
		tmp2(i2)=tmp(i2)
	   end do
c
	   do i2=n2+1,two_n2
		tmp2(i2)=cmplx(0.,0.)
	   end do
c
c	   call cefftp(tmp2,two_n2,-1)
           call cfftx (tmp2, 2, two_n2, 1, 0, two_n2_tab, ierr)
c
	   do i2=1,two_n2
		Atmp(i1,i2)=tmp2(i2)
	   end do
c
	end do
c
c Now stretch the 1 axis
c
	do i2=1,two_n2
c
	   do i1=1,n1
		tmp(i1)=Atmp(i1,i2)
	   end do
c
c	   call cefftp(tmp,n1,1)
           call cfftx (tmp, 2, n1, 1, 0, n1_tab, ierr)
c
	   do i1=1,n1
		tmp2(i1)=tmp(i1)
	   end do
c
	   do i1=n1+1,two_n1
		tmp2(i1)=cmplx(0.,0.)
	   end do
c
c	   call cefftp(tmp2,two_n1,-1)
           call cfftx (tmp2, 2, two_n1, 1, 0, two_n1_tab, ierr)
c
	   do i1=1,two_n1
		A(i1,i2)=tmp2(i1)
	   end do
c
	end do
c
c all done
c
        call gfree (wktmp)
        call gfree (wktmp2)

	return
	end
