C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Resample_Series(Space_Series, Time_Series, Ninput,
     :     Noutput,  Output_Space, Output_Series, N )
c
c========================================================================
c     Subroutine to resample a time series via a linear interpolation
c     
c     James M. Gridley
c     P. Gutowski
c     USP Team
c     May 1996
c     Amoco
c========================================================================
c      INPUT
c     _____________
c     Space_Series:    Spacial position of input Time Series 
c     Time_Series:     Input Time series to be resampled
c     Ninput:          Number of samples of input time series
c     Noutput:         Number of samples of output time series
c
c     OUTPUT
c     ------
c     Output_Space:    Spacial position of output Time Series
c     Output_Series:   Output Time series resampled to Noutput samples
c
c========================================================================
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine
      
      integer Ninput, Noutput, N
      
c     declare variables used in subroutine
      
      Real     Space_Series(N), Time_Series(N)
      Real     Output_Space(N), Output_Series(N)

      Real     slope, counter, dt
   
c========================================================================
c     calculate the new sample rate
      
      tmp = Space_Series(Ninput) - Space_Series(1)
      dt = tmp/ ((Noutput)-1)

c         dt = (((Space_Series(Ninput)-Space_Series(1))) /(Noutput-1))
         


c         write(6,*) 'Ninput = ',Ninput
c         write(6,*) 'Noutput = ',Noutput
c         write(6,*)Space_Series(Ninput),Space_Series(1)
c         write(6,*)'dt = ',dt,' output = ',Noutput
         
c         write(6,*)Space_Series(1),Noutput
c         do i = 1, Noutput+1
c            write(6,*)i,Space_Series(1)+(i-1)*dt
c         enddo
c========================================================================
c         counter = Space_Series(1) 
c========================================================================


         do 20 j = 1, Noutput

            counter = Space_Series(1)+(j-1)*dt
c            write(6,*)Noutput,j,counter

            
            do 10 i = 1, Ninput-1

               
               if (counter .ge. Space_Series(i) .and.
     :              counter .le. Space_Series(i+1) ) then
                  
cmam.......do not divide by zero
                  if ((Space_Series(i+1) - Space_Series(i)) .ne.
     :               0.0 ) then
                       slope = (Time_Series(i+1) - Time_Series(i))/
     :                 (Space_Series(i+1) - Space_Series(i))
                  
                       Output_Series(j) = slope * counter +
     :                 (Time_Series(i) - (slope*Space_Series(i)))
                  else
                       slope = 0.0
                       Output_Series(j) = 0.0
                  endif
                  
                  Output_Space(j) = counter

c                  write(6,*)Output_Space(j),Output_Series(j)

                  go to 20

               endif

 10         enddo

 20      enddo
c          Output_Space(Noutput) = Space_Series(Ninput)
c          Output_Series(Noutput) = Time_Series(Ninput)


c========================================================================        

      return
      end
