C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine balance(Dhold, winwork,sum, opratr,data,
     :iovlp,nsamp,nwin,jslide,ndo,iopt,scale,dead,ierr)
      real Dhold(*),winwork(*),sum(*),opratr(*),data(*)
      logical scale,dead(*)
      real weight(1)
      POINTER (pw,weight)
      integer iopt,nsamp,nwin,jslide

      call sizefloat(isz)
      call galloc(pw,ndo*isz,ierr,0)

      if(ierr.ne.0)return
      ndx=-nsamp
      do i=1,ndo
       ndx=ndx+nsamp
       do j=1,nsamp
        data(j+ndx)=0.
       end do
      end do
      ierr = 0
      imid=0
      iopt = 0
      do kk=1,nwin
       if(kk.eq.1)then
        nmove=jslide+iovlp
        ilast=jslide+iovlp
        ifirst = 1
        if(jslide.eq.nsamp)nmove=nsamp
        jmove=nmove
       else
        nmove=jslide+iovlp
        jmove=nmove
        ifirst=ifirst+iovlp
        imid=ifirst
        ilast=ifirst+nmove-1
        if(ilast.gt.nsamp)then
         jmove=nsamp-ifirst+1
        endif
       endif
       do mm=1,nmove
        winwork(mm)=0.
       end do
       lwind=nmove
       n2=64
       do while(n2.lt.lwind)
        n2=n2+n2
       end do
       do i=1,n2+2
        sum(i)=0.
       end do
c +===================================================+
c | Compute the running product of the data in window |
c +===================================================+
       xn = 0.
       ierr = 0
       jjj=0
       do kkk=1,ndo
        if(.not.dead(kkk))then
         ndx=(kkk-1)*nsamp
         jjj = jjj + 1
         xn = xn + 1.
         do i=jmove,lwind
          winwork(i)=0.
         end do
         call vmov(Dhold(ndx+ifirst),1,winwork,1,jmove)
         call spbl1(lwind,winwork,n2,sum,weight(jjj),iopt,ierr)
         if(ierr.ne.0)then
          ierr = 1
          call gfree(pw)
          return
         endif
        endif
       end do
c +==============================+
c | Build the balancing operator |
c +==============================+
       call spbl2(n2,sum,iopt,xn,opratr,ierr)
       if(ierr.ne.0)then
        ierr = 2
        call gfree(pw)
        return
       endif
c +===================================+
c | Convolve the filter with the data |
c +===================================+
       ndx=-nsamp
       jjj = 0
       do kkk=1,ndo
        mdx = (kkk-1)*nsamp
        ndx=ndx+nsamp
        if(.not.dead(kkk))then
         jjj = jjj + 1
         do i=jmove,lwind
          winwork(i)=0.
         end do
         call vmov(Dhold(ndx+ifirst),1,winwork,1,jmove)
         call spbl3(lwind,winwork,n2,opratr,weight(jjj),scale,ierr)
         if(ierr.ne.0)then
          ierr=3
          call gfree(pw)
          return
         endif
c +=================================================+
c | If this is the first window, save the processed |
c | data into the hold buffer, else taper the       |
c | processed data into the hold buffer             |
c +=================================================+
         if(kk.eq.1)then
          do i=1,lwind
           data(i+mdx)=winwork(i)
          end do
         else
          jj=imid-1
          xj=iovlp
          do i=1,iovlp
           jj=jj+1
           x1=(i-1)/xj
           x2=1.0-x1
           data(jj+mdx)=data(jj+mdx)*x2 + winwork(i)*x1
          end do
          do i=iovlp+1,jmove
           jj=jj+1
           data(jj+mdx)=winwork(i)
          end do
         end if
        endif
       end do
      end do
      call gfree(pw)
      return
      end
