C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>

      integer luin,luout,j,i
      integer jerr
      integer mbytes,iby,ierror,ner,iget
      integer lbytes,nsamp,nsr,ntrc,nrcd
      integer nx,istat,ndx,kdx
      integer jp,ndo
      integer itr(SZLNHD), argis
      integer aper
      integer th4(SZLNHD)
      integer itrhd(1),zero(1),htrhd(1),hzero(1)
      integer first, last, rin
C
      real    Ritr(SZLNHD),ramp(SZLNHD)
      real    sr
      real    sum(1),opratr(1)
      real    Dhold(1),winwork(1),data(1),hdata(1)
      real    wdata(1),swt(1)
C
      character parr*43,name*4,title(66)*1,ntap*256, otap*256
C
      logical open, there,rec_seq,scale
      logical eof,error,dead(1),eor,hdead(1)
      logical even,odd,do_read
C
      POINTER       (pdhold, dhold),(pdata,data)
      POINTER       (pwinwork,winwork),(popratr, opratr)
      POINTER       (psum,sum)
      POINTER       (pth,itrhd),(phthd,htrhd)
      POINTER       (pzro,zero),(phdata,hdata)
      POINTER       (pwdata,wdata),(pdead,dead),(pswt,swt)
      POINTER       (phdead,hdead),(phzero,hzero)
C
      data name/'FXBL'/,open/.FALSE./
      data parr/'Frequency-Space(X) Spectral Balancing      '/
      data TITLE/66*' '/, error/.false./, eof/.false./
      data rec_seq/.false./
C
      equivalence (itr(1),th4(1),Ritr(1))

C +=========================+
* | Check for the HELP flag |
C +=========================+
      if (argis ('-?').gt.0 .OR. (argis('-H').gt.0)) then
         call help(LER)
         stop
      endif
      J=11
      DO I=1,43
         J=J+1
         TITLE(J)=parr(I:I)
      END DO
#include <f77/open.h>
C +===============================+
* | Get the processing parameters |
C +===============================+
      call gcmdln(ntap,otap, idezin,ixovlp,iwndw,iwnovlp,mode,
     1            lramp,scale,irs,ire)
      if(ixovlp.eq.0)ixovlp=50
      if(iwnovlp.eq.0)iwnovlp=50

      if(mode.ne.1)mode=0

      if(ixovlp.gt.80)then
       write(LERR,*)'Spatial overlap cannot exceed 80%'
       error = .true.
      endif

      if(iwnovlp.gt.50)then
       write(LERR,*)'Temporal overlap cannot exceed 50%'
       error=.true.
      endif

      if(mode.eq.1)rec_seq=.true.

      aper = idezin
      if(aper/2*2.eq.aper)then
       even=.true.
       odd =.false.
      else
       even=.false.
       odd =.true.
      endif
      if(aper.le.5)aper= 7
      jxovlp = float(aper)*float(ixovlp)*.01

      if(ntap.ne.' ')then
       there = .false.
       inquire(file = ntap, exist = there)
       if(.not.there) then
        write(LER,*)'Requested input data set does not exist.',
     &'  Try again.'
        stop
       endif
      endif
      call gamoco(title,1,LERR)
C +====================+
C |Open input data set |
C +====================+
      ierror = 0
      call getln(luin, ntap,'r', 0)
      if(luin.lt.0)then
       write(LER,*)' Unable to open input. Abort'
       stop
      endif
      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
       write(LER,*)' Error reading lineheader from input. Abort'
       call lbclos(luin)
       stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsr  , LINHED)
      call saver(itr, 'NumRec', nrcd , LINHED)
      call saver(itr, 'NumTrc', ntrc,  LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
      if(irs.eq.0)irs = 1
      if(ire.eq.0)ire = nrcd
      tsr = nsr
c     if(tsr.gt.64)tsr=tsr*.001

      if(ntrc.le.1.and.aper.eq.0)then
       write(LER,*)' -d parameter must be specified for stack data'
       write(LER,*)' Also, use mode 0, not mode 1'
       call lbclos(luin)
       stop
      endif
      if(rec_seq.and.ntrc.le.1)then
       write(LER,*)' Must use mode 0 for stack data. Fatal!'
       call lbclos(luin)
       stop
      endif
      if(rec_seq.and.aper.gt.ntrc)then
       write(LER,*)' aper too large for record sequential mode. Fatal!'
       call lbclos(luin)
       stop
      endif

      lramp = lramp / tsr
      do i=1,lramp
       rx=1./float(lramp-i+1)
       ramp(i)=rx
      end do
      limit = nsamp - lramp
      if(iwndw.eq.0)iwndw = tsr*nsamp
      if(iwndw.gt.tsr*nsamp)iwndw=tsr*nsamp
      lslide=iwndw
      ifour=4
      call hlhprt(itr,lbytes,name,ifour,LERR)
      if(ierror.eq.1)then
       write(LERR,*)'No header read on input data set. Fatal.'
       error = .true.
      endif
      if(ierror.eq.2)then
       write(LERR,175)nsamp
  175 format('The number of samples per trace (',I5,') > 3000.',
     :'Fatal.')
       error = .true.
      endif

      sr=float(nsr)*0.001
      if(nsr.gt.64)sr=sr*.001
      xslide=float(lslide+nsr-1)*.001
      jslide=xslide/sr
      iovlp=float(jslide)*float(iwnovlp)*.01
      last = 0
      do while (last.lt.nsamp)
       if(last.eq.0)then
        first = 1
        last = jslide + iovlp
        nwin = 1
       else
        nmove = jslide+iovlp
        first = first + iovlp
        last = first + nmove -1
        nwin = nwin+1
       endif
      end do
      if(nwin.eq.1)iovlp = 0

      if(error)then
       call lbclos(luin)
       stop 100
      endif


      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

C +=================================+
* | Compute the output trace length |
C +=================================+
      mbytes = nsamp + ITRWRD
      mbytes = mbytes*ISZBYT
C +=======================================+
* | Update the hlh, compute number of     |
* | output records and traces per record. |
C +=======================================+
      iby = lbytes
      call savhlh(itr,iby,lbytes)
C +===========================================+
* | Open the output and write the line header |
C +===========================================+
      call getln(luout, otap,'w', 1)
      if(luout.lt.0)then
       write(LER,*)' Unable to open output. Abort'
       call lbclos(luin)
       stop
      endif
*     call savew(itr, 'NumRec', ire,  LINHED)
      call wrtape(luout,itr,lbytes)
C +==============================+
* | Allocate the required memory |
C +==============================+
      N2 = 128
      do while(N2.lt.nsamp)
       N2=N2+N2
      end do
      ierror =0
      ner=0
      iget=nsamp*ISZBYT*2
      call galloc(pwinwork, iget,ierror,0)
      ner=ner+ierror

      iget=(N2+N2+2)*ISZBYT
      call galloc(popratr,iget,ierror,0)
      ner=ner+ierror
      call galloc(psum ,iget,ierror,0)
      ner=ner+ierror

      if(rec_seq)then
cprg  this used to be dimensioned jxovlp+jxovlp+ntrc+ntrc   
      iget=(jxovlp+jxovlp+ntrc)*nsamp*ISZBYT
      else
      iget=(jxovlp+jxovlp+aper+aper)*nsamp*ISZBYT
      endif
      call galloc(pdhold,iget,ierror,0)
      ner=ner+ierror
      call galloc(phdata, iget,ierror,0)
      ner=ner+ierror
      call galloc(pdata,iget,ierror,0)
      ner=ner+ierror

      if(rec_seq)then
       iget=(jxovlp+ntrc)*ITRWRD*ISZBYT
      else
       iget=(jxovlp+jxovlp+aper+aper)*ITRWRD*ISZBYT
      endif
      call galloc(pth,iget,ierror,0)
      ner=ner+ierror
      call galloc(phthd,iget,ierr,0)

      if(rec_seq)then
       iget=(jxovlp+ntrc+ntrc)*ISZBYT
      else
       iget=(jxovlp+jxovlp+aper+aper)*ISZBYT
      endif
      call galloc(pzro ,iget,ierror,0)
      ner=ner+ierror
      call galloc(phzero ,iget,ierror,0)
      ner=ner+ierror
      iget = (aper+1)*(nsamp+ITRWRD)*ISZBYT
      call galloc(pwdata,iget,ierror,0)
      ner=ner+ierror
      call galloc(pswt,iget,ierror,0)
      ner=ner+ierror
      iget = 2*ntrc*ISZBYT
      if(ntrc.eq.1.or.aper.gt.ntrc)then
       iget=(aper+aper+jxovlp+jxovlp)*ISZBYT
      endif
      call galloc(pdead,iget,ierror,0)
      ner = ner+ierror
      call galloc(phdead,iget,ierror,0)
      ner = ner+ierror

      if(ner.ne.0)then
       write(LERR,*)' Unable to allocate memory.  Reduce data set',
     :       ' size and try again.'
       call lbclos(luin)
       call lbclos(luout)
       stop
      endif


      do i=1,aper
       wdata(i)=0.
       swt(i)=float(i-1)/float(aper)
      end do
      write(LERR,*)' '
      write(LERR,*)'aper   = ',aper
      write(LERR,*)'jxovlp = ',jxovlp
      write(LERR,*)'jslide = ',jslide
      write(LERR,*)'iovlp   = ',iovlp
      write(LERR,*)'offset = ',rec_seq
C +================================================================+
C | If the process mode is offset-variant, process record_seq mode |
C +================================================================+
      if(rec_seq)then
C +================================================+
C | If the process mode is offset-variant, process |
C | process rec_seq mode                           |
C +================================================+

      eof = .false.
      rin = 0
c +-----------------------+
c | Read a record of data |
c +-----------------------+
      do while(.not.eof)

       rin = rin + 1
       npanel = 0

       do i=1,ntrc

c----
c   initialize dead trace flag vector and mute time vector
c----
        hdead(i) = .false.
        hzero(i) = 0

        nit = 0
        call rtape(luin,itr,nit)
        if(nit.eq.0)then
         if(i.eq.1)then
          write(LERR,*)'EOF on input data set. Job complete'
         else
          write(LERR,*)'EOF found reading data. Fatal!'
          write(LER ,*)'EOF found reading data. Fatal!'
         endif
         call lbclos(luin)
         call lbclos(luout)
         stop
        endif
        ndx = (i-1)*nsamp+1
        mdx = (i-1)*ITRWRD
        call saver2(th4,ifmt_StaCor,l_StaCor,ln_StaCor,
     :   istat,TRACEHEADER)
        call saver2(th4,ifmt_RecNum,l_RecNum,ln_RecNum,
     :   irec ,TRACEHEADER)
        call vmov(itr,1,htrhd(mdx+1),1,ITRWRD)

        if(istat.lt.30000)then

         do j=0,nsamp-1
          hdata(ndx+j)=Ritr(ITHWP1+j)
         end do
         hdead(i)=.false.
         j=1
         k=ITHWP1
         do while(Ritr(k).eq.0.and.j.le.nsamp)
          j=j+1
          k=k+1
          hzero(i)=j
         end do
         if(j.eq.nsamp)hdead(i)=.true.

        else

         do j=0,nsamp-1
          hdata(ndx+j)=0.
         end do
         hdead(i)=.true.
         hzero(i)=nsamp
        endif

       end do
      
       koknt=0
       iwide = aper+jxovlp+jxovlp
       nin = 0
       koknt=0
       koffknt=0
       do i=1,iwide
        dead(i)=.false.
       end do
       istart=1
       nread=aper+jxovlp
       ipass=0
       ndo = 0	
       live = 0
       jloc=jxovlp
c------>
       eor = .false.
       do while(.not.eor)

          npanel = npanel  + 1

        do nx = istart,nread
         jx=nx
c +--------------------------------+
c | On first pass, data is stored  |
c | in a position offset by        |
c | jxovlp to make room for mirror |
c +--------------------------------+
         if(ipass.eq.0)jx=nx+jxovlp
         nin = nin+1
         if(nin.gt.ntrc)then
          eor=.true.
          go to 102
         end if
         jloc=jloc+1

         dead(jloc)=hdead(nin)
         zero(jloc)=hzero(nin)
         ndo=ndo+1
C +============================================+
C | Save the data, saving a zero trace if dead |
C +============================================+
         ndx = (jx-1)*nsamp+1
         jdx = (nin-1)*nsamp+1

         do i=0,nsamp-1
          Dhold(ndx+i)=hdata(jdx+i)
         end do
        end do  
  102   continue

        if(ipass.eq.0)then

         do i=1,jxovlp
          k=jxovlp+i
          m=jxovlp-i
          mdxt=m*nsamp
          kdxt=k*nsamp

          do n=1,nsamp
           Dhold(mdxt+n)=Dhold(kdxt+n)
          end do
          ndo=ndo+1

          dead(m+1)=dead(k+1)
          zero(m+1)=zero(k+1)
         end do

        endif
 
        if(eor)then
         last=jloc
         first=jloc
         nget = jxovlp

         do k=1,nget
          last =   last - 1
          first = first + 1
          mdx = (last-1)*nsamp
          ndx = (first-1)*nsamp
          do i=1,nsamp
           Dhold(ndx+i)=Dhold(mdx+i)
          end do
          dead(first)=dead(last)
          zero(first)=zero(last)
          ndo = ndo + 1

         end do

        end if

C +================+
C | Do the balance |
C +================+
        do i=1,n2+n2+2
         sum(i)=0.
         opratr(i)=0.
        end do
        call balance(Dhold, winwork,sum, opratr,data,
     :  iovlp,nsamp,nwin,jslide,ndo,iopt,scale,dead,ierr)

C +=================+
C | Output the data |
C +=================+
        nout  = aper
        ipntr = jxovlp + 1
        if(eor)then
         nout =  jloc-jxovlp
        endif
c +-------------------------------------------------+
c | In the output loop, apply the spatial smoothing |
c | weight to the data.  The spatial smoothing is   |
c | over an aperature of data, the wdata matrix     |
c | being the aper of data saved from the previous  |
c | filtered data and combined with the current     |
c | filtered data in the data matrix with the swt   |
c | set of weights.  Note that the first value is 0 |
c +-------------------------------------------------+
        Do jp=1,nout

         koknt=koknt+1

         if(koknt.le.nin)then

          ndx=(ipntr-1)*nsamp+1

c +------------------------------------+
c | save processed data in output matrix
c +------------------------------------+

          iopntr = ( (npanel - 1) * aper + (jp - 1) ) * nsamp + 1
          do  i = 0, nsamp-1
              hdata (iopntr + i) = data(ndx+i)
          enddo

          ipntr=ipntr+1

         endif

        End Do   
      
        call saver2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,
     :   irec ,TRACEHEADER)

C +=======================================================+
C | if not at end of input file, save the overlap portion |
C | of the data matrix into the hold area.                |
C +=======================================================+
        if(.not.eor)then
         m = 1
         iget=aper+1
         nread = iwide
         do i=iget,nread
          kdx=(i-1)*nsamp
          jdx=(m-1)*nsamp
          do j=1,nsamp
           Dhold(jdx+j)=Dhold(kdx+j)
          end do
          dead(m)=dead(i)
          zero(m)=zero(i)
          m=m+1
         end do
        endif
 
        istart =iwide-aper+1
        nread = iwide
        ndo = ndo-aper
        ipass=ipass+1
        jloc = istart-1
 
       end do

       do  j = 1, ntrc

           ndx = (j - 1) * nsamp  + 1
           mdx = (j - 1) * ITRWRD + 1

           call vmov (htrhd(mdx), 1, itr, 1, ITRWRD)

           call vmov (hdata(ndx), 1, itr(ITHWP1), 1, nsamp)

           if (.not. hdead(j)) then
              do  i = 1, hzero(j)
                  itr (ITRWRD+i) = 0
              enddo
           endif

           call wrtape (luout, itr, mbytes)

       enddo

      end do

      ELSE
C +====================================================+
C | If the process mode is not offset-variant, process |
C | process line_seq mode                              |
C +====================================================+

c +-------------------------------------+
c | Need to read the data first to find |
c | first live trace.  Leading dead     |
c | traces can cause the counter to go  |
c | haywire                             |
c +-------------------------------------+
      istat = 30000 
      do_read = .false.
      do while (istat.ge.30000)
       nit = 0
       call rtape(luin,itr,nit)
       if(nit.eq.0)then
        call lbclos(luin)
        call lbclos(luout)
        stop
       endif
       call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,
     :       istat, TRACEHEADER)
       if(istat.ge.30000)then
        call wrtape(luout,itr,nit)
       endif
      end do
      koknt=0
      iwide = aper+jxovlp+jxovlp
      nin = 0
      koknt=0
      koffknt=0
      do i=1,iwide
       dead(i)=.false.
      end do
      istart=1
      nread=aper+jxovlp
      eof=.false.
      ipass=0
      ndo = 0	
      live = 0
      jloc=jxovlp

      eof = .false.
      do while(.not.eof)

       do nx = istart,nread
        jx=nx
c +--------------------------------+
c | On first pass, data is stored  |
c | in a position offset by        |
c | jxovlp to make room for mirror |
c +--------------------------------+
        if(ipass.eq.0)jx=nx+jxovlp
        if(do_read)then
         nit=0
         call rtape(luin,itr,nit)
         if(nit.eq.0)then
          eof=.true.
          go to 202
         end if
        endif
        do_read = .true.
        jloc=jloc+1
        nin=nin+1
        call saver2(th4,ifmt_StaCor,l_StaCor, ln_StaCor,
     1             istat  , TRACEHEADER)
        ndo=ndo+1
        if(istat.lt.30000)then
         i=ITHWP1
         j=1
         zero(jx)=0
         do while(Ritr(i).eq.0.0 .and. j.le.nsamp)
           j=j+1
           i=i+1
           zero(jx)=j
         end do
         if(j.ge.nsamp)istat=30000
        else
         zero(jx)=0
        endif
C +====================+
C | Save trace headers |
C +====================+
        ndx = (jx-1)*ITRWRD+1
        call vmov(itr,1,itrhd(ndx),1,ITRWRD)
C +============================================+
C | Save the data, saving a zero trace if dead |
C +============================================+
        ndx = (jx-1)*nsamp+1
        if(istat .ge. 30000)then
         dead(jx)=.true.
         do i=0,nsamp-1
          Dhold(ndx+i)=0.
         end do
        else 
         dead(jx)=.false.
         do i=0,nsamp-1
          Dhold(ndx+i)=Ritr(ITHWP1+i)
         end do
        endif
       end do  
  202  continue
       if(ipass.eq.0)then
        do i=1,jxovlp
         k=jxovlp+i
         m=jxovlp-i
         kdxt=k*nsamp
         mdxt=m*nsamp
         kdxh=k*ITRWRD+1
         mdxh=m*ITRWRD+1
         call vmov(itrhd(kdxh),1,itrhd(mdxh),1,ITRWRD)
         do n=1,nsamp
          Dhold(mdxt+n)=Dhold(kdxt+n)
         end do
         ndo=ndo+1
         dead(m+1)=dead(k+1)
         zero(m+1)=zero(k+1)
        end do
       endif
 
c +--------------------------------+
c | If at eof, fold jxovlp traces  |
c | about the last.  Note that     |
c | sufficient space was allocated |
c | for the buffers to handle the  |
c | contingency of being near end  |
c | of buffer in this case         |
c +--------------------------------+
       if(eof)then
        nget = jxovlp
        do k=1,nget
         last =  jloc-k
         first = jloc+k
         mdx = (last-1)*nsamp
         ndx = (first-1)*nsamp
         idx = (last-1)*ITRWRD+1
         jdx = (first-1)*ITRWRD+1
         call vmov(itrhd(idx),1,itrhd(jdx),1,ITRWRD)
         do i=1,nsamp
          Dhold(ndx+i)=Dhold(mdx+i)
         end do
         dead(first)=dead(last)
         zero(first)=zero(last)
         ndo = ndo + 1
        end do
       end if
       do i=1,n2+n2+2
        sum(i)=0.
        opratr(i)=0.
       end do
       call balance(Dhold, winwork,sum, opratr,data,
     : iovlp,nsamp,nwin,jslide,ndo,iopt,scale,dead,ierr)

C +====================================+
C | Output the data. Include loop to   |
c | preserve early mute on live traces |
C +====================================+
        nout  = aper
        ipntr = jxovlp + 1
       if(eof)then
        nout = jloc-jxovlp
       endif
 
       Do jp=1,nout
        ndx=(ipntr-1)*nsamp+1
        jdx=(ipntr-1)*ITRWRD+1
        call vmov(itrhd(jdx),1,itr,1,ITRWRD)
        if(dead(ipntr))then
         do i=0,nsamp-1
          Ritr(ITHWP1+i)=0.
         end do
        else
         do i=0,nsamp-1
          Ritr(ITHWP1+i)=data(ndx+i)
         end do
        endif
        if(zero(ipntr).ne.0.and..not.dead(ipntr))then
         izro = zero(ipntr)
         il = ITHWP1+izro
         do j=0,izro-1
          Ritr(ITHWP1+j)=0.
         end do
         call vmul(itr(il),1,ramp,1,itr(il),1,lramp)
        endif
        call wrtape(luout,itr,mbytes)
        ipntr=ipntr+1
       End Do   
C +=======================================================+
C | if not at end of input file, save the overlap portion |
C | of the data matrix into the hold area.                |
C +=======================================================+
       if(.not.eof)then
        m = 1
        iget=aper+1
        nread = iwide
        do i=iget,nread
         kdx=(i-1)*nsamp
         mdx=(i-1)*ITRWRD+1
         jdx=(m-1)*nsamp
         ndx=(m-1)*ITRWRD
         call vmov(itrhd(mdx),1,itrhd(ndx+1),1,ITRWRD)
         do j=1,nsamp
          Dhold(jdx+j)=Dhold(kdx+j)
         end do
         dead(m)=dead(i)
         zero(m)=zero(i)
         m=m+1
        end do
       endif
 
       istart = iwide-aper+1
       nread = iwide
       ndo = ndo-aper
       ipass=ipass+1

       jloc = istart-1

      end do

      call lbclos(luin)
      call lbclos(luout)
      stop

      END IF
      stop
      end
      subroutine gcmdln(ntap,otap, idezin,ixovlp,iwndw,iwnovlp,mode,
     1                  lramp,scale,irs,ire)

      character ntap*(*), otap*(*)

      integer argis
      logical scale

	  ntap = ' '
      otap = ' '
      call argstr ('-N',ntap,' ',' ')          
      call argstr ('-O',otap,' ',' ')            
      call argi4('-d',idezin,0,0)
      call argi4('-sp',ixovlp,0,0)
      call argi4('-w',iwndw,0,0)
      call argi4('-tp',iwnovlp,0,0)
      call argi4('-md',mode,0,0)
      call argi4('-rs',irs,0,0)
      call argi4('-re',ire,0,0)
      call argi4('-rp',lramp,48,48)
      scale = (argis('-S').gt.0)
      return                                                  
      end
      subroutine help(LER)

      integer ler
      write(LER,*)  
     :'****************************************************************'
      write(LER,*)'Program FXBL.....................Frequency-Space (X)'
      write(LER,*)'                                 Spectral Balancing'
      write(LER,*)' '                                             
      write(LER,*)                                               
     :' -N [ntap]      (may be pipe)     : Input data file name'   
      write(LER,*)                                             
     :' -O [otap]      (may be pipe)     : Output data file name'
*     write(LER,*)                                           
*    :' -rs [rs]     (default = first)   : First record to process'
*     write(LER,*)                                           
*    :' -re [re]     (default = last)    : Last record to process'
      write(LER,*)                                           
     :' -d [design]    (#trc/rec)        : Length, in traces, of '
      write(LER,*)                                           
     :'                                    spatial design and '
      write(LER,*)                                           
     :'                                    application gate.'
      write(LER,*)                                           
     :' -sp [xovlp]  (default = 50)      : Percent overlap in spatial'
      write(LER,*)                                           
     :'                                    direction'
      write(LER,*)                                           
     :' -w  [na]    (default = trace     : Length, in ms, of temporal'
      write(LER,*)                                           
     :'               length)              design and application gate.'
      write(LER,*)                                           
     :' -tp [tovlp]   (default=50)       : Operator temporal overlap(%)'
      write(LER,*)                                           
     :' -md [mode]   (default = 0)       : Process mode:'
      write(LER,*)                                           
     :'                                    0 = line sequential'
      write(LER,*)                                           
     :'                                    1 = Record sequential'
      write(LER,*)                                           
     :' -rp [lramp]   (default = 48)     : length (ms) of on-mute ramp'
      write(LER,*)                                           
     :' -S            (default = No)     : If present, preserve scaling'
      write(LER,*)
     :'***************************************************************'
      write(LER,*)'Usage: ',
     :'fxbl -N[] -O[] -d[] -sp[] -w[] -tp[] -md[] -rp[] -S'
      write(LER,*)                                     
     :'***************************************************************'
      return                                                          
      end                                                            
