       subroutine ft3dSGI(sign, Fspace,nsamp2,ntrc2,ngath2,coeff)

         real sign
         integer nsamp2,ntrc2,ngath2
         complex Fspace(nsamp2,ntrc2,ngath2)

         integer isamp,itrc,igath
         complex xtemp(ntrc2)
         complex ytemp(ngath2)

         integer isign

         complex coeff(nsamp2+ntrc2+ngath2+90)

         integer nsamp2sv,ntrc2sv,ngath2sv
         data nsamp2sv /0/
         data ntrc2sv /0/
         data ngath2sv /0/

         save nsamp2sv,ntrc2sv,ngath2sv

         if ((nsamp2sv .ne. nsamp2) .or. (ntrc2sv .ne. ntrc2) &
             .or. (ngath2sv .ne. ngath2) ) then
           nsamp2sv = nsamp2
           ntrc2sv = ntrc2
           ngath2sv=ngath2
!--SGI--           call cfft3di(nsamp2,ntrc2,ngath2,coeff)
         endif

         ierr = 0

         isign = nint(sign)


!--SGI--         call cfft3d(isign,
!--SGI--     :               nsamp2,ntrc2,ngath2,Fspace,
!--SGI--     :               nsamp2,ntrc2,  coeff)

         if (isign .eq. -1) then
            Fspace = FSpace / float( nsamp2 * ntrc2 * ngath2 )
         endif

        return

100   continue

      write(LERR,*)' error ',ierr,' from fft routine'
      stop

        end











       subroutine ft3d(sign, Fspace,nsamp2,ntrc2,ngath2)

         real sign
         integer nsamp2,ntrc2,ngath2
         complex Fspace(nsamp2,ntrc2,ngath2)

         integer isamp,itrc,igath
         complex xtemp(ntrc2)
         complex ytemp(ngath2)

         ierr = 0

         isign = nint(sign)


         call nanchk(FSpace,nsamp2*ntrc2*2,13.e10)
!
! 3-D Fourier transform the traces
!

      do igath=1,ngath2
         do isamp=1,nsamp2
           xtemp = cmplx(0.,0.)
           xtemp(1:ntrc2)=FSpace(isamp,1:ntrc2,igath)
           call ftu( sign, ntrc2, xtemp, ierr )
          if (ierr .ne. 0) then
             write(0,*) ' sign,ntrc2,ierr=',sign,ntrc2,ierr
             write(0,*) ' xxx1'
             goto 100
          endif
           FSpace(isamp,1:ntrc2,igath) = xtemp(1:ntrc2)
         enddo
      enddo

         call nanchk(FSpace,nsamp2*ntrc2*2,12.e10)

      if (ngath2 .ge. 2) then
      do itrc=1,ntrc2
         do isamp=1,nsamp2
           ytemp = cmplx(0.,0.)
           ytemp(1:ngath2)=FSpace(isamp,itrc,1:ngath2)
           call ftu( sign, ngath2, ytemp, ierr )
          if (ierr .ne. 0) then
             write(0,*) ' xxx2'
             goto 100
          endif
           FSpace(isamp,itrc,1:ngath2) = ytemp(1:ngath2) 
         enddo
      enddo
      endif


         call nanchk(FSpace,nsamp2*ntrc2*2,11.e10) 

      do igath=1,ngath2
         do itrc=1,ntrc2
           call ftu( sign, nsamp2, FSpace(1,itrc,igath), ierr )
          if (ierr .ne. 0) then
             write(0,*) ' xxx3'
             goto 100
          endif
         enddo
      enddo

         call nanchk(FSpace,nsamp2*ntrc2*2,10.e10)


        return

100   continue

      write(LERR,*)' error ',ierr,' from fft routine'
      stop

        end
