C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gnfltu (LERR,lugr,SZSMPD,dispgr,mode,
     1                  alag, lagc, lag, lagr, lngfl, ampl, r2,
     2                  cinv, delf1, f1, ifflg, ifor, imut, iper,
     3                  iph, isi, isym,noscl, npt, nrc, nsamp, numf,
     4                  weit, iphze, iord)
 
      character * 4
     : title(24) 
 
      integer
     : ifflg, ifor, imut, iper, iph, iphze, i, isi, 
     : isym, ititle, lagc, lag, lagr, LERR, lngfl, 
     : ls, mode, nbz, noscl, npt, nrc, nsamp,
     : numf, numpts, r2nb, szsmpd, ordfft, iord
 
      real
     : ffta, fftb, alag, amax, ampl(*), cinv, coef, delf1,
     : delft, f1, r2(*), temp, weit, dt

      pointer (wkffta, ffta(1))
      pointer (wkfftb, fftb(1))

      logical 
     : dispgr
 
      integer ierr, iabort
 
      data 
     : title /'***','IMPU','LSE','RESP','ONSE',' OF ','FILT',
     :        'ER  ','    ','    ','    ',' ***',
     :        '***','IMPU','LSE','RESP','ONSE',' OF ','INVE',
     :        'RSE ','FILT','ER  ','    ',' ***'/
      data iabort/0/

      numpts = iphze - 1
c---
c for debugging
c---
c     write(0,*)'lugr,dispgr,mode,alag,lagc,lag,lagr,lngfl= ',
c    1lugr,dispgr,mode,alag,lagc,lag,lagr,lngfl
c     write(0,*)'delf1,f1,ifflg,ifor,imut,iper,iph,isi,isym= ',
c    1delf1,f1,ifflg,ifor,imut,iper,iph,isi,isym
c     write(0,*)'lngfl,numpts,noscl,npt,nrc,nsamp,numf,weit,iphze= ',
c    1lngfl,numpts,noscl,npt,nrc,nsamp,numf,weit,iphze


      numptsi = numpts
      if (f1 .ne. 0.0) then
         if1 = ifix (f1/delf1) + 1
         numptsi = numptsi + if1
      endif

1     continue
      nu = ordfft (numptsi+1)
      nfft = 2 ** nu
      nf = nfft / 2
      if (nf .lt. numpts) then
          numptsi = numptsi +1
          go to 1
      endif
      ls = nf
      npt = nfft
      if (lngfl .eq. 0) lngfl = nfft

      nbz = SZSMPD*2*nf
      ierrt = 0
      call galloc (wkffta, nbz, ierr, iabort)
      ierrt = ierrt + ierr
      call galloc (wkfftb, nbz, ierr, iabort)
      ierrt = ierrt + ierr
      if (ierrt .ne. 0) then
       write(LERR,*)'FATAL ERROR in genfu amp/phase option:'
       write(LERR,*)'Unable to allocate memory ',2*nbz,' bytes'
       write(LER ,*)'FATAL ERROR in genfu amp/phase option:'
       write(LER ,*)'Unable to allocate memory ',2*nbz,' bytes'
       call ccexit (666)
      endif

      call move (0,ffta,0,nbz)
      call move (0,fftb,0,nbz)

      call intrp (ampl, ampl(iphze), numpts, isi, delf1, f1, ffta,
     : fftb, ls, delft, LERR, SZSMPD, iord)

      do i=1,numpts
      ffta(i)=ampl(i)
      fftb(i)=ampl(i+numpts)
      enddo
      
      coef = 1.0
      if(mode .eq. 2) coef = -1.0
      if(iph .eq. 1) coef = -coef

      call lagcmp(alag,ls,delft,fftb,coef)
      if (mode .eq. 2) goto 200

      temp = ffta(1)
      do 140 i = 2, ls
        if( ffta(i) .gt. temp) temp = ffta(i)
140   continue

      if ( temp .eq. 0.0 ) then
         write(LERR,*)'FATAL ERROR in genfu: ampl phase option'
         write(LERR,*)'amplitude values appear to be zero!'
         write(LER ,*)'FATAL ERROR in genfu: ampl phase option'
         write(LER ,*)'amplitude values appear to be zero!'
         call ccexit (666)
      endif

      temp = 1./temp
      do 150 i = 1, ls
      ffta(i) = ffta(i) * temp
150   continue

180   r2nb = 4096 * szsmpd
      call move (0,r2,0,r2nb)
      call frtmau (nfft,ffta,fftb,ampl,r2,LERR,mode)

c----------------------------------------------------------
c   if no ross weighting, graph non-scaled filter response 
c----------------------------------------------------------
c
      if(weit .ne. 0.0)go to 205
      if(dispgr) then
        ititle = 1
        if(mode .eq. 2)ititle = 13
        call grap7u (ampl, 1, 4, 1.0, 1.0, title(ititle), npt, r2,
     :   lugr, szsmpd)
      endif
c
205   amax=0.0
      do 210 i=1,npt
        if (abs(ampl(i)) .gt. amax) amax=abs(ampl(i))
210   continue

      amax=1./amax
      do 215 i=1,npt
        ampl(i)=ampl(i)*amax
215   continue
      go to 999
 
200   temp=ffta(1)
      do 220 i=2,ls
        if(ffta(i).gt.temp) temp=ffta(i)
220   continue
      if(temp .le. 0.0) temp=1.0
c
      cinv=.01*cinv*temp
      do 240 i=1,ls
        if( ffta(i) .lt. cinv ) ffta(i)=cinv
      ffta(i) = 1./ffta(i)
240   continue
      go to 180

999   continue
      call gfree (wkffta)
      call gfree (wkfftb)

      return
      end
