C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE GRAP7U(X,N,KODE,DF,F1,TITLE,LX,Y,LERR,SZSMPD)
C
C     ABSTRACT - GRAPHING MODULE
C
C     PERTINENT INFORMATION -
C         X     = INPUT ARRAYS TO GRAPH (CONTIGUOUS ARRAYS)
C         N     = NUMBER OF LX LENGTH ARRAYS IN X
C         KODE  = TYPE SPECTRA TO GRAPH
C                 1 = AMPLITUED LINEAR
C                 2 = AMPLITUED LOG
C                 3 = PHASE
C                 4 = TIME FUNCTION
C                 5 = WAVE & INV. WAVE (LOG)
C                 6 = WAVE & INV. WAVE(LOG & LIN.)
C         DF    = FREQUENCY INCREMENT FROM FFT
C         F1    = STARTING FREQUENCY
C         TITLE = 48 CHARACTER TITLE
C         LX    = LENGTH OF EAGH SPECTRA
C
C----------------------------------------------------------------------
C
C
      CHARACTER*1 A(101),DAT(11)
      CHARACTER*4 TITLE(12)
      CHARACTER*22 LBAF
      REAL X(*),B(10),AMAX1(10),Y(*),YD(256),DBMAX(10)
      INTEGER LSCALE(11),SZSMPD,LERR
      
C
      DATA DAT/'1','2','3','4','5','6','7','8','9','*','I'/
      DATA LBAF/'AMPLITUDE    FREQUENCY'/
C
      WRITE (LERR,*)' '
      WRITE (LERR,*)' '
      WRITE (LERR,10) (TITLE(I),I=1,12)
 10   FORMAT (' ',12A4)
      GO TO (20,130,270,320,130,20) KODE
C
C     +-------------------------+
C     |    AMPLITUDE - LINEAR   |
C     |   FIND MAX FOR SCALING  |
C     +-------------------------+
C
 20   LX1 = 1
      NBYT = SZSMPD*10
      CALL MOVE(0,AMAX1,0,NBYT)
C
      DO 40 I=1,N
         AMAX = 0.0
C
         DO 30 K=1,LX
            IF (X(LX1).GT.AMAX) AMAX = X(LX1)
            LX1 = LX1 + 1
 30      CONTINUE
C
         IF (AMAX .NE. 0.) AMAX1(I) = 100.0/AMAX
 40   CONTINUE
C
C     +--------------------------------+
C     |   COMPUTE SCALE AND WRITE OUT  |
C     +--------------------------------+
C
      LSCALE(1) = 0
C
      DO 50 I=1,10
         LSCALE(I+1) = LSCALE(I) + 10
 50   CONTINUE
C
      WRITE (LERR,*)' '
      WRITE (LERR,60) LBAF,(LSCALE(I),I=1,11)
c60   FORMAT (' AMPLITUDE    FREQUENCY',11(I4,6X))
60    FORMAT (1X,A22,11(I4,6X))
      WRITE (LERR,70)
 70   FORMAT (1X ,'(MEDIAN)',12X,' 0   X',10('---------X'))
C
C     +----------------------------+
C     |  COMPUTE MEDIAN AND SCALE  |
C     +----------------------------+
C
C     +-----------------+
C     |   FIX AND PLOT  |
C     +-----------------+
C
      FF1 = F1
C
      DO 90 I=1,LX
         DO 75 IIB = 1,101
75         A(IIB) = ' '
C
         DO 80 J=1,N
            JJ = (J-1) * LX + I
            IF (KODE.EQ.6) YD(JJ) = X(JJ)
            X(JJ) = X(JJ) * AMAX1(J)
            B(J) = X(JJ)
            KK = IFIX (X(JJ)+0.5) + 1
            A(KK) = DAT(J)
 80      CONTINUE
C
c        Write(lerr,*)' amed function next'
         Y(I) = AMED(B,N)
         KK = IFIX (Y(I)+0.5) + 1
         A(KK) = DAT(10)
         WRITE (LERR,250) Y(I),FF1,A
         FF1 = FF1 + DF
 90   CONTINUE
C
     
      WRITE (LERR,*)' '
      WRITE (LERR,100)
 100  FORMAT (21X,' 0   X',10('---------X'))
      WRITE (LERR,110) LSCALE
 110  FORMAT (14X,'FREQUENCY',11(I4,6X))
      WRITE (LERR,*)' '
      WRITE (LERR,*)' '
      WRITE (LERR,120) (AMAX1(I),I=1,9)
 120  FORMAT ('FUNCTION SCALE FACTORS:'/1X ,'TRACE',8X,'1',9X,'2',
     $9X,'3',9X,'4',9X,'5',9X,'6',9X,'7',9X,'8',9X,'9'//10X,9(1X,F9.4))
      IF (KODE.EQ.6) GO TO 380
      RETURN
C
C     +-------------------+
C     |  AMPLITUDE - LOG  |
C     +-------------------+
C
 130  IF (KODE.NE.5) GO TO 160
      AMAX = 0.0
C
      DO 140 I=1,LX
         IF (X(I).GT.AMAX) AMAX = X(I)
 140  CONTINUE
C
      DO 150 K=1,LX
         X(K) = X(K) - AMAX + 100.0
 150  CONTINUE
C
      GO TO 190
C
C     +------------+
C     |  FIND MAX  |
C     +------------+
C
 160  LX1 = 1
      CALL MOVE(0,DBMAX,0,SZSMPD*10)
C
      DO 180 I=1,N
         AMAX = 0.0
C
         DO 170 K=1,LX
            IF (X(LX1).GT.AMAX) AMAX = X(LX1)
            LX1 = LX1 + 1
 170     CONTINUE
C
         AMAX1(I) = AMAX
         DBMAX(I) = 100.0 - (20.0 * ALOG10 (AMAX1(I)) )
 180  CONTINUE
C
C     +--------------------------------+
C     |   COMPUTE SCALE AND WRITE OUT  |
C     +--------------------------------+
C
 190  LSCALE(1) = -100
C
      DO 200 I=1,10
         LSCALE(I+1) = LSCALE(I) + 10
 200  CONTINUE
C
      WRITE (LERR,*)' '
      WRITE (LERR,210) LSCALE
 210  FORMAT('     DB       FREQUENCY',11(I4,6X))
      WRITE (LERR,220)
 220  FORMAT(' (MEDIAN)',12X,' 0   X',10('---------X'))
C
C     +-----------------+
C     |   FIX AND PLOT  |
C     +-----------------+
C
      FF1 = F1
C
      DO 260 I=1,LX
         DO 225 IIB = 1,101
225        A(IIB) = ' '
C        CALL MOVE (2,A,0,101)
C
         DO 240 J=1,N
            JJ = (J-1) * LX + I
            IF (KODE.EQ.5) GO TO 230
            X(JJ) = 20.0 * ALOG10(X(JJ)) + DBMAX(J)
 230        B(J) = X(JJ)
            KK = 1 + IFIX (X(JJ) + 0.5)
            KK = MAX0(1,KK)
            KK= MIN0(101,KK)
            A(KK) = DAT(J)
 240     CONTINUE
C
         Y(I) = AMED(B,N)
         KK = 1 + IFIX(Y(I) + 0.5)
         KK = MAX0(1,KK)
         KK = MIN0(101,KK)
         A(KK) = DAT(10)
         VAL = Y(I) - 100.0
         WRITE (LERR,250) VAL,FF1,A
 250     FORMAT (' ',F10.3,2X,F10.3,'  I',101A1,'I')
         FF1 = FF1 + DF
 260  CONTINUE
C
      WRITE (LERR,100)
      WRITE (LERR,110) LSCALE
      RETURN
C
C     +--------------+
C     |  PHASE PLOT  |
C     +--------------+
C
C     +-------------------------------+
C     |  COMPUTE SCALE AND WRITE OUT  |
C     +-------------------------------+
C
 270  LSCALE(1) = -180
C
      DO 280 I=1,10
         LSCALE(I+1) = LSCALE(I) + 36
 280  CONTINUE
C
      WRITE (LERR,*)' '
      WRITE (LERR,290) LSCALE
 290  FORMAT (' PHASE DEG    FREQUENCY',11(I4,6X))
      WRITE (LERR,70)
C
C     +-------------------------------+
C     | COMPUTE MEDIAN, FIX AND PLOT  |
C     +-------------------------------+
C
      FF1 = F1
C
      DO 310 I=1,LX
         DO 295 IIB = 1,101
295        A(IIB) = ' '
C        CALL MOVE (2,A,0,101)
         A(51) = DAT(11)
C
         DO 300 J=1,N
            JJ = (J-1) * LX + I
            B(J) = X(JJ)
            KK = IFIX((X(JJ)+1.85)/3.6) + 51
            A(KK) = DAT(J)
 300     CONTINUE
C
         Y(I) = AMED(B,N)
         KK = IFIX((Y(I)+1.85)/3.6) + 51
         A(KK) = DAT(10)
         WRITE (LERR,250) Y(I),FF1,A
         FF1 = FF1 + DF
 310  CONTINUE
C
      WRITE (LERR,100)
      WRITE (LERR,110) LSCALE
      RETURN
C
 320  AMAX = 0.0
C
      DO 330 K=1,LX
         IF (ABS(X(K)).GT.AMAX) AMAX = ABS(X(K))
 330  CONTINUE
C
      IF (AMAX.NE.0.) AMAX = 100. / AMAX
      LSCALE(1) = -100
C
      DO 340 I=1,10
         LSCALE(I+1) = 20 + LSCALE(I)
 340  CONTINUE
C
      WRITE (LERR,*)' '
      WRITE (LERR,350) LSCALE
 350  FORMAT(' AMPLITUDE    TIME (MS)',11(I4,6X))
      WRITE (LERR,70)
      F = 0.1
      IF (F1.LT.0) F = -0.1
      KF1 = F1 + F
      IDF = DF + 0.1
C
      DO 370 I=1,LX
         DO 355 IIB = 1,101
355        A(IIB) = ' '
C        CALL MOVE (2,A,0,101)
         A(51) = DAT(11)
         Y(I) = X(I) * AMAX
         KK = IFIX((Y(I)+1.)*0.5) + 51
         A(KK) = DAT(10)
         WRITE (LERR,360) Y(I),KF1,A
 360     FORMAT (' ',F10.3,2X,I10,'  I',101A1,'I')
         KF1 = KF1 + IDF
 370  CONTINUE
C
      WRITE (LERR,100)
      WRITE (LERR,350) LSCALE
      RETURN
C
 380  WRITE (LERR,10) (TITLE(I),I=1,48)
      FF1 = F1
      DBMAX1 = 20.0 * ALOG10(AMAX)
      LSCALE(1) = -100
C
      DO 390 I=1,10
         LSCALE(I+1) = 10 + LSCALE(I)
 390  CONTINUE
C
      WRITE (LERR,210) LSCALE
      WRITE (LERR,100)
C
      DO 400 K=1,LX
         DO 395 IIB = 1,101
395        A(IIB) = ' '
         VAL = 20.0 * ALOG10(YD(K)) - DBMAX1 + 100.0
         KK = 1 + IFIX(VAL+0.5)
         KK = MAX0(1,KK)
         KK = MIN0(101,KK)
         A(KK) = DAT(10)
         VAL = VAL - 100.0
         WRITE (LERR,250) VAL,FF1,A
         FF1 = FF1 + DF
 400  CONTINUE
C
      WRITE (LERR,100)
      WRITE (LERR,110) LSCALE
      RETURN
      END
