C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine mphase (nsamp,ampl,work2,work1,temp,se1,se2,
     1                   shape,prew,shp,SZSMPD)

#include <f77/iounit.h>

      complex  temp(*)
      real     ampl(*), work1(*), work2(*), shape(*)
      real     se1, se2, prew
      integer  ordfft, nsamp, nt, nf, SZSMPD
      logical  shp

      do  i = 1, nsamp
          a = ampl(i)
          if (a .ne. 0.0) then
             sgn = a / abs(a)
             go to 1
          endif
      enddo
1     continue

      IF ( shp ) THEN

         call vclr   (work2, 1, nsamp)
         en = 0.
         do  i = 1, nsamp
             en = en + ampl(i) * ampl(i)
         enddo
         en1 = sqrt(en / float(nsamp) )
         work2(1) = 1.0
         call shape1 (nsamp,ampl,nsamp,work2,nsamp,work1,se1,shape,prew)
         call vclr   (work2, 1, nsamp)
         work2(1) = 1.0
c        prw1 = .00001
         prw1 = .01 * prew
         call shape1 (nsamp,work1,nsamp,work2,nsamp,ampl,se2,shape,prw1)
         en = 0.
         do  i = 1, nsamp
             en = en + ampl(i) * ampl(i)
         enddo
         en2 = sqrt(en / float(nsamp) )
         do  i = 1, nsamp
             ampl (i) = -sgn * en1 *ampl (i) / en2
         enddo
         write(LERR,*)'Double inverse prewhitening :  ',prew
         write(LERR,*)'Double inverse square errors:  ',se1,se2

      ELSE

         nu = ordfft (4*nsamp+1)
         nt = 2 ** nu
         nf = nt/2 + 1
         pi = 3.14159265
         nl = nf/2 - 1
C +----------------------------------------------------+
C | get amplitude spectrum                             |
C +----------------------------------------------------+
         do  i = 1, nt
             temp (i) = cmplx (0.,0.)
         enddo
         do  i = nsamp+1, nt
             ampl (i) = 0
         enddo
         call rfftf  (ampl, temp, nt)
         call rfftsc (temp, nt, 3, 1)
         call cvabs  (temp, 2, ampl, 1, nf)
C +----------------------------------------------------+
C | take log of amp non-zero amp spectrum              |
C | then compute hilbert xform of log amp to get phase |
C | this will be the min delay phase                   |
C +----------------------------------------------------+
         jj = 0
         do  i = 1, nf
             a = ampl (i)
             if (a .ne. 0.0) then
                 jj = jj + 1
                 work1 (i) = alog ( a )
             else
                 work1 (i) = 0
                 go to 2
             endif
         enddo
2        continue

         call vclr (work2, 1, nf)
         call hilbertx (work1, jj, work2, ierr, SZSMPD)

         if (ierr .ne. 0) then
            write(LERR,*)'FATAL ERROR in hilbert transform:'
            write(LERR,*)'unable to allocate memory'
            write(LER ,*)'FATAL ERROR in hilbert transform:'
            write(LER ,*)'unable to allocate memory'
            call ccexit (666)
         endif

         do  i = 1, nt
             temp (i) = cmplx (0.,0.)
         enddo
C +----------------------------------------------------+
C | insert min delay phasse & inverse fft              |
C +----------------------------------------------------+
         call cvmexp (work2, 1, ampl, 1, temp, 2, nf)
         call vclr (ampl, 1, nsamp)
         call rfftsc (temp, nt, -3, 0)
         call rffti  (temp, ampl, nt)
         do  i = 1, nsamp
             ampl (i) = -ampl (i)
         enddo

      ENDIF

      return
      end
