C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine muproc(rtrace,tralen,isi,printr,kop,zeros,
     :rmpdim,szsmpd)
c  name    : build ramp                                               *
c  bldrmp author  : phil nollan - 2/02/82                                             *
c code extracted from bldrmp and
c revised to a single entry routine to circumvent problems
c that occurred because of the multiple entries.  this single
c entry routine only includes the code that is used in 	genf.
c herb wright - 4/15/91
c                                                                  *
c  purpose : will build a 48ms ramp to be         
c            used for smoothing the front of a trace.              *
c                                                                  *
c  input   : isi    - integer  sample interval given in ms.        *
c                                                                  *
c            printr - integer  printer unit number.                *
c                                                                  *
c                                                                  *
c            rmpflg - logical  flag used by "rstore" routine.      *
c                                                                  *
c            ramp   - real  ramp array used by "rstore" routine.   *
c                                                                  *
c            rmpdim - integer * 4 value for ramp dimension of 48   *
c                                                                  *
c            rmpflg - logical * 4 ramp flag indicates "bldrmp"     * 
c                     invoked                                      *
c                                                                  *
c                                                                  *
c*******************************************************************
c  modifications:                                                  *
c code extracted from bldrmp for this routine.  attempted to use
c bldrmp in usp genfu but ran into problems when mute flag was
c turned on.  the variable kop controls whether "bldrmp", "rzeros"
c or "rstore" code is executed.
c herb wright - 3/12/91
c***********************************************************************
c 
c           12/01/82  by phil nollan                                  *
c                     placed a check in entry "rstore" to reset       *
c                     the ramp length.  this will stop any attempt    *
c                     to apply the ramp past the end of the trace.    *
c                                                                     *
c                                                                     *
c**********************************************************************
c                                                                     *
c**********************************************************************
c  amoco production co. proprietary - to be maintained in confidence  *
c**********************************************************************
c
c
c                       ----------------------------
c                       |       declarations       |
c                       ----------------------------
c
c
      real     rtrace(*), xramp
c
      integer  rmplen, rmpdim, printr, datlen, factor, tralen, szsmpd
c
      logical  rmpflg, zerofg, zeros
c
      common /muting/ rmplen, factor, xramp, icount, datlen,
     :                rmpflg, zerofg, ramp(48)
c
      data       ientry/0/
c
      if(ientry.eq.0) then
        ientry = 1
        icount = 0
        rmpflg = .false.
        zerofg = .false.
      endif
c
c                       ----------------------------
c                       | validate sample interval |
c                       ----------------------------
c
      if(kop.lt.1.or.kop.gt.3) then
         write(printr,*)' invalid option specified - muproc'
         write(printr,*)' programming coding error'
         stop
      endif
      goto (1000,2000,3000) kop
1000  continue

      if ( isi .eq. 1  .or.
     *     isi .eq. 2  .or.
     *     isi .eq. 4  .or.
     *     isi .eq. 6  .or.
     *     isi .eq. 8  .or.
     *     isi .eq. 12 .or.
     *     isi .eq. 16)     go to 10
c
c
c                     --------------------------------
c                     | print error message and exit |
c                     --------------------------------
c
c
      write (printr,1) isi
    1 format('0','** m0065 **  error detected by subroutine bldrmp',/,
     *t14,' the sample interval "',i4,'" is invalid.    the sample in',
     *    'terval must be one of the following " 1,2,4,6,8,12,16 " .')
c
      stop
c
c
c
c
c                       ---------------------------
c                       |  calculate ramp length  |
c                       ---------------------------
c
   10 rmplen = rmpdim / isi
c
c
c                       ----------------------------
c                       | calculate ramp increment |
c                       ----------------------------
c
      xramp = 1.0 / float (rmplen) 
c 
c 
c                      
c                        ----------------------------                         
c                       |   initialize ramp array   |                         
c                        ----------------------------  
      xi = 0.0
c
      do 20 i=1,rmplen
         xi = xi + 1.0
         ramp (i) = xi * xramp
   20 continue
c
c
c             --------------------------------------------------
c             | indicate "bldrmp" was invoked by setting flag. |
c             --------------------------------------------------
c
      rmpflg = .true.
c
      return
c
2000   continue
c
c      entry rstore (rtrace,printr)
c    name   : restore 
c
c    purpose: this subroutine is called to restore an early mute of
c             zeros for a seismic trace and then smooth the trace     *
c             with a ramp function.   *note* "bldrmp" and either      *
c             "rzeros" or "izeros" must have been called prior to     *
c             calling "rstore".                                       *
c                                                                     *
c                                                                     *
c                                                                     *
c    input  : rtrace -  real*4 array holding the trace data.          *
c                                                                     *
c             printr -  integer*4 printer unit number.                *
c                                                                     *
c             ramp   -  real*4 array holding the ramp function.       *
c                       supplied by "bldrmp" routine.                 *
c                                                                     *
c             rmplen -  integer*4 value specifying the ramp           *
c                       length in samples.  supplied by "bldrmp" pgm. *
c                                                                     *
c             icount -  integer*4 value specifying the count          *
c                       of zeros to be placed in front of the trace.  *
c                       supplied  by  "rzeros" or "izeros" routine.   *
c                                                                     *
c             rmpflg -  log*4 flag used to verify bldrmp was invoked. *
c                       supplied by "bldrmp" routine.                 *
c                                                                     *
c             zerofg -  log*4 flag used to verify "zeros" was invoked.*
c                       supplied  by  "rzeros" or "izeros" routine.   *
c                                                                     *
c                                                                     *
c    output : rtrace -  real*4 array holding resorted trace data.     *
c                                                                     *
c                                                                     *
c                                                                     *
c                                                                     *
c**********************************************************************
c
c
c&&&& - second generation modification by:
c       phillip manning, 03/10/83
c
c      ---------------------------------------------------------------
c      |  set the factor default to 1 in case rstorf was not called  |
c      ---------------------------------------------------------------
c
      factor = 1
c
c      ------------------------------------------------------------
c      |  apply the factor to the leading zeros count and to the  |
c      |  trace length.                                           |
c      ------------------------------------------------------------
c
  200 if (factor .lt. 0) go to 210
c
      icount = icount * factor
      datlen = datlen * factor
c
      go to 220
c
  210 icount = icount / (- factor)
      datlen = datlen / (- factor)
c
  220 continue
c
c&&&&
c
c      ---------------------------------------------------------
c      |  verify that the "bldramp"  routine was invoked       |
c      |  prior to subroutine "restore" by checking its flag.  |
c      ---------------------------------------------------------
c
c
      if (rmpflg) go to 30
c
      write (printr,21)
   21 format('0','** m0066 **  error detected by subroutine rstore',/,
     *t14,' subroutine "bldrmp" must be called at least once before',
     *    ' subroutine "rstore".')
c
      stop
c
c
c      ---------------------------------------------------------
c      |  verify that a  "zeros"  routine was invoked prior    |
c      |  prior to subroutine "restore" by checking its flag.  |
c      ---------------------------------------------------------
c
   30 if (zerofg) go to 40
c
c
      write (printr,31)
   31 format('0','** m0067 **  error detected by subroutine rstore',/,
     *t14,' subroutine "rzeros" or subroutine "izeros" must be',
     *    ' called prior to each call to subroutine "rstore".')
c
      stop
c
c
   40 zerofg = .false.
c
c
c
c      ---------------------------------------------------------
c      | restore the zeros at the front of the trace if zeros  |
c      | were found.  if not then dont restore or apply ramp.  |
c      ---------------------------------------------------------
c
      if (icount .eq. 0)  go to 60
c
      call move (0,rtrace,0,icount * szsmpd)
c
c
c                 -----------------------------------
c                 | mutliply the ramp by the trace. |
c                 -----------------------------------
c
c --- reset the ramp length if necessary.
c
      if (icount + rmplen  .gt.  datlen)   rmplen = datlen - icount
c
      do 50 i=1,rmplen
c
          j = icount + i
          rtrace (j) = rtrace (j) * ramp (i)
c
   50 continue
c
   60 return
c
c
3000   continue
c     entry rzeros (rtrace,tralen,zeros)
c**********************************************************************
c                                                                     *
c  name    : real zeros                                               *
c                                                                     *
c  purpose : rzeros will count the number of leading zeros in         *
c            a r*4 trace for preserving the early mute .              *
c                                                                     *
c                                                                     *
c  input   : rtrace - r*4 array holding the trace data.               *
c            tralen - i*4 value specifying the trace length.          *
c                                                                     *
c                                                                     *
c  output  : zeros  - logical*4 variable that indicates :             *
c                     .true.  - trace data is all zeros               *
c                     .false. - trace data is not all zeros           *
c                                                                     *
c                                                                     *
c  variables passed:                                                  *
c                                                                     *
c            icount - i*4 counter that  contains the number of        *
c                     zeros found in the front of the trace.          *
c                     icount is set to zero when trace is all zeros.  *
c                     icount is passed on to "rstore" routine.        *
c                                                                     *
c            zerofg - log*4 flag set to indicate routine was invoked. *
c                     flag  is passed on to "rstore" routine.         *
c                                                                     *
c                                                                     *
c**********************************************************************
c
c
c
c             ---------------------------------------------
c             |  flag turned on to indicate "rzeros" was  |
c             |  invoked before "rstore" subroutine       |
c             ---------------------------------------------
c
      zerofg = .true.
c
c
c         ---------------------------------------------------------
c         |  count the number of zeros at the front of the trace. |
c         |  if trace is all zeros return the  zeros flag  as     |
c         |  "true", otherwise return the zeros flag as "false".  |
c         ---------------------------------------------------------
c
c
      zeros = .false.
c
      icount = 0
c
      do 70 i = 1,tralen
         if (rtrace(i) .ne. 0.0) go to 80
          icount = icount + 1
   70 continue
c
c
c
c         ----------------------------------------------------------
c         |  trace is all zeros so set flag to "true" and return.  |
c         ----------------------------------------------------------
c
      icount = 0
      zeros = .true.
c
   80 return
      end
