C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdfltc (lu10,lutmp,lerr,mode,fname,max,datout,
     1                   npt,iphze,verbos,apfile)
c
      character*81 card, tard
      character*(*) fname
      character*(*) apfile
      character*5 genf2, genf3, bgblk, gwh
      character*4 dtype
      character*1 blnk
c
      real
     :datout(*), datin(40),wrk1(5000),wrk2(5000)
c
      integer 
     :lerr,npt,nu,j,ifound,ict,lu10,mode,have2,ifirst,
     :ierr
c
      logical l,verbos, amp, phz
c
      data 
     :blnk/' '/,genf2/'2GENF'/,genf3/'3GENF'/,ifirst/0/,
     :namps/0/,nphze/0/,
     :bgblk/'     '/,have2/0/
c
c  test filename for existence
c     if no, then return with error flag set
c
      if (fname .eq. ' ') then

      call charct(apfile,100,lenf)
      dtype = 'OLD'
      inquire(file=apfile,exist=l)
      if(.not.l)then
        write (lerr,5)
        stop
      endif
      ios = 0
      open (unit=lu10, iostat=ios, file=apfile,
     :      status='OLD',form='FORMATTED')

      else

      call charct(fname,100,lenf)
      dtype = 'OLD'
      inquire(file=fname,exist=l)
      if(.not.l)then
        write (lerr,5)
        stop
      endif
      ios = 0
      open (unit=lu10, iostat=ios, file=fname,
     :      status='OLD',form='FORMATTED')

      endif

5       format(' **** error ****'/
     :         ' **** filter file does not exist')
c-----
c because the cray fortran compiler does not allow 
c free form internal read with a list.  it was necessary
c to work around that restriction by using a scratch 
c file.  this is better than having to rewrite the 
c routine and possibly having to force the user to have
c to adhere to some fixed format.
c-----
c     open(unit=lutmp,status='scratch',form='formatted')
c     open(unit=lutmp,status='unknown',form='formatted')

      ic2 = 0
      ic3 = 0
      istop = 0
      nu = 0
10    continue
      read(lu10,20,end=60)card(1:80)
20    format(a80)   

c-------------------------------------------------------------
c  mode = 1 or 2

      if(mode.ne.0) then

        IF (fname .ne. ' ') THEN

            rewind lu10
            nc = 0
            do  while (1.eq.1)

                read(lu10,'(a80)',end=889,err=888) card
                nc = nc + 1
            enddo
            go to 889
888         write(lerr,*)'genfu: FATAL ERROR reading amp-phz file'
            write(lerr,*)'check contents of file ',apfile
            write(ler ,*)'genfu: FATAL ERROR reading amp-phz file'
            write(ler ,*)'check contents of file ',apfile
            stop
889         continue

            rewind lu10

            igot1 = 0
            igot2 = 0
            do  j = 1, nc

                read(lu10,'(a80)') card
                if (card(1:5) .eq. '2GENF' .OR.
     1              card(1:5) .eq. '2genf') then
                    do i = 1, 75
                       tard(i:i) = card(i+5:i+5)
                    enddo
                    amp = .true.
                    phz = .false.
                elseif (card(1:5) .eq. '3GENF' .OR.
     1              card(1:5) .eq. '3genf') then
                    do i = 1, 75
                       tard(i:i) = card(i+5:i+5)
                    enddo
                    amp = .false.
                    phz = .true.
                else
                    write(LERR,*)'FATAL ERROR in GENF input option:'
                    write(LERR,*)'Card image'
                    write(LERR,*)card
                    write(LERR,*)'Input line not 2GENF (ampl) or'
                    write(LERR,*)'3GENF (phase) -- check input file'
                    call ccexit (666)
                endif

                ib = 0
                do i = 1, 75
                   ib = ib + 1
                   if (tard(i:i) .ne. blnk) go to 34
                enddo
34              continue
                ii = 0
                do i = ib, 75
                   ii = ii + 1
                   card (ii:ii) = tard (i:i)
                enddo

                ifound = 1
                ict = 1
                do jj = 1,75
                  if( ifound .ne. 0 ) then
                    if( card(jj:jj) .ne. blnk) goto 33
                    ifound = 0
                    go to 33
                  endif
                  if( card(jj:jj) .eq. blnk) goto 33
                  ifound = 1
                  ict = ict + 1
33                continue
                enddo

                call rdcard (ict, card, datin, LER,LERR)

                do  i = 1, 80 
                    card(i:i) = ' '
                    tard(i:i) = ' '
                enddo
                if (amp) then
                    do  i = 1, ict
                        wrk1(i+igot1) = datin(i)
                    enddo
                    igot1 = igot1 + ict
                elseif (phz) then
                    do  i = 1, ict
                        wrk2(i+igot2) = datin(i)
                    enddo
                    igot2 = igot2 + ict
                endif

            enddo
            do  i = 1, igot1
                datout (i) = wrk1 (i)
            enddo
            do  i = 1, igot2
                datout (i+igot1) = wrk2 (i)
            enddo
            if (igot1 .ne. igot2) then
               write(LERR,*)'FATAL ERROR in genfu amp/phase option:'
               write(LERR,*)'Unequal number of amp and phase entries'
               write(LERR,*)'# amps = ',igot1
               write(LERR,*)'# phase= ',igot2
               call ccexit (666)
            endif

            nc = igot1
            iphze = nc + 1
            nphze = nc
            namps = nc
c double nc since we're putting ampl & phz in same array
            nu = 2 * nc
            go to 60


        ELSE

c  read ampl/phase pairs (total number of pairs will be nc)

            rewind lu10
            nc = 0
            do  while (1.eq.1)

                read(lu10,'(a80)',end=999,err=998) card
                nc = nc + 1
            enddo
            go to 999
998         write(lerr,*)'genfu: FATAL ERROR reading amp-phz file'
            write(lerr,*)'check contents of file ',apfile
            write(ler ,*)'genfu: FATAL ERROR reading amp-phz file'
            write(ler ,*)'check contents of file ',apfile
            stop
999         continue

            rewind lu10
            do  j = 1, nc
 
                read(lu10,'(a80)') card
c               call fsscnf (card,'%f %f',datout(j),datout(nc+j))
                read (card,*) datout(j),datout(nc+j)
            enddo
            iphze = nc + 1
            nphze = nc
            namps = nc
c double nc since we're putting ampl & phz in same array
            nu = 2 * nc
            go to 60


        ENDIF

c--------------
c  mode = 0
      else 
c--------------

        if(card(1:2) .eq. '2G' .or. card(1:2) .eq. '2g') then
          write(lerr,*)'error in reading ',fname(:lenf)
          write(lerr,*)'not correct data for mode = ',mode
          stop
        endif
        if(card(1:2) .eq. '3G' .or. card(1:2) .eq. '3g') then
          write(lerr,*)'error in reading ',fname(:lenf)
          write(lerr,*)'not correct data for mode = ',mode
          stop   
        endif
c 
        ifound = 1
        ict = 1
        if( card(1:1) .eq. blnk) then
          ifound = 0
          ict = 0
        endif
c
        do j = 1,80
          if( ifound .ne. 0 ) then
            if( card(j:j) .ne. blnk) goto 30
            ifound = 0
            go to 30
          endif
c
          if( card(j:j) .eq. blnk) goto 30
          ifound = 1
          ict = ict + 1
        enddo
30      continue

        call rdcard (ict, card, datin, LER,LERR)
        do  i = 1, 80
            card(i:i) = ' '
            tard(i:i) = ' '
        enddo

      endif
c--------------------------------------------------------------
c
45    do 50 j = 1,ict
        nu = nu + 1
        if( nu .gt. max)then
          write(lerr,*)'buffer full!'
          write(lerr,*)'reading filter file:'
          write(lerr,*)'file = ',fname(:lenf)   
          write(lerr,*)' '   
          write(lerr,*)'if mode = 0 '
          write(lerr,*)'   max filter values allowed = 500'
          write(lerr,*)'if mode = 1 or 2 '
          write(lerr,*)'   max amp values allowed = 256'
          write(lerr,*)'   max phase values allowed = 256'
          stop
        endif
        datout(nu) = datin(j)
50    continue
c
      goto 10
c
60    continue

      if (iphze .ne. 0 ) then
        nphze = nu - iphze + 1
        if (nphze .ne. namps) then
          write (lerr,70)fname(:lenf),nphze, namps
70        format('error in reading filter file '/
     :       ' **** file = ',a50/
     :       ' **** the number of values for amp and'/
     :       ' **** phase are not the same.'//
     :       ' **** number of phase values     = ',i5/
     :       ' **** number of amp values = ',i5)
          istop = 1
        endif
        if ( nphze .gt. 256 .or. namps .gt. 256 ) then
          write (lerr,80)fname(:lenf),nphze, namps
80        format('error in reading filter file '/
     :       ' **** file = ',a50/
     :       ' **** number of phase values     = ',i5/
     :       ' **** number of amplitude values = ',i5)
          write(lerr,*)'      (max amp values allowed is 256)'
          write(lerr,*)'      (max phase values allowed is 256)'
          stop
        endif
        if (istop .ne. 0) stop
      else
        if ( nu .gt. 500 ) then
          write (lerr,90)fname(:lenf),nu
90        format('error in reading filter file '/
     :       ' **** file = ',a50/
     :       ' **** number of filter values    = ',i5)
          write(lerr,*)'      (max filter values allowed is 500)'
          stop
        endif     
      endif
      npt = nu
      return
      end
