C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine shape1 (lb, b, ld, d, la, a, ase, space, prew)

#include <f77/lhdrsz.h>

c   inputs:

c          B - input time series length lb
c          D - desired output series length ld
c         LA - length of shaping filter

c  outputs:

c          A - shaping filter
c        ASE - averaged squared error between desired & actual

      real   B(lb), D(ld), A(la), space(*)
      real   prew

      call cross (lb, b, lb, b, la, space)
      space(1) = .01 * prew * space(1) + space(1)
      call cross (ld, d, lb, b, la, space(la+1))

      call wiener(la,space,space(la+1),a,space(2*la+1),1,ierr)

      call dotpr (d, 1, d, 1, dd, ld)
      call dotpr (a, 1, space(la+1), 1, ag, la)

      ase = (dd - ag)/dd

      return
      end

