C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fweight (nsamp, nt, nf, dt, df, flolo, flohi, fhilo,
     1                    fhihi, fwt, verbos)

#include <f77/iounit.h>

      real     fwt (nf)
      real     flolo, flohi, fhilo, fhihi, dt
      integer  nsamp, nf, nt
      integer  ordfft
      logical  verbos

      nu = ordfft (nsamp)
      nt = 2 ** nu
      nf = nt / 2 + 1

      fnyq = 1. / (2. * dt)
      df = fnyq/float(nf-1)

      do  i = 1, nf
          fwt (i) = 0.0
      enddo

      if1 = nint ( flolo / df )
      if2 = nint ( flohi / df )
      if3 = nint ( fhilo / df )
      if4 = nint ( fhihi / df )

      if (if1 .le. 0 .and. if2 .gt. 1) if1 = 1
      if (if1 .le. 0 .and. if2 .le. 0) then
          if1 = 1
          if2 = 1
          fwt (1) = 1.0
      endif
      if (if3 .le. 0 .and. if4 .le. 0) then
          if3 = nf
          if4 = nf
          fwt (nf) = 1.0
      endif
      
      nf12 = if2 - if1
      if (nf12 .gt. 0) then
         do  i = if1, if2
             fwt (i) = float (i - if1) / float (nf12)
         enddo
      endif

      nf34 = if4 - if3
      if (nf34 .gt. 0) then
         do  i = if3, if4
             fwt (i) = float (if4 - i) / float (nf34)
         enddo
      endif

      do  i = if2+1, if3-1
          fwt (i) = 1.0
      enddo

      if (verbos) then
         write(LERR,*)' '
         write(LERR,*)'Trapezoid (',nf,') weights:'
         write(LERR,*)(fwt(i),i=1,nf)
         write(LERR,*)' '
      endif

      return
      end
