C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ******************** gexp Main Routine ******************************
c |   Program Description:                                            |
c |                                                                   |
c |  Read data from input data set, compute and remove the trace to   |
c |  trace average.  Read value to ignore in computing the average    |
c |  (defaults to zero).                                              |
c *********************************************************************

c get machine dependent parameters 

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard USP variables

      integer     itr( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes, obytes
      integer     ns, ne, irs, ire 
      integer     argis, nreco
      integer     jj,kk 

      real  tri( 1 )

      character  name * 4,  ntap* 255, otap * 255

      logical  verbos, glog

c declare variables used by this routine

      integer pipe
      integer ifmt_RecNum, l_RecNum, ln_RecNum, RecNum
      integer ifmt_StaCor, l_StaCor, ln_StaCor, StaCor

      logical vector, normalize, splice, panel

      pointer(pxt, tri)

c initialize variables

      data name /'GEXP'/
      data lbytes / 0 /
      data nbytes / 0 /
      data  obytes / 0 /
      data verbos/.false./
      data vector/.false./
      data pipe/3/
      data normalize/.false./
      data splice/.false./
      data panel /.false./

c get online help if requested

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
          call help(LER)
          stop
      endif

c open printout file

#include <f77/open.h>

c parse command line parameters

      call cmdln ( ntap, otap, irs,ire,ns,ne,glog)

c open dataset

      call getln( luin, ntap, 'r', 0)
      if (luin .lt. 0) then
         write(LERR,*)'Cannot open N dataset', ntap
         write(LERR,*)'Check spelling / existence and rerun'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'GEXP: Cannot open dataset', ntap
         write(LER,*)'       Check spelling / existence and rerun'
         write(LER,*)'FATAL'
         stop 100
      endif


c open output dataset

         call getln( luout, otap, 'w', 1)


c read the line header from dataset

      lbytes = 0
      call rtape ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)'GEXP: no header read on unit ',luin
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         write(LER,*)'GEXP: no header read on unit ',luin
         write(LER,*)'FATAL'
         write(LER,*)' '
         call lbclos(luin)
         call lbclos(luout)
         stop 100
      endif

c  get global parameters from lineheader

      call saver( itr, 'NumSmp', nsamp , LINHED )
      call saver( itr, 'SmpInt', nsi   , LINHED )
      call saver( itr, 'NumTrc', ntrc  , LINHED )
      call saver( itr, 'NumRec', nrec  , LINHED )
      if(ire.eq.0)ire=nrec
      if(irs.eq.0)irs=1
      call saver( itr, 'Format', iform , LINHED )

c set up pointers to trace header values to be used in this routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c print historical line header from dataset to printout file

      lname =  4
      call hlhprt (itr, lbytes, name, lname, LERR)

*rlc 21/09/01     if( nsamp .gt. SZLNHD ) then
*        write(LERR,*)'Too many samples in traces -- FATAL'
*        write(LERR,*)'window the input data & rerun'
*        write(LER,*)'GEXP: '
*        write(LER,*)'Too many samples in traces '
*        write(LER,*)'window the input data & rerun'
*        write(LER,*)'FATAL'
*        call lbclos(luin)
*        call lbclos(luout)
*        stop 100
*     endif

c check default values; update header

      call cmdchk( ns, ne, irs, ire, ntrc, nrec )
 
      nreco = ire - irs + 1
      ntrco = ne - ns + 1
      call savew( itr, 'NumRec', nreco, LINHED )
      call savew( itr, 'NumTrc', ntrco, LINHED )

      obytes = SZTRHD + SZSMPD * nsamp

      call savhlh( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c allocate trace space
      ier = 0
      ner = 0
      iget =nsamp * ISZBYT
      call galloc(pxt, iget,ier,0)
      if(ier.ne.0)then
       write(LERR,*)'Unable to allocate ',iget,' bytes.'
       write(LERR,*)'Check line header entries and/or reduce '
       write(LERR,*)'trace length.'
       write(LER ,*)'Unable to allocate ',iget,' bytes.'
       write(LER ,*)'Check line header entries and/or reduce '
       write(LER ,*)'trace length.'
       call lbclos(luin)
       call lbclos(luout)
       stop 100
      endif


c skip to start record in each dataset if required

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO jj = irs, ire
c skip to start trace if necessary
       if ( ns .gt. 1 ) then
        call trcskp ( jj, 1, ns-1, luin, ntrc, itr )
       endif
       DO kk = ns, ne
        nbytes = 0
        call rtape ( luin , itr, nbytes )
        if(nbytes .eq. 0) then
         write(LERR,*)'End of file on input :'
         write(LERR,*)'  rec= ',jj,'  trace= ',kk
         write(LER ,*)'End of file on input :'
         write(LER ,*)'  rec= ',jj,'  trace= ',kk
         go to 999
        endif
        call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1        StaCor1, TRACEHEADER)
        call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1        RecNum    , TRACEHEADER)
        if ( StaCor .lt. 30000 ) then
         call getexp(itr(ITHWP1),tri,nsamp,glog)
        else
         call vclr ( tri, 1, nsamp)
        endif
        call vmov ( tri, 1, itr(ITHWP1), 1, nsamp )
        call wrtape( luout, itr, obytes )
       ENDDO

c skip from current trace to end of record

       if ( ne .lt. ntrc) then
        call trcskp ( jj, ne+1, ntrc, luin, ntrc, itr )
       endif

      END DO

c normal termination

      call lbclos(luin)
      call lbclos(luout)

      write(LERR,*)' Normal Termination'
      write(LER,*)'gexp: Normal Termination'
      stop

 999  continue

c abnormal termination
      
      call lbclos(luin)
      call lbclos(luout)

      write(LERR,*)' Abnormal Termination'
      write(LER,*)'gexp: Abnormal Termination'
      stop
      end

c Subroutines, help, cmdln

      subroutine help(LER)

        write(LER,*)' '
        write(LER,*)
     *  'Command Line Arguments for gexp: data exponentiation'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]     -- input data set   (stdin)'
        write(LER,*)'-O[otap]     -- rotation of ntap (stdout)'
        write(LER,*)'-rs[rs]      -- start rec        (1)'
        write(LER,*)'-re[re]      -- end rec          (last)'
        write(LER,*)'-ns[rs]      -- start trace        (1)'
        write(LER,*)'-ne[re]      -- end trace          (last)'
        write(LER,*)'-R           -- Compute LN         (exp)'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      gexp -N[] -O[] -rs[] -re[] -ns[] -ne[] -R'
        write(LER,*)' '

      return
      end
c-----
c     get command arguments
c
c     ntap - C*255  input file name
c     otap  - C*255  output file name
c    irs   - I      start record
c    ire   - I      stop end record
c-----
      subroutine cmdln ( ntap, otap,irs,ire,ns,ne,glog)
c declare variable passed from calling routine
      character    ntap*(*),  otap*(*)
      logical verbos,glog
      integer argis

      call argstr('-N',ntap,' ',' ')
      call argstr('-O',otap,' ',' ')
      call argi4('-rs',irs,0,0)
      call argi4('-re',ire,0,0)
      call argi4('-ns',ns,0,0)
      call argi4('-ne',ne,0,0)
      verbos = ( argis( '-V' ) .gt. 0 )
      glog = (argis('-R').gt.0)
      return
      end
      subroutine getexp(x,y,n,glog)
      real x(*), y(*)
      logical glog
      do i=1,n
       if(x(i).ne.0.0)then
        if(glog)then
         if(x(i).gt.0.0)then
          y(i)=log(x(i))
         else
          y(i)=-log(abs(x(i)))
         endif
        else
          xx = x(i)
          if(abs(xx).lt.69.and.abs(xx).gt.1.0E-30)then
            y(i)=exp(x(i))
          else
           if(abs(xx).gt.69)then 
            if(xx.lt.0) then
             y(i)=-1.E30
            else
             y(i)=1.0E30
            endif
           else
            if(xx.lt.0)then
             y(i)=-1.0E-30
            else
             y(i)=1.0E-30
            endif
           endif
          endif
        endif
       else
        y(i)=0.
       endif
      end do
      return
      end
