C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c GLI2DISCO reads a gli3d file and extrracts user requested files for
c	disco input.
c
c
c**********************************************************************c
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer * 4 s( 40000,22), r( 40000,19) 
#include <f77/pid.h>
      character   sfile * 100, rfile * 100, corr * 20
      logical     verbos, query, type, type1, big, old
      integer     argis
 
      data lur / 30 /
      data lus / 40 /
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
 
c**********************************************************************c
      call gcmdln(rfile,sfile,type,type1,corr,big,old,verbos,iseed)

c-----
c     open gli3d file
c-----
	        open(unit=lur, file=rfile,form = 'formatted')
c		write(LER,*)'opened .ele file'
c-----
c     open disco file
c-----
	        open(unit=lus, file=sfile,form = 'formatted')
c		write(LER,*)'opened disco file'
c--------------------------------------------------

c--------------------------------------------------
c     READ gli3d file
 	if (old ) then
		if (big ) then
      			call readgli1(lur,ns,nr, s, r ,iseed)
		else
      			call readgli (lur,ns,nr, s, r ,iseed)
		endif	
 	else
		if(big ) then
      			call neadgli1(lur,ns,nr, s, r ,iseed)
		else
      			call neadgli (lur,ns,nr, s, r ,iseed)
		endif	
	endif
c	write DISCO file
		call writedisco(lus,ns,nr,s,r,type,type1,corr)
c		write(LER,*)'after write disco'

      end
 
c***********************************************************************
      subroutine help
#include <f77/iounit.h>
      WRITE(LER,*)
     :'***************************************************************'
      WRITE(LER,*)
     :'PROGRAM MODULE GLI2DISCO  --  CONVERT GLI to DISCO statics'
      WRITE(LER,*)
      WRITE(LER,*)
     :'Program GLIDISCO writes a list of static values for DISCO.'
      WRITE(LER,*)
     :'The user selects the type of statics computed by GLI3D.'
      WRITE(LER,*)
     :'The types include:'
      WRITE(LER,*)
     :	'total statics(long + short + elev)'
      WRITE(LER,*)
     :	'drift statics(long + short)'
      WRITE(LER,*)
     :	'long-period statics(long)'
      WRITE(LER,*)
     :	'short period statics(short)'
      WRITE(LER,*)
     :	 'elevation statics(from surface to datum using repl V)'
      WRITE(LER,*)
     :	 'remove elevation statics(-elev)'
      WRITE(LER,*)
      WRITE(LER,*)
     :'To run type "gli2disco" followed by command-line args'
      WRITE(LER,*)
     :'..............................................................'
      WRITE(LER,*)
      WRITE(LER,*)
     :'INPUT PARAMETERS and (DEFAULT VALUES)'
      WRITE(LER,*)
      WRITE(LER,*)
     :' -N [ntap]      (no default) : input gli3d report file (*.ele)'
        WRITE(LER,*)
     :' -O [otap]      (no default) : output file for disco'
        WRITE(LER,*)
     :' -C [corr ]     (default = drift) : type of static correction'
        WRITE(LER,*)
     :'    OPtions are  :  total  (long + short + elev)'
        WRITE(LER,*)
     :'    		:  drift  (long + short)'
        WRITE(LER,*)
     :'    		:  long   (long )'
        WRITE(LER,*)
     :'    		:  short  (short )'
        WRITE(LER,*)
     :'    		:  elev   (elev  )'
        WRITE(LER,*)
     :'    		:  elev_remove  (elev_remove)'
        WRITE(LER,*) 
     :' -S [type] (no default): Type -S if you want source corr.'
        WRITE(LER,*) 
     :' -R [type] (no default): Type -R if you want rcvr   corr.'
        WRITE(LER,*) 
     :' -B [big ] (default=no): Type -B if you have 3 or more layers'
        WRITE(LER,*) 
     :' -Q [batch] (default=no): Type -Q for old batch GLI3D input file'
      WRITE(LER,*)
     :' -iseed[iseed](default=-7777):Add this entry to the gli file',
     :'            to prevent any naturally occuring zeros'
      WRITE(LER,*)
     :' EXAMPLE'
      WRITE(LER,*)
     :' gli2disco -N/home/data/gli.ele -O/home/data/gli.dsk -S -Cdrift'
      WRITE(LER,*)
      WRITE(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(rfile,sfile,type,type1,corr,big,old,verbos,
     *			iseed)
c-----
c     get command arguments
c
c     rfile  - c*100     input file name
c     sfile  - c*100     output file name
c	corr - c*20	type of ststic correction
c	type - l	source or receiver
c     verbos - l   	VERBOSE output or not
c-----
#include <f77/iounit.h>
      character   rfile*(*),sfile*(*),corr*(*)
      logical     verbos,type,type1,old,big
      integer     argis
 
            call argstr( '-N', rfile, ' ', ' ' )
            call argstr( '-O', sfile, ' ', ' ' )
            verbos = (argis('-V') .gt. 0)
            type   = (argis('-S') .gt. 0)
            type1  = (argis('-R') .gt. 0)
            big    = (argis('-B') .gt. 0)
            old    = (argis('-Q') .gt. 0)
            call argi4('-iseed',iseed,-7777,-7777)
	    call argstr ('-C', corr,'drift','drift')
	return
	end
c
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  recsft,srcsft,ntap,otap,sfile,isb,irb)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     vel   - r*4  design velocity
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      integer * 4 nsamp, nsi, ntrc, nrec
      character ntap*(*), otap*(*), sfile*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace    =  ', nsamp
            write(LERR,*) ' sample interval       =  ', nsi
            write(LERR,*) ' traces per record     =  ', ntrc
            write(LERR,*) ' records per line      =  ', nrec
            write(LERR,*) ' format of data        =  ', iform
            write(LERR,*) 
            write(LERR,*) ' input data set name   =  ', ntap
            write(LERR,*) ' output data set name  =  ', otap
            write(LERR,*) ' input statics file    =  ', sfile
            write(LERR,*) ' Init. statics word    =  ', isb
            write(LERR,*) ' Recp. statics word    =  ', irb
            write(LERR,*) ' job static shift source   (ms) =  ', srcsft
            write(LERR,*) ' job static shift receiver (ms) =  ', recsft
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
		subroutine writedisco(lus,ns,nr,s,r,type,type1,corr)
c
c	write a file of station numbers and static corrections
c	for use in applying values to DISCO trace headers
c
c	Can apply total static, long period static, short period static,
c	drift static, elev correction, ....
c
 	integer s( 40000,22),r( 40000,19)
	character corr*(*)
	logical type,type1
	if (type ) then
		if (corr .eq. 'total' .or. corr .eq. 'TOTAL') then
			do 100 i = 1,ns
				itemp = s(i,16)
				write(lus,150) s(i,1),itemp
150				format('DATA    ',i8,i8)	
100			continue
		elseif (corr .eq. 'drift' .or. corr .eq. 'DRIFT') then
			do 110 i = 1,ns
				itemp = s(i,9 ) + s(i,15)
				write(lus,150) s(i,1),itemp
110			continue
		elseif (corr .eq. 'long' .or. corr .eq. 'LONG') then
			do 120 i = 1,ns
				itemp = s(i,9)
				write(lus,150) s(i,1),itemp
120			continue
		elseif (corr .eq. 'short' .or. corr .eq. 'SHORT') then
			do 130 i = 1,ns
				itemp = s(i,15)
				write(lus,150) s(i,1),itemp
130			continue
		elseif (corr .eq. 'elev' .or. corr .eq. 'ELEV') then
			do 140 i = 1,ns
				itemp = s(i,14)
				write(lus,150) s(i,1),itemp
140			continue
		elseif (corr .eq. 'elev_remove' 
     *			.or. corr .eq. 'ELEV_REMOVE') then
			do 160 i = 1,ns
				itemp = -s(i,14)
				write(lus,150) s(i,1),itemp
160			continue
		endif
	else
		if (corr .eq. 'total' .or. corr .eq. 'TOTAL') then
			do 200 i = 1,nr
				itemp = r(i,13)
				write(lus,150) r(i,1),itemp
200			continue
		elseif (corr .eq. 'drift' .or. corr .eq. 'DRIFT') then
			do 210 i = 1,nr
				itemp = r(i,7 ) + r(i,12)
				write(lus,150) r(i,1),itemp
210			continue
		elseif (corr .eq. 'long' .or. corr .eq. 'LONG') then
			do 220 i = 1,nr
				itemp = r(i,7)
				write(lus,150) r(i,1),itemp
220			continue
		elseif (corr .eq. 'short' .or. corr .eq. 'SHORT') then
			do 230 i = 1,nr
				itemp = r(i,12)
				write(lus,150) r(i,1),itemp
230			continue
		elseif (corr .eq. 'elev' .or. corr .eq. 'ELEV') then
			do 240 i = 1,nr
				itemp = r(i,11)
				write(lus,150) r(i,1),itemp
240			continue
		elseif (corr .eq. 'elev_remove' 
     *			.or. corr .eq. 'ELEV_REMOVE') then
			do 260 i = 1,nr
				itemp = -r(i,11)
				write(lus,150) r(i,1),itemp
260			continue
		endif
	endif
	return
	end
