C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c GLI2MXC  reads a gli3d file, extracts a near surface model, and
c          outputs an mxc file, and a velocity tape.
c
c
c**********************************************************************c
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer * 4 s(6000,22), r(6000,19)
#include <f77/pid.h>
      character   sfile * 100, rfile * 100, cgroup * 4 ,otap*100
      character   name*7
      logical     verbos,query,big,old,lay1,lay2,lay3,lay4,lay5
      logical     revers
      integer     argis, lhed (1500)
      real tri(SZSMPM)
      integer*2 itr (SZLNHD)
      equivalence ( itr(129), tri(1) )
      equivalence ( itr(  1), lhed(1))

      data lur / 30 /, name /'GLI2MXC' /
      data lus / 40 /

c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
c-----
c     open printout files
c-----
#include <f77/open.h>


      call gcmdln(otap,rfile,sfile,nstat0,nstat1,v0,
     :		dx,xmax,zmax,datum, nz, nzinc,big,nlayer,old,cgroup,
     :		lay1, lay2, lay3, lay4, lay5,revers,iseed)
	if ( nz .gt. zmax/nzinc ) nz = zmax/nzinc
c     get logical unit numbers for input and output
c-----
      call getln(luout, otap,'w', 1)

c-----
c     open gli3d file
c-----
	        open(unit=lur, file=rfile,form = 'formatted')
c-----
c     open disco file
c-----
	        open(unit=lus, file=sfile,form = 'formatted')
c-----
c     READ gli3d file
c-----
	if (old ) then
		if (big) then
      			call readgli1(lur,ns,nr, s, r , iseed)
		else
      			call readgli (lur,ns,nr, s, r , iseed)
		endif
	else
		if (big) then
      			call neadgli1(lur,ns,nr, s, r , iseed)
		else
      			call neadgli (lur,ns,nr, s, r , iseed)
		endif
	endif
c-----
c	write an mxc file
c-----
 		call writemxc(lus,nr,r,dx,nstat0,nstat1,
     :				xmax,zmax,datum,nlayer)
c-----
c	write a velocity tape
c-----
		call writevel(luout,otap,nr,r,dx,nstat0,nstat1,v0,
     :			xmax,zmax,datum,nz,nzinc,nlayer,cgroup,
     :			lay1, lay2, lay3, lay4, lay5, revers)
c**********************************************************************c
      end

C***********************************************************************
      subroutine help
#include <f77/iounit.h>
      WRITE(LER,*)
     :'***************************************************************'
      WRITE(LER,*)
     :'PROGRAM MODULE GLI2MXC   --  CONVERT GLI to MXC & VTAP format'
      WRITE(LER,*)
      WRITE(LER,*)
     :'Program GLI2MXC  writes an mxc file for the refraction solution'
      WRITE(LER,*)
     :'computed by GLI3D.  It also creates a VTAP'
      WRITE(LER,*)
      WRITE(LER,*)
     :'To run type "gli2mxc " followed by command-line args'
      WRITE(LER,*)
     :'..............................................................'
      WRITE(LER,*)
      WRITE(LER,*)
     :'INPUT PARAMETERS and (DEFAULT VALUES)'
      WRITE(LER,*)
      WRITE(LER,*)
     :' -N [rfile]     (no default) : input gli3d report file (*.ele)'
        WRITE(LER,*)
     :' -O [otap]      (default = vtap) : output file for VTAP '
        WRITE(LER,*)
     :' -M [sfile]     (default = mxc) : output file for mxc file '
        WRITE(LER,*)
     :' -B        (default = no ) : use if .ele file has > 2 layers'
        WRITE(LER,*)
     :' -R        (default = no ) : use to revers vtap display'
        WRITE(LER,*)
     :' -Q        (default = no ) : use for GLI3D batch file input'
        WRITE(LER,*)
     :' -1        (default = no ) : fill layer 1 with replacement vel'
        WRITE(LER,*)
     :' -2        (default = no ) : fill layer 2 with replacement vel'
        WRITE(LER,*)
     :' -3        (default = no ) : fill layer 3 with replacement vel'
        WRITE(LER,*)
     :' -4        (default = no ) : fill layer 4 with replacement vel'
        WRITE(LER,*)
     :' -5        (default = no ) : fill layer 5 with replacement vel'
        WRITE(LER,*)
     :' -nlay[nlayer]  (default = 2 ) : # layers in .ele file'
        WRITE(LER,*)
     :' -dx[dx]        (default = 20.0 ) : receiver station spacing'
        WRITE(LER,*)
     :' -dz[nzinc]     (default = 10.0 ) : depth increment for VTAP'
        WRITE(LER,*)
     :' -first[nstat0] (default = 1st station) : first station in model'
        WRITE(LER,*)
     :' -last[nstat1]  (default = last station) : last station in model'
        WRITE(LER,*)
     :' -xmax [xmax]   (default = 99999.) : length of model in x'
        WRITE(LER,*)
     :' -zmax [zmax]   (default = 99999.) : length of model in z'
        WRITE(LER,*)
     :' -datum [datum] (default = gli report): new datum elev'
        WRITE(LER,*)
     :' -nz    [nz]    (default =1000): number depth levels in VTAP'
        WRITE(LER,*)
     :' -v0    [v0]    (default =0): velocity between datum and topo'
        WRITE(LER,*)
     :' -iseed [iseed] (default =-7777):add to all values in .ele',
     :'			file to avoid having any zeros in file'
      WRITE(LER,*)
      WRITE(LER,*)
     :' EXAMPLE'
      WRITE(LER,*)
     :' gli2mxc  -N/home/data/gli.ele -O/home/data/gli.mxc -dx20'
      WRITE(LER,*)
     :' -first1000 -last2000 -zmax2000'
      WRITE(LER,*)
     :'***************************************************************'
      return
      end

C***********************************************************************
      subroutine gcmdln(otap,rfile,sfile,nstat0,nstat1,v0,dx,xmax,
     :			     zmax,datum,nz,nzinc,big,nlayer,old,cgroup,
     :		lay1, lay2, lay3, lay4, lay5, revers, iseed )
c-----
c     get command arguments
c
c     rfile  - c*100     input file name
c     sfile  - c*100     output file name for mxc
c     otap   - c*100     output file name for tape
c     nstat0 - i 	1st station on output model (corresponding to x = 0.)
c     nstat1 - i 	lst station on output model 
c	  dx - r	receiver station interval
c	xmax - r	length of model in x-direction.
c	zmax - r	length of model in z-direction.
c	datum- r	datum elevation (override)
c	  v0 - r	velocity from datum to topo.
c	  nz - i	number of depth values
c	nzinc- i	depth increment fo VTAP
c	big  - l	is the gli file 3 or more layers?
c-----
#include <f77/iounit.h>
      character   rfile*(*),sfile*(*),otap*(*),cgroup*4
      integer     argis
      logical     big, old, lay1, lay2, lay3, lay4, lay5, revers

            call argstr( '-N', rfile, ' ', ' ' )
            call argstr( '-O', otap , 'vtap', 'vtap' )
            call argstr( '-M', sfile, 'mxc', 'mxc' )
	    call argi4 ( '-first', nstat0, 0, 0)
	    call argi4 ( '-last', nstat1, 0, 0)
	    call argi4 ( '-nz', nz    ,1000,1000)
 	    call argr4 ( '-dx', dx , 25.0, 25.0 )
c    call argstr( '-dx',cgroup ,' ',' ')
c		read(cgroup,'(i4)') idx
c    	dx = idx
	    call argi4 ( '-dz', nzinc ,  10,  10)
	    call argi4 ( '-nlay', nlayer , 2 , 2 )
	    call argi4 ( '-iseed', iseed , -7777 , -7777 )
	    call argr4 ( '-xmax', xmax, 99999.0 , 99999.0 )
	    call argr4 ( '-zmax', zmax, 99999.0 , 99999.0 )
	    call argr4 ( '-datum', datum, 0.0, 0.0   )
	    call argr4 ( '-v0', v0, 0.0, 0.0 )
	    big    = (argis('-B') .gt. 0)
            revers = (argis('-R') .gt. 0)
	    lay1   = (argis('-1') .gt. 0)
	    lay2   = (argis('-2') .gt. 0)
	    lay3   = (argis('-3') .gt. 0)
	    lay4   = (argis('-4') .gt. 0)
	    lay5   = (argis('-5') .gt. 0)
	    if (nlayer .ge. 3 ) big = .true.
	    if (big) then
		if (nlayer .lt. 3 ) nlayer = 3
            endif	
	    old    = (argis('-Q') .gt. 0)
	return
	end
c
c
	subroutine writemxc(lus,nr,r,dx,nstat0,nstat1,
     :				xmax,zmax,datum,nlayer)
#include <f77/iounit.h>
	integer r(6000,19)
	dimension x(6000),z0(6000),z1(6000),z2(6000),d(6002)
	dimension z3(6000),z4(6000),z5(6000)
	dimension xx(6000)
c	dimension v1(1000),v2(1000)
	numlin = mod (nr+3,4)
	if (nstat0 .eq. 0) nstat0 = r(1,1)
	if (nstat1 .eq. 0) nstat1 = r(nr,1)
	xmin1 = 9999999.
	xmax1 = 0.00

	if ( dx .le. 0.0001) dx = abs (r(1,1) - r(2,1))
	i = 0
	do 100 j = 1, nr
		if (r(j,1) .ge. nstat0 .and. r(j,1) .le. nstat1) then
			i = i + 1
			x(i)     = (r(j,1) - nstat0 ) * dx
			if ( x(i) .lt. xmin1) xmin1 = x(i)
			if ( x(i) .gt. xmax1) xmax1 = x(i)
			if(datum .lt. 0.001) then
				z0(i) = r(j,9) - r(j,8)
			else
				z0(i) = datum  - r(j,8)
			endif
			if (z0(i) .lt. 0.0 ) z0(i) = 0.0
			if (z0(i) .gt. zmax) z0(i) = zmax
			z1(i)    = z0(i) + r(j,2)
			if (z1(i) .lt. 0.0 ) z1(i) = 0.0
			if (z1(i) .gt. zmax) z1(i) = zmax
			z2(i)    = z1(i) + r(j,4)
			if (z2(i) .lt. 0.0 ) z2(i) = 0.0
			if (z2(i) .gt. zmax) z2(i) = zmax
			z3(i)    = z2(i) + r(j,14)
			if (z3(i) .lt. 0.0 ) z3(i) = 0.0
			if (z3(i) .gt. zmax) z3(i) = zmax
			z4(i)    = z3(i) + r(j,16)
			if (z4(i) .lt. 0.0 ) z4(i) = 0.0
			if (z4(i) .gt. zmax) z4(i) = zmax
			z5(i)    = z4(i) + r(j,18)
			if (z5(i) .lt. 0.0 ) z5(i) = 0.0
			if (z5(i) .gt. zmax) z5(i) = zmax
		endif
100	continue
	numtrc = i
101	continue
c	set number of entries on mxc cards

	numlin = mod (numtrc+3,4)
	mumlin = mod (2*numtrc+1,4)
	nregion= nlayer + 2
c	Write 1st card of mxc file

 	write(lus,999) xmin1,xmax1,zmin,zmax,nregion
999	format(' HDR         0',4f10.2,'   ',i2,20x,'0')
	if (r(1,4) .eq. 0 .and. r(1,5) .eq. 0 ) nlayer = 1
c
c	draw top closed boundary starting with datum going clockwise

	xx(1) = 0.10
	d(1) = 0.0
	xx(2) = x(numtrc)
	d(2) = 0.0
	do 120 i = 1,numtrc
		j = numtrc -i + 1
           	xx(2+i) = x(j)
		d(2+i)    = z0(j)
120	continue
	xx(numtrc + 3) = xx(1)
	d(numtrc+3) = d(1)
   	write(lus,300) (xx(j), d(j), j = 1, 4)
   	do 200 j = 5, numtrc+3 - numlin, 4
		write(lus,300) (xx(i), d(i),i=j,j+3)
200	continue
	if(numlin .ne. 0) then
     	write(lus,300) (xx(i),  d(i),i=numtrc+3+1-numlin,numtrc+3)
	endif
	write(lus,*  ) '-1.0'
	if (nlayer .lt. 1) then
c
c	add bottom of model

		do 370 i = 1,numtrc
                  xx(i) = x(i)
                  d(i)  = z0(i)
370     	continue
		xx(numtrc+1) = xxmax
		d(numtrc+1)  = zmax
		xx(numtrc+2) = 0.10
		d(numtrc+2)  = zmax
		xx(numtrc+3) = 0.10
		d(numtrc+3)  = z0(1)
   		write(lus,300) (xx(j), d(j), j = 1, 4)
   		do 390 j = 5, numtrc+3 - numlin, 4
			write(lus,300) (xx(i), d(i),i=j,j+3)
390		continue
		if (numlin .ne. 0 ) then
      		write(lus,300)(xx(i),d(i),i=numtrc+3+1-numlin,numtrc+3)
		endif
		write(lus,*  ) '-1.0'
	return
	endif
c
c	draw 2nd closed boundary(topo + next horizon)

	do 140 i = 1,numtrc
		xx(i) = x(i)
		d(i)  = z0(i)
		xx(numtrc+i) = x(numtrc-i+1)
		d(numtrc+i)  = z1(numtrc-i+1)
140	continue
	xx(2*numtrc+1) = 0.10
	d( 2*numtrc+1) = z0(1)
249	write(lus,300) (xx(j), d(j), j = 1, 4)
   	do 250 j = 5, 2*numtrc+1 - mumlin, 4
		write(lus,300) (xx(i), d(i),i=j,j+3)
250	continue
	if (mumlin.ne.0) then
      	write(lus,300) (xx(i), d(i),i=2*numtrc+1-mumlin,2*numtrc+1)
	endif
	write(lus,*  ) '-1.0'
	if (nlayer .lt. 2) then
c
c	add bottom of model

		do 380 i = 1,numtrc
                  xx(i) = x(i)
                  d(i)  = z1(i)
380     	continue
		xx(numtrc+1) = xxmax
		d(numtrc+1)  = zmax
		xx(numtrc+2) = 0.10
		d(numtrc+2)  = zmax
		xx(numtrc+3) = 0.10
		d(numtrc+3)  = z1(1)
   		write(lus,300) (xx(j), d(j), j = 1, 4)
   		do 391 j = 5, numtrc+3 - numlin, 4
			write(lus,300) (xx(i), d(i),i=j,j+3)
391		continue
		if (numlin .ne. 0 ) then
      		write(lus,300)(xx(i),d(i),i=numtrc+3+1-numlin,numtrc+3)
		endif
		write(lus,*  ) '-1.0'
	return
	endif
c
c	draw 3rd closed boundary

	do 145 i = 1,numtrc
		xx(i) = x(i)
		d(i)  = z1(i)
		xx(numtrc+i) = x(numtrc-i+1)
		d(numtrc+i)  = z2(numtrc-i+1)
145	continue
	xx(2*numtrc+1) = 0.10
	d( 2*numtrc+1) = z1(1)
   	write(lus,300) (xx(j), d(j), j = 1, 4)
   	do 270 j = 5, 2*numtrc+1 - mumlin, 4
		write(lus,300) (xx(i), d(i),i=j,j+3)
270	continue
	if(mumlin.ne.0) then
 	write(lus,300) (xx(i), d(i),i=2*numtrc+1-mumlin,2*numtrc+1)
	endif
	write(lus,*  ) '-1.0'
	if (nlayer .lt. 3) then
c
c	add bottom of model

		do 382 i = 1,numtrc
                  xx(i) = x(i)
                  d(i)  = z2(i)
382     	continue
		xx(numtrc+1) = xxmax
		d(numtrc+1)  = zmax
		xx(numtrc+2) = 0.10
		d(numtrc+2)  = zmax
		xx(numtrc+3) = 0.10
		d(numtrc+3)  = z2(1)
   		write(lus,300) (xx(j), d(j), j = 1, 4)
   		do 392 j = 5, numtrc+3 - numlin, 4
			write(lus,300) (xx(i), d(i),i=j,j+3)
392		continue
		if (numlin .ne. 0 ) then
      		write(lus,300)(xx(i),d(i),i=numtrc+3+1-numlin,numtrc+3)
		endif
		write(lus,*  ) '-1.0'
		return
	endif
c
c	draw 4th closed boundary

	do 150 i = 1,numtrc
		xx(i) = x(i)
		d(i)  = z2(i)
		xx(numtrc+i) = x(numtrc-i+1)
		d(numtrc+i)  = z3(numtrc-i+1)
150	continue
	xx(2*numtrc+1) = 0.10
	d( 2*numtrc+1) = z2(1)
   	write(lus,300) (xx(j), d(j), j = 1, 4)
   	do 280 j = 5, 2*numtrc+1 - mumlin, 4
		write(lus,300) (xx(i), d(i),i=j,j+3)
280	continue
	if(mumlin.ne.0) then
 	write(lus,300) (xx(i), d(i),i=2*numtrc+1-mumlin,2*numtrc+1)
	endif
	write(lus,*  ) '-1.0'
	if (nlayer .lt. 4) then
c
c	add bottom of model

		do 383 i = 1,numtrc
                  xx(i) = x(i)
                  d(i)  = z3(i)
383     	continue
		xx(numtrc+1) = xxmax
		d(numtrc+1)  = zmax
		xx(numtrc+2) = 0.10
		d(numtrc+2)  = zmax
		xx(numtrc+3) = 0.10
		d(numtrc+3)  = z3(1)
   		write(lus,300) (xx(j), d(j), j = 1, 4)
   		do 393 j = 5, numtrc+3 - numlin, 4
			write(lus,300) (xx(i), d(i),i=j,j+3)
393		continue
		if (numlin .ne. 0 ) then
      		write(lus,300)(xx(i),d(i),i=numtrc+3+1-numlin,numtrc+3)
		endif
		write(lus,*  ) '-1.0'
		return
	endif
c
c	draw 5th closed boundary

	do 160 i = 1,numtrc
		xx(i) = x(i)
		d(i)  = z3(i)
		xx(numtrc+i) = x(numtrc-i+1)
		d(numtrc+i)  = z4(numtrc-i+1)
160	continue
	xx(2*numtrc+1) = 0.10
	d( 2*numtrc+1) = z3(1)
   	write(lus,300) (xx(j), d(j), j = 1, 4)
   	do 290 j = 5, 2*numtrc+1 - mumlin, 4
		write(lus,300) (xx(i), d(i),i=j,j+3)
290	continue
	if(mumlin.ne.0) then
 	write(lus,300) (xx(i), d(i),i=2*numtrc+1-mumlin,2*numtrc+1)
	endif
	write(lus,*  ) '-1.0'
	if (nlayer .lt. 5) then
c
c	add bottom of model

		do 384 i = 1,numtrc
                  xx(i) = x(i)
                  d(i)  = z4(i)
384     	continue
		xx(numtrc+1) = xxmax
		d(numtrc+1)  = zmax
		xx(numtrc+2) = 0.10
		d(numtrc+2)  = zmax
		xx(numtrc+3) = 0.10
		d(numtrc+3)  = z4(1)
   		write(lus,300) (xx(j), d(j), j = 1, 4)
   		do 394 j = 5, numtrc+3 - numlin, 4
			write(lus,300) (xx(i), d(i),i=j,j+3)
394		continue
		if (numlin .ne. 0 ) then
      		write(lus,300)(xx(i),d(i),i=numtrc+3+1-numlin,numtrc+3)
		endif
		write(lus,*  ) '-1.0'
		return
	endif
c
c	draw 6th closed boundary

	do 165 i = 1,numtrc
		xx(i) = x(i)
		d(i)  = z4(i)
		xx(numtrc+i) = x(numtrc-i+1)
		d(numtrc+i)  = z5(numtrc-i+1)
165	continue
	xx(2*numtrc+1) = 0.10
	d( 2*numtrc+1) = z4(1)
   	write(lus,300) (xx(j), d(j), j = 1, 4)
   	do 295 j = 5, 2*numtrc+1 - mumlin, 4
		write(lus,300) (xx(i), d(i),i=j,j+3)
295	continue
	if(mumlin.ne.0) then
 	write(lus,300) (xx(i), d(i),i=2*numtrc+1-mumlin,2*numtrc+1)
	endif
	write(lus,*  ) '-1.0'
	if (nlayer .lt. 6) then
c
c	add bottom of model

		do 385 i = 1,numtrc
                  xx(i) = x(i)
                  d(i)  = z5(i)
385     	continue
		xx(numtrc+1) = xxmax
		d(numtrc+1)  = zmax
		xx(numtrc+2) = 0.10
		d(numtrc+2)  = zmax
		xx(numtrc+3) = 0.10
		d(numtrc+3)  = z5(1)
   		write(lus,300) (xx(j), d(j), j = 1, 4)
   		do 395 j = 5, numtrc+3 - numlin, 4
			write(lus,300) (xx(i), d(i),i=j,j+3)
395		continue
		if (numlin .ne. 0 ) then
      		write(lus,300)(xx(i),d(i),i=numtrc+3+1-numlin,numtrc+3)
		endif
		write(lus,*  ) '-1.0'
		return
	endif
300	format(f8.1, 7F10.2)
	return
	end

	subroutine writevel(lus,otap,nr,r,dx,nstat0,nstat1,v0,
     :			xmax,zmax,datum,nz,nzinc,nlayer,cgroup,
     :			lay1, lay2, lay3, lay4, lay5, revers)
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
	integer r(6000,19)
#include <f77/pid.h>
	dimension x(6000),z0(6000),z1(6000),z2(6000)
	dimension z3(6000),z4(6000),z5(6000)
 	dimension v1(6000),v2(6000),v3(6000),dummy(20000)
 	dimension v4(6000),v5(6000),v6(6000)
 	dimension vv(6000)
      integer      lhed (1500)
      real tri(SZSMPM)
      integer*2 itr (SZLNHD)
	logical lay1,lay2,lay3,lay4,lay5, revers       
      character otap*(*),name*7,cgroup*4
      equivalence ( itr(129), tri(1) )
      equivalence ( itr(  1), lhed(1))
      data name /'GLI2MXC'/
      lzmax = zmax + 1
	if (nstat0 .eq. 0) nstat0 = r(1,1)
	if (nstat1 .eq. 0) nstat1 = r(nr,1)
	if ( dx .le. 0.0001) dx = abs (r(1,1) - r(2,1))
	i = 0
	do 100 j = 1, nr
		if (r(j,1) .ge. nstat0 .and. r(j,1) .le. nstat1) then
			i = i + 1
c	write(LERR,*)'i=',i,'nstat0',nstat0,'nstat1',nstat1,'r',r(j,1)
			vv(i) = v0
			x(i) = (r(j,1) - nstat0 ) * dx
			if(datum .lt. 0.001) then
				z0(i) = r(j,9) - r(j,8)
			else
				z0(i) = datum  - r(j,8)
			endif
			if (z0(i) .lt. 0.0 ) z0(i) = 0.0
			if (z0(i) .gt. zmax) z0(i) = zmax
			z1(i) = z0(i) + r(j,2)
 			v1(i)	 = r(j,3)
			if (z1(i) .lt. 0.0 ) z1(i) = 0.0
			if (z1(i) .gt. zmax) z1(i) = zmax
			z2(i) = z1(i) + r(j,4)
 			v2(i)	 = r(j,5)
			if (z2(i) .lt. 0.0 ) z2(i) = 0.0
			if (z2(i) .gt. zmax) z2(i) = zmax
			z3(i)    = z2(i) + r(j,14)
 			v3(i)	 = r(j,15)
			if (z3(i) .lt. 0.0 ) z3(i) = 0.0
			if (z3(i) .gt. zmax) z3(i) = zmax
			z4(i)    = z3(i) + r(j,16)
 			v4(i)	 = r(j,17)
			if (z4(i) .lt. 0.0 ) z4(i) = 0.0
			if (z4(i) .gt. zmax) z4(i) = zmax
			z5(i)    = z4(i) + r(j,18)
 			v5(i)	 = r(j,19)
			if (z5(i) .lt. 0.0 ) z5(i) = 0.0
			if (z5(i) .gt. zmax) z5(i) = zmax
 	 		v6(i) = r(j,6)
		endif
100	continue
	numtrc=i
c	write(LERR,*)'numtrc',numtrc
c
c	create & write Line header
	idz = nzinc*1000
	idx = dx*1000
	call savew(itr, 'NumSmp', nz   , LINHED)
        call savew(itr, 'SmpInt', nzinc, LINHED)
 	call savew(itr, 'NumTrc', numtrc, LINHED)
	call savew(itr, 'NumRec', 1    , LINHED)
	call savew(itr, 'Format', 3    , LINHED)
	call savew(itr, 'TmMsSl', idx  , LINHED)
	call savew(itr, 'TmSlIn', idz  , LINHED)
	jdx = dx
          lbytes = HSTOFF
	  nbyt = 2 * SZHFWD
        call savew( itr, 'HlhEnt',  0   , LINHED)
        call savew( itr, 'HlhByt', nbyt , LINHED)
c	call savew(itr, 'GrpInt', cgroup   , LINHED)
 	call savhlh(itr,lbytes,lbyout)
	call wrtape(lus  , itr, lbyout )


c
c	write velocity traces with headers

C***********************************************************************
        if ( revers) then
                jj1 = numtrc
                jj2 = 1
                jj3 = -1
        else
                jj1 = 1
                jj2 = numtrc
                jj3 = 1
        endif
        do 300 i = jj1, jj2, jj3
		vrepl = r(i,10)
	   ll = z0(i)
	   mm = z1(i)
	   nn = z2(i)
	   ii = z3(i)
	   jj = z4(i)
	   kk = z5(i)
	   call vfill (vv(i),dummy(1),1,lzmax)
	if (nlayer .ge. 1)call vfill (v1(i),dummy(ll+1),1,lzmax-ll)
	if (lay1) call vfill (vrepl,dummy(ll+1),1,lzmax-ll)
	if(nlayer .ge. 2) call vfill (v2(i),dummy(mm+1),1,lzmax-mm)
	if (lay2) call vfill (vrepl,dummy(mm+1),1,lzmax-mm)
	if(nlayer .ge. 3) call vfill (v3(i),dummy(nn+1),1,lzmax-nn)
        if (lay3)call vfill (vrepl,dummy(nn+1),1,lzmax-nn)
	if(nlayer .ge. 4) call vfill (v4(i),dummy(ii+1),1,lzmax-ii)
	if (lay4) call vfill (vrepl,dummy(ii+1),1,lzmax-ii)
	if(nlayer .ge. 5) call vfill (v5(i),dummy(jj+1),1,lzmax-jj)
	if (lay5) call vfill (vrepl,dummy(jj+1),1,lzmax-jj)
        call vfill (v6(i),dummy(kk+1),1,lzmax-kk)
		call savew(itr, 'TrcNum', i, TRCHED)
		call savew(itr, 'RecNum', 1, TRCHED)
		do 350 j = 1, nz
			ijk = 1  + (j-1)*nzinc
			if (ii .gt. lzmax) ijk = lzmax
			tri(j ) = dummy(ijk)
350		continue
		tri(nz) = tri(nz)
		call wrtape( lus  , itr, SZTRHD + nz * SZSMPD)
300	 continue
	call lbclos(lus)
	return
	end
