C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c examines each record using histograms, then edits each trace based
c on user given # end bins to trim, and
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD ), ikill( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne, ist, iend
      integer     idd,  nbin
 
c------
c  static memory allocation
      real        histt ( SZLNHD ), histr ( SZLNHD )

c------
c  dynamic memory allocation for big arrays, eg whole records
      integer     itrhd
      pointer     (wkitrhd, itrhd(1))
      real        record
      pointer     (wkadr , record(1))
c------
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     recnum, trcnum, static
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      real        tri ( SZLNHD )
      character   ntap * 256, otap * 256, name*8
      logical     verbos, query, heap, trace, fix
      logical     left, right
      integer     argis
 
c-----
c    we acces the floating point data through an equivalence statement
c    that starts the reals at 1/2-word 129
c-----
c     equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'GLITCHES'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,ns,ne,irs,ire, ist, iend,kbin,
     1             nbin, idd,  verbos,trace, fix,left,right)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'GLITCHES: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain parameters
 
c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
 
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 8, LERR)
 
c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records).  This guards against
c     zero start values or values that are greater than those specified
c     in the line header
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

      ist  = ist / nsi
      iend = iend / nsi
      if (ist .le. 1) ist = 1
      if (iend .le. 1) iend = nsamp
      if (iend .gt. 4096) iend = 4096
      nsampo = iend - ist + 1
      if (nsampo .le. nbin) then
         write(LERR,*)'glitches:  OOPS!'
         write(LERR,*)'Number of histogram bins (',nbin,') exceeds'
         write(LERR,*)'the number of samples in window (',nsampo,')'
         write(LERR,*)'Either decrease # bins or increase # samps'
         write(LER ,*)'glitches:  OOPS!'
         write(LER ,*)'Number of histogram bins (',nbin,') exceeds'
         write(LER ,*)'the number of samples in window (',nsampo,')'
         write(LER ,*)'Either decrease # bins or increase # samps'
         stop
      endif
 
c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.
 
c--------------------------
c  note: these don't
c  have to be the same size
 
      jtr  = ne -ns + 1
      item  = jtr * nsamp  * SZSMPD
      itemi = jtr * ITRWRD * SZSMPD
 
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 1  (allocation succeeded)
c     errcod = 0  (allocation failed)
c--------
 
      call galloc (wkadr, item, errcd, abort)
      if (errcd .ne. 0.) heap = .false.

      call galloc (wkitrhd, itemi, errcd, abort)
      if (errcd .ne. 0.) heap = .false.
 
      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item,'  bytes'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item,'  bytes'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
 
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout                 )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  nbin,idd,ntap,otap,trace,fix,ist,iend,
     2                  ns,ne,irs,ire)
      end if

c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
c-----
c     skip unwanted records
c-----
      nbytes = obytes
      call recrw(1,irs-1,luin,ntrc,itr,luout, nbytes)
      if (nbytes  .eq. 0) go to 999
 
c-----
c     process desired trace records
c-----
      do 1000 jj = irs, ire
 
            call vclr (record, 1, jtr*nsamp)
            call vclr (ikill, 1, ntrc)

c----------------------
c  skip to start trace
            nbytes = obytes
            call trcrw (jj,1,ns-1,luin,ntrc,itr,luout, nbytes)
             if (nbytes  .eq. 0) go to 999
c----------------------
 
            ic = 0
            do 1001  kk = ns, ne
 
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)
 
                  call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        static , TRACEHEADER)


                  if (static .eq. 30000) then
                     call vclr (tri,1,nsamp)
                  endif
 
c----------------------
c  pack data into array
                  ic = ic + 1
                  istrc = (ic-1) * nsamp
                  ishdr = (ic-1) * ITRWRD
                  call vmov (tri,1, record(istrc+1),1,nsamp)
                  call vmov (lhed,1, itrhd(ishdr+1),1,ITRWRD)
 
1001        continue
 
c-----------------------
c  here's the meat...
 
                     if (.not. trace)
     1               call maxmgv (record, 1, recmax, imax, ic*nsamp)

                     call subs   (JJ,ic, nsamp, idd,  record, kbin,
     1                            nbin, histt, histr, recmax,trace,
     2                            ist, iend, fix, verbos, ikill,
     3                            left, right)
 
c-----------------------
 
c---------------------
c  extract traces from
c  output array and
c  write output data
            do 1002 kk = 1, ic
 
                  istrc = (kk-1) * nsamp
                  ishdr = (kk-1) * ITRWRD
                  call vmov (record(istrc+1),1,lhed(ITHWP1),1, nsamp)
                  call vmov (itrhd (ishdr+1),1,lhed,1,ITRWRD)
                  if (ikill(kk) .eq. 30000)
     1            call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     2                        30000  , TRACEHEADER)
                  call wrtape (luout, itr, obytes)
 
 
 1002             continue

c----------------------
c  pass remainder of rec
            nbytes = obytes
            call trcrw (JJ,ne+1,ntrc,luin,ntrc,itr, luout, nbytes)
c----------------------
 
 
                  if(verbos)write(LERR,*)'ri ',recnum,' processed'
 
 1000       continue

c------------------------
c  pass remainder of recs
      nbytes = obytes
      call recrw (ire+1, nrec, luin, ntrc, itr, luout, nbytes)
      if (nbytes .eq. 0) go to 999
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
            write(LERR,*)'end of glitches, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'glitches does dark and terrible things to seismic data:'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute by typing glitches and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)         : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)         : output data file name'
        write(LER,*)
     :' -ps[ns]      (default = 0ms)      : start process time(ms)'
        write(LER,*)
     :' -ps[ns]      (default = last samp): end process time(ms)'
        write(LER,*)
     :' -ns[ns]      (default = first)    : start process trace number'
        write(LER,*)
     :' -ne[ne]      (default = last)     : end process trace number'
        write(LER,*)
     :' -rs[irs]     (default = first)    : start process record number'
        write(LER,*)
     :' -re[ire]     (default = last)     : end process record number'
        write(LER,*) ' '
        write(LER,*)
     :' -bn[nbin]  (default = 100)  :  # bins in histogram'
        write(LER,*)
     :' -kb[kbin]  (default = 1)    :  # end bins to kill'
        write(LER,*)
     :' -pd[idd]   (default = 10)   :  threshold % dead samps trc kill'
        write(LER,*) ' '
        write(LER,*)
     :' -L  trim only left (negative) last bin, or'
        write(LER,*)
     :' -R  trim only right (positive) last bin, or'
        write(LER,*)
     :'     (default) trim left and right (neg & pos) bins'
        write(LER,*)
     :' -F  include on command line to fix up killed samples'
        write(LER,*)
     :' -T  include on command line if trace constant processing'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   glitches -N[] -O[] -ps[] -pe[] -ns[] -ne[] -rs[] '
        write(LER,*)
     :'                  -re[] -bn[] -kb[] -pd[] [-L -R -F -T -V]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,ist, iend,kbin,
     1                  nbin, idd, verbos,trace,fix,left,right)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     nbin  - I*4      # bins
c     idd   - I*4      theshold % tot samps to kill trace
c     ist   - I*4      start processing time
c     iend  - I*4      end processing time
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     fix     L        attempt to fix up killed samples
c     trace   L        histogram trace-by-trace; else full record
c     verbos  L        verbose output or not
c-----
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      character   ntap*(*), otap*(*)
      integer     ns, ne, irs, ire, ist, iend
      integer     nbin, idd 
      logical     verbos, trace, fix, left, right
      integer     argis
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program glitches might be invoked in the following way:
 
c     glitches  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into glitches and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ps', ist ,   1  ,  1    )
            call argi4 ( '-pe', iend,   0  ,  0    )
            call argi4 ( '-ns', ns ,   1  ,  1    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   1  ,  1    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-bn', nbin , 100, 100)
            call argi4 ( '-kb', kbin , 1  , 1  )
            call argi4 ( '-pd', idd  , 10 , 10 )

            fix    =   (argis('-F') .gt. 0)
            left   =   (argis('-L') .gt. 0)
            right  =   (argis('-R') .gt. 0)
            trace  =   (argis('-T') .gt. 0)
            verbos =   (argis('-V') .gt. 0)
 
            if (.not.left .AND. .not.right) then
                left  = .true.
                right = .true.
            endif
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't

            if (nbin .ge. SZLNHD) then
               write(LERR,*)'FATAL ERROR:'
               write(LERR,*)'Number bins exceeds maximum trc length= ',
     1                       SZLNHD
               write(LERR,*)'Reduce -bn[] # bins & rerun'
               stop
            endif
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  nbin,idd,ntap,otap,trace,fix,ist,iend,
     2                  ns,ne,irs,ire)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     idd   - I*4     theshold % tot samps to kill trace
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, idd,nbin
      integer     ist,iend,ns,ne,irs,ire
      character   ntap*(*), otap*(*)
      logical     trace,fix
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' # bins             =  ',  nbin
            write(LERR,*) ' treshold % dead samples to kill trace= ',
     1                     idd
            write(LERR,*) ' Start processing sample =  ', ist
            write(LERR,*) ' End processing sample   =  ', iend
            write(LERR,*) ' Start processing trace  =  ', ns
            write(LERR,*) ' End processing trace    =  ', ne
            write(LERR,*) ' Start processing record =  ', irs
            write(LERR,*) ' End processing record   =  ', ire
            if (fix) then
            write(LERR,*) ' Will attempt to fix killed samples'
            else
            write(LERR,*) ' Glitches will be zeroed'
            endif
            if (trace) then
            write(LERR,*) ' Trace-by-trace histogram discrimination'
            else
            write(LERR,*) ' Record histogram discrimination'
            endif
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 
