C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c routine to feed up all traces required to grid reduce a single
c output grid node.  Traces must fall within the radius of investigation
c of the current node.  Only do the square root calculation for traces
c that fall in the current grid bin to speed things up.  Also determine the
c angle associated with the offset vector so as not to have to do this for
c every sample later.  This will also speed things up.  In addition keep
c track of the next_X_index so we don't have to search from the begining
c with each increase in X output bin dimension.

      subroutine GetData(  
c x,y coordinates of required output trace 
     :     X, Y,
c X and Y limits reached by grid operator
     :     Grid_lowX, Grid_highX, Grid_lowY, Grid_highY,
c input data geometry information
     :     Xcoords, Ycoords, Records, Traces, index,
c list of input data falling within grid operator
     :     Xlist, Ylist, RecList, TrcList, NumTraces,
c input data from above list
     :     ist, iend, itr, ifmt_StaCor, l_StaCor, ln_Stacor,
     :     luin, nsamp, ntrc, Data, Headers,
c radius limiting and angle calculation
     :     Limit_radius, Limit_nsegs, Radii, Angles, pi,
c search efficiency variables
     :     next_X, next_X_index, next_X_Search_Flag,
     :     current_X_index )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c declare variables passed from calling routine

      integer index, Records(index), Traces(index)
      integer NumTraces, RecList(index), TrcList(index)
      integer ist, iend, nsamp, ntrc, luin, itr(SZLNHD)
      integer ifmt_StaCor, l_StaCor, ln_Stacor
      integer Headers(ITRWRD,ntrc), next_X_index
      integer current_X_index

      real X, Y, Grid_lowX, Grid_highX, Grid_lowY, Grid_highY
      real Xcoords(index), Ycoords(index), Xlist(index), Ylist(index)
      real Data(nsamp, ntrc)
      real Limit_radius, Limit_nsegs, Radii(index), Angles(index)
      real pi, DeltaAngle
      real next_X

      logical next_X_Search_Flag

c declare local variables

      integer  ioff, nbytes, counter

      real Rise, Run, Radius, Angle

c initialize variables

      NumTraces = 0
      DeltaAngle = (2. * pi)/Limit_nsegs
      call vclr ( Radii, 1, index )
      call vclr ( Angles, 1, index )

c set the counter to the current search position in the arrays.
c the arrays are sorted in increasing X.  THe initial value
c of next_X_index is 1 but it will increment as the program
c executes to prevent a lot of uncessesary searching from
c going on

      if ( next_X_Search_Flag ) then
         counter = next_X_index
         current_X_index = next_X_index
      else
         counter = current_X_index
      endif 
      

c go through memory file and retrieve only data falling inside
c grid operator
c check x first as the coords table is ordered in x at this point.
c but don't read off the end

      DO WHILE ( Xcoords(counter) .le. Grid_highX .and. 
     :     counter .le. index )

c now look through all y's for x's .ge. xmin

         if ( Xcoords(counter) .ge. Grid_lowX .and. 
     :        Ycoords(counter) .le. Grid_highY .and.
     :        Ycoords(counter) .ge. Grid_lowY ) then

c determine the index of the x coordinate needed for the next 
c call to this subroutine.  This will prevent us from having to
c search the entire coordinate array for every grid node.

            if ( next_X_Search_Flag ) then
               if ( Xcoords(counter) .ge. next_X ) then
                  next_X_index = counter
                  next_X_Search_Flag = .false.
               endif
            endif

c determine if this point falls inside the radius of
c investigation of is off in a corner.  Only accept
c traces falling inside radius of investigation.

            Run = Xcoords(counter) - X
            Rise = Ycoords(counter) - Y
            Radius = sqrt ( Run**2 + Rise**2)

            if ( Radius .le. Limit_radius ) then

               NumTraces = NumTraces + 1

c policeman

               if ( NumTraces .gt. ( 4 * ntrc ) ) then

                  write(LERR,*)' '
                  write(LERR,*)' Not enough memory allocated'
                  write(LERR,*)' for this radius.  Reduce '
                  write(LERR,*)' radius or call Garossino'
                  write(LERR,*)' at Socon 422-3932'
                  write(LERR,*)' '
                  write(LER,*)' '
                  write(LER,*)'GRIDR: '
                  write(LER,*)' Not enough memory allocated'
                  write(LER,*)' for this radius.  Reduce '
                  write(LER,*)' radius or call Garossino'
                  write(LER,*)' at Socon 422-3932'
                  write(LER,*)'FATAL '
                  stop
               endif

c calculate direction of radius vector

               if ( Rise .ge. 0.0 .and. Run .ge. 0.0 ) then
c Upper Right Hand Quadrant
                  Angles(NumTraces) = atan2(abs(Run),abs(Rise))
               elseif ( Rise .lt. 0.0 .and. Run .ge. 0.0 ) then
c Lower Right Hand Quadrant
                  Angle = atan2(abs(Rise),abs(Run))
                  Angles(NumTraces) = ( pi / 2.0 ) + Angle
               elseif ( Rise .lt. 0.0 .and. Run .le. 0.0 ) then
c Lower Left Hand Quadrant
                  Angle = atan2(abs(Run),abs(Rise))
                  Angles(NumTraces) =  pi  + Angle
               elseif ( Rise .ge. 0.0 .and. Run .le. 0.0 ) then
c Upper Left Hand Quadrant
                  Angle = atan2(abs(Rise),abs(Run))
                  Angles(NumTraces) = ( 3. * pi / 2.0 ) + Angle
               endif

               Xlist(NumTraces) = Xcoords(counter)
               Ylist(NumTraces) = Ycoords(counter)
               RecList(NumTraces) = Records(counter)
               TrcList(NumTraces) = Traces(counter)
               Radii(NumTraces) = Radius

c pick off input data

               ioff = (Records(counter)-1)*ntrc + Traces(counter)
               call sisseek(luin, ioff)
               call rtape(luin, itr, nbytes)

c shouldn't need to check to see if there is data as we have already got
c that info from the headerscan

               call vmov ( itr(ITHWP1 + ist - 1), 1, 
     :              Data(1,NumTraces), 1, nsamp ) 
               call vmov ( itr, 1, Headers(1,NumTraces), 1, ITRWRD )
            endif

         endif
         counter = counter + 1
      ENDDO

      return
      end

      
