C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GridHeader ( 
c x,y coordinates of required output trace
     :     X, Y, pi,
c list of input data within limits of grid operator
     :     Xlist, Ylist, RecList, TrcList, NumTraces,
c vector position information for traces
     :     Radii, Angles,
c input data and workspace
     :     ntrc, Headers, Headers_WorkSpace, 
     :     ifmt_wrd, l_wrd, ln_wrd,
c grid reduction limits
     :     Limit_nsegs, Limit_NumAdjZeroSegs, 
     :     Limit_MinNumElems, Limit_Amp, 
     :     Limit_radius, Limit_weighting, 
c output grid reduced data at this location
     :     itr, verbos) 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c declare variable passed from calling routine

      integer NumTraces, RecList(NumTraces), TrcList(NumTraces)
      integer ntrc
      integer itr(SZLNHD), Headers(ITRWRD,ntrc)
      integer Headers_WorkSpace(ITRWRD,ntrc)
      integer ifmt_wrd, l_wrd, ln_wrd, wrd

      real X, Y, Xlist(NumTraces), Ylist(NumTraces)
      real Radii(NumTraces), Angles(NumTraces)
      real pi
      real Limit_nsegs, Limit_NumAdjZeroSegs, Limit_Amp
      real Limit_MinNumElems, Limit_radius

      character Limit_weighting*10

      logical verbos

c declare local variables

      integer segment, sample, test, NumAdjZeroSegs(SZLNHD)
      integer Header_value

      real DeltaAngle, NumElemsPerSeg(SZLNHD)  
      real TotalElemsAtNode(SZLNHD)
      real Normalization_Weights(SZLNHD)
      real TaperValue

c initialize variables

      DeltaAngle = (2. * pi)/Limit_nsegs
      call vclr(Normalization_Weights,1,SZLNHD)
      call vclr(TotalElemsAtNode,1,SZLNHD)

c SAMPLE LOOP .... perform grid reduction process at every header sample requested
c ----------       which for now is a single sample

      DO sample = 1, 1

         wrd = 0
         call savew2 ( itr, ifmt_wrd, l_wrd, ln_wrd, wrd, TRACEHEADER )

c reset gridding limits and angle variables

         NumAdjZeroSegs(sample) = 0
         Normalization_Weights(sample) = 0.0
         TotalElemsAtNode(sample) = 0.0
         AngleEnd = 0.0
         AngleStart = 0.0

c SEGMENT LOOP ..... following calculations done within a segment 
c ------------

         DO segment = 1, Limit_nsegs

            NumElemsPerSeg(segment) = 0.0

c work clockwise around grid operator from North 
c to North again ALL ANGLES ARE MEASURED IN RADIANS

            AngleStart = AngleEnd
            AngleEnd = AngleStart + DeltaAngle

c TRACE LOOP ..... examine all traces supplied to find if they fit into
c ---------        this segment

            DO test = 1, NumTraces

c Examine all input traces [provided by the GetData() subroutine]
c note: getdata only passes traces falling within the current radius
c       of investigation and has tabulated distance and angle information
c       in Radii[] and Angles[]

c test if point is inside segment

               if ( Angles(test) .ge. AngleStart .and. 
     :              Angles(test) .lt. AngleEnd ) then

c weight sample accoring to distance from grid node  

                  if ( Limit_weighting .eq. 'linear' ) then
                     TaperValue = ( 1.0 - Radii(test) / Limit_radius )
                  elseif ( Limit_weighting .eq. 'cosine' ) then
                     call CosTaper (Radii(test), 0.0, Limit_radius, 
     :                    TaperValue, pi, 1 )
                  endif

c accumulate data for this segment

                  call saver2 (Headers(1, test), ifmt_wrd, l_wrd, 
     :                 ln_wrd, Header_value, TRACEHEADER) 

                  Headers_WorkSpace(sample, segment) =  
     :                 Headers_WorkSpace(sample, segment) + 
     :                 nint ( float(Header_value) * 
     :                 TaperValue )

c fill out grid limit arrays for elements per segment and normalization
c arrays only if data point being operated on is non-zero

                  if ( iabs( Header_value ) .gt. 0 ) then 
                     NumElemsPerSeg(segment) =
     :                    NumElemsPerSeg(segment) + 1. 
                     Normalization_Weights(sample) = 
     :                    Normalization_Weights(sample) + 
     :                    ( 1. - Radii(test) / Limit_radius )
                  endif
               endif

            ENDDO

c fill our grid limit array for total elements at a node

            TotalElemsAtNode(sample) = TotalElemsAtNode(sample) + 
     :           NumElemsPerSeg(segment)

c fill out grid limit array for number of adjacent zero segments at node

            if (segment .gt. 1 ) then
               if ( NumElemsPerSeg(segment) .lt. 1.e-30 ) then
                  if ( NumElemsPerSeg(segment-1) .lt. 1.e-30 ) then
                     NumAdjZeroSegs(sample) = NumAdjZeroSegs(sample) +1
                  else
                     NumAdjZeroSegs(sample) = 0
                  endif
               else
                  NumAdjZeroSegs(sample) = 0
               endif
            endif

c assign output sample value for this node
            
            wrd = wrd + Headers_WorkSpace(sample,segment)
            Headers_WorkSpace(sample,segment) = 0

         ENDDO

c adjacent zero segment test

         if ( NumAdjZeroSegs(sample) .gt. nint(Limit_NumAdjZeroSegs) ) 
     :        then
            call savew2 ( itr, ifmt_wrd, l_wrd, ln_wrd, 0, TRACEHEADER )
         endif

c number of elements test

         if ( TotalElemsAtNode(sample) .le. Limit_MinNumElems) 
     :        then
            call savew2 ( itr, ifmt_wrd, l_wrd, ln_wrd, 0, TRACEHEADER )
         endif

c normalization of live data only

         if ( Normalization_Weights(sample) .gt. 0.0 .and.
     :        iabs( wrd ) .gt. 0 ) then
            wrd = nint(float(wrd) / Normalization_Weights(sample) )
            call savew2 ( itr, ifmt_wrd, l_wrd, ln_wrd, wrd, 
     :           TRACEHEADER )
         endif
         
      ENDDO

      return
      end
