C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c
c read through a USP dataset, extract horizon information 
c from user defined header slots and build voxel geo horizon file 
c containing the the data presented as a vghrz horizon
c 
c Request by Janet Cairns
c original code Paul G. A. Garossino Sept/98
c
c Changes:
c
c
c -----------------  ----------------------- -----------------------  --
c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, nreco
      integer     luin , lbytes, nbytes
      integer     irs, ire, ns, ne, argis

      character   ntap*255, otap*255, name*9

      logical     verbos

c Program Specific _ dynamic memory variables

      integer HeaderSize
      integer errcod1, errcod2, errcod3, errcod4, abort
      integer Headers, hw

      real    Trace, r_hw

      pointer ( memadr_Trace, Trace(1) )
      pointer ( memadr_r_hw, r_hw(1) )
      pointer ( memadr_Headers, Headers(1) )
      pointer ( memadr_hw, hw(1) )

c Program Specific _ static memory variables

      integer ifmt_hw(100), l_hw(100), ln_hw(100)
      integer hdr_index, JJ, KK, i, num_horizons, length, length1
      integer ierr, segment, luout(100)
      integer hwc(100)

      real null
      real TmMsFS

      character*6 c_hw(100)
      character*10 c_hwc(100)
      character*255 c_hw_filename(100), otap1

c Initialize variables

      data abort/0/
      data name/"HDR2VGHRZ"/
      data segment/1/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c Initialize variables

      do i = 1, 100
         c_hw(i) = ' '
         c_hwc(i) = ' '
         c_hw_filename(i) = ' '
         ifmt_hw(i) = 0
         l_hw(i) = 0
         ln_hw(i) = 0
         hwc(i) = 0
         luout(i) = 0
      enddo

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln (  ntap, otap, irs, ire, ns, ne, c_hw, c_hwc, 
     :     c_hw_filename, num_horizons, null, name, verbos )

c open input USP dataset

      call getln(luin , ntap,'r', 0)

c open output voxel geo horizon files, one file per horizon.  The
c horizon names will come from c_hw_filename[] unless empty then
c the default name will become the USP trace header mnemonic used c_hw[]


      if ( otap .ne. ' ' ) then
         length = lenth(otap)

         if ( otap(length:1) .ne. '/' )otap = otap(1:length)//'/'
         length = lenth(otap)

         do i = 1, num_horizons

            call alloclun ( luout(i) )

            if ( c_hw_filename(i) .ne. ' ' ) then
               otap1 = c_hw_filename(i)
               length1 = lenth(otap1)
               otap1 = otap(1:length)//otap1(1:length1)//'.xyz'
               length1 = lenth(otap1)
            else
               otap1 = c_hw(i)
               length1 = lenth(otap1)
               otap1 = otap(1:length)//otap1(1:length1)//'.xyz'
               length1 = lenth(otap1)
            endif

            open ( unit = luout(i), file = otap1(1:length1), 
     :           status = 'unknown', iostat = ierr )

            if(ierr .ne. 0) then
               write(LER,*)'USP2VGHRZ: Could not open output file ',
     :              otap1(1:length1)
               write(LER,*)'             Check permissions and rerun '
               write(LER,*)'FATAL'
               stop
            endif
 
         enddo

      else

         do i = 1, num_horizons

            call alloclun ( luout(i) )

            if ( c_hw_filename(i) .ne. ' ' ) then
               otap1 = c_hw_filename(i)
               length1 = lenth(otap1)
               otap1 = otap1(1:length1)//'.xyz'
               length1 = lenth(otap1)
            else
               otap1 = c_hw(i)
               length1 = lenth(otap1)
               otap1 = otap1(1:length1)//'.xyz'
               length1 = lenth(otap1)
            endif

            open ( unit = luout(i), file = otap1(1:length1), 
     :           status = 'unknown', iostat = ierr )

            if(ierr .ne. 0) then
               write(LER,*)'USP2VGHRZ: Could not open output file ',
     :              otap1(1:length1)
               write(LER,*)'             Check permissions and rerun '
               write(LER,*)'FATAL'
               stop
            endif
 
         enddo

      endif

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'HDR2VGHRZ: no line header on input file',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'TmMsFS', TmMsFS , LINHED)
c print HLH to printout file 

      call hlhprt (itr, lbytes, name, 9, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec
      nreco = ire - irs + 1

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc
      ntrco = ne - ns + 1

c set up pointers to required horizon trace header mnemonics

      do i = 1, num_horizons
         call savelu ( c_hw(i), ifmt_hw(i), l_hw(i), ln_hw(i), 
     :        TRACEHEADER )
      enddo

c verbose output of all pertinent information before processing begins

      call verbal ( ntap, nsamp, nsi, ntrc, nrec, irs, ire, ns, ne, 
     :     c_hw, c_hwc, c_hw_filename, num_horizons, null, otap, 
     :     verbos )

c dynamic memory allocation:  

      HeaderSize = ntrco * ITRWRD

      call galloc (memadr_hw, ntrco * SZSMPD, errcod1, abort)
      call galloc (memadr_Trace, ntrco * SZSMPD, errcod2, abort)
      call galloc (memadr_r_hw, ntrco * SZSMPD, errcod3, abort)
      call galloc (memadr_Headers, HeaderSize * SZSMPD, errcod4, abort)
    
      if ( errcod1 .ne. 0 .or. 
     :     errcod2 .ne. 0 .or. 
     :     errcod3 .ne. 0 .or. 
     :     errcod4 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) HeaderSize* SZSMPD, '  bytes'
         write(LERR,*) 3 * ntrco * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) HeaderSize* SZSMPD, '  bytes'
         write(LER,*) 3 * ntrco * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) HeaderSize* SZSMPD, '  bytes'
         write(LERR,*) 3 * ntrco * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( Trace, 1, ntrco )
      call vclr ( r_hw, 1, ntrco )
      call vclr ( hw, 1, ntrco )  
      call vclr ( Headers, 1, HeaderSize )

c load up pickfile color array hwc[]

      do i = 1, num_horizons

c following colour scheme came from Janet and is used
c in voxel geo
c black (0 0 0)
c white (1 1 1)
c red (1 0 0)
c blue ( 0 0 1)
c green (0 1 0)
c magenta (1 0 .6)
c purple (.65 0 1)
c yellow (1 1 0)
c cyan (0 .95 1)
c orange (1 .41 0)

         if ( c_hwc(i) .eq. 'white' )   c_hwc(i) = '(1 1 1)'
         if ( c_hwc(i) .eq. 'black' )   c_hwc(i) = '(0 0 0)'
         if ( c_hwc(i) .eq. 'red' )     c_hwc(i) = '(1 0 0)'
         if ( c_hwc(i) .eq. 'blue' )    c_hwc(i) = '(0 0 1)'
         if ( c_hwc(i) .eq. 'green' )   c_hwc(i) = '(0 1 0)'
         if ( c_hwc(i) .eq. 'magenta' ) c_hwc(i) = '(1 0 .6)'
         if ( c_hwc(i) .eq. 'purple' )  c_hwc(i) = '(.65 0 1)'
         if ( c_hwc(i) .eq. 'yellow' )  c_hwc(i) = '(1 1 0)'
         if ( c_hwc(i) .eq. 'cyan' )    c_hwc(i) = '(0 .95 1)'
         if ( c_hwc(i) .eq. 'orange' )  c_hwc(i) = '(1 .41 0)'

c default to yellow if not assigned

         if ( c_hwc(i) .ne. '(1 1 1)' .and. 
     :        c_hwc(i) .ne. '(0 0 0)' .and.   
     :        c_hwc(i) .ne. '(1 0 0)' .and.   
     :        c_hwc(i) .ne. '(0 0 1)' .and.   
     :        c_hwc(i) .ne. '(0 1 0)' .and.   
     :        c_hwc(i) .ne. '(1 0 .6)' .and.   
     :        c_hwc(i) .ne. '(.65 0 1)' .and.   
     :        c_hwc(i) .ne. '(1 1 0)' .and.   
     :        c_hwc(i) .ne. '(0 .95 1)' .and.   
     :        c_hwc(i) .ne. '(1 .41 0)' ) then
            c_hwc(i) = '(1 1 0)'
         endif
      enddo

c write out voxel geo horizon file headers

      do i = 1, num_horizons
         call vg_header ( luout(i), c_hw_filename(i), c_hwc(i) )
      enddo

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire

c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

c set up Headers[] array index

         hdr_index = 1 - ITRWRD

         DO KK = ns, ne

c Load up header data for this record, at this point the actual data is
c not required.  If at some future point we allow the installation of
c the horizon as a tick on the data this may change.

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

            hdr_index = hdr_index + ITRWRD
            call vmov ( itr(1), 1, Headers(hdr_index), 1, ITRWRD )

         ENDDO

c build and output all segments for this record based on the horizon
c content specified on the command line

         call vg_segments ( HeaderSize, Headers, JJ, ifmt_hw, l_hw, 
     :        ln_hw, hw, r_hw, num_horizons, ntrco , null, Trace, luout)

c skip to end of record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

      ENDDO

c close data files 

      call lbclos ( luin )

      do i = 1, num_horizons
         close ( luout(i) )
      enddo

      write(LERR,*)'hdr2vghrz: Normal Termination'
      write(LER,*)'hdr2vghrz: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      do i = 1, num_horizons
         close ( luout(i) )
      enddo

      write(LERR,*)'hdr2vghrz: ABNORMAL Termination'
      write(LER,*)'hdr2vghrz: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for HDR2VGHRZ: USP header'
      write(LER,*)' value to voxel geo horizon file conversion'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input......................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                     (stdin)'
      write(LER,*)'-O[]   -- output data set rootname              (./)'
      write(LER,*)'-rs[]  -- start record                           (1)'
      write(LER,*)'-re[]  -- end record                   (last record)'
      write(LER,*)'-ns[]  -- start trace                            (1)'
      write(LER,*)'-ne[]  -- end trace                     (last trace)'
      write(LER,*)'-null[] -- null value                     (-30000.0)'
      write(LER,*)' '
      write(LER,*)'Horizon Specification '
      write(LER,*)'--------------------- '
      write(LER,*)' '
      write(LER,*)' -hw[], hw[], hw[] ..... hw[] [default: Horz01 - 04]'
      write(LER,*)' '
      write(LER,*)' enter up to 100 horizons by repeating the -hw '
      write(LER,*)' command line key as many times as necessary '
      write(LER,*)' followed by the desired trace header mnemonic'
      write(LER,*)' '
      write(LER,*)' -hc[], hc[], hc[] ..... hc[]    [default - 0,1,2,3]'
      write(LER,*)' '
      write(LER,*)' enter up to 100 horizon colours by repeating the '
      write(LER,*)' -hc command line key as many times as necessary '
      write(LER,*)' followed by the desired colour.  Valid colours are:'
      write(LER,*)' '
      write(LER,*)'  white'
      write(LER,*)'  black'
      write(LER,*)'  red'
      write(LER,*)'  blue'
      write(LER,*)'  green'
      write(LER,*)'  magenta'
      write(LER,*)'  purple'
      write(LER,*)'  yellow'
      write(LER,*)'  cyan'
      write(LER,*)'  orange'
      write(LER,*)' '
      write(LER,*)' -hn[], hn[], hn[] ..... hn[]   [default - use hw[]]'
      write(LER,*)' '
      write(LER,*)' enter up to 100 output voxel geo horizon filenames'
      write(LER,*)' by repeating the -hn command line key as many times'
      write(LER,*)' as necessary followed by the desired name.  The '
      write(LER,*)' output horizon file name will be this name with the'
      write(LER,*)' suffix [.xyz] added.'
      write(LER,*)' '
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'      hdr2vghrz -N[] -rs[] -re[] -ns[] -ne[] -hw[] '
      write(LER,*)'                -hw[] -hw[] -hw[] .... -hw[] -hc[] '
      write(LER,*)'                -hc[] -hc[] .... -hc[] -hn[] -hn[] '
      write(LER,*)'                -hn[] .... -hn[] -O[] -V'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, irs, ire, ns, ne, c_hw, c_hwc, 
     :     c_hw_filename, num_horizons, null, name, verbos )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer    irs, ire, ns, ne, num_horizons, argis

      real null

      character  ntap*(*), otap*(*), name*(*)
      character*6 c_hw(100)
      character*10 c_hwc(100)
      character*255 c_hw_filename(100)

      logical  verbos

c declare local variables

      integer i, num_colours, num_fnames

      logical done

c initialize variables

      i = 1
      done = .false.

      do while ( .not. done )

c read in horizon mnemonics to be used

         call argstr ( '-hw', c_hw(i), ' ', ' ' )

         if ( i .gt. 100 ) then
               write(LERR,*)' a maximum of 100 horizons are allowed'
               write(LERR,*)' adjust your command line and try again'
               write(LERR,*)'FATAL'
               write(LERR,*)' '
               write(LER,*)' '
               write(LER,*)'USP2VGHRZ:'
               write(LER,*)' a maximum of 100 horizons are allowed'
               write(LER,*)' adjust your command line and try again'
               write(LER,*)'FATAL'
               stop
         endif

         if ( c_hw(i) .eq. ' ' ) then
            num_horizons = i - 1
            done = .true.
         endif

         i = i + 1
      enddo

c read in horizon colours to be used or load defaults

      done = .false.
      i = 1

      do while ( .not. done )

         call argstr ( '-hc', c_hwc(i), ' ', ' ' )

         if ( c_hwc(i) .eq. ' ' ) then
            num_colours = i - 1

            if ( num_colours .lt. num_horizons ) then
               do j = num_colors + 1, num_horizons
                  c_hwc(j) = 'yellow'
               enddo
            endif

            done = .true.
         endif

         i = i + 1
      enddo

c read in voxel geo horizon filenames  or load defaults

      done = .false.
      i = 1

      do while ( .not. done )

         call argstr ( '-hn', c_hw_filename(i), ' ', ' ' )

         if ( c_hw_filename(i) .eq. ' ' ) then
            num_fnames = i - 1

            if ( num_fnames .lt. num_horizons ) then
               do j = num_fnames + 1, num_horizons
                  c_hw_filename(j) = c_hw(j)
               enddo
            endif

            done = .true.
         endif

         i = i + 1
      enddo

      if ( c_hw(1) .eq. ' ' ) then
         c_hw(1) = 'Horz01'
         c_hw(2) = 'Horz02'
         c_hw(3) = 'Horz03'
         c_hw(4) = 'Horz04'
         num_horizons = 4
      endif

      if ( c_hwc(1) .eq. ' ' ) then
         c_hwc(1) = 'red'
         c_hwc(2) = 'blue'
         c_hwc(3) = 'green'
         c_hwc(4) = 'yellow'
      endif

      if ( c_hw_filename(1) .eq. ' ' ) then
         c_hw_filename(1) = c_hw(1)
         c_hw_filename(2) = c_hw(2)
         c_hw_filename(3) = c_hw(3)
         c_hw_filename(4) = c_hw(4)
      endif

      call argr4 ( '-null', null, -30000.0, -30000.0 )
      call argi4 ( '-ne', ne, 0, 0 )
      call argi4 ( '-ns', ns, 0, 0 )

      call argstr ( '-N', ntap, ' ', ' ' ) 

      call argstr ( '-O', otap, ' ', ' ' ) 

      call argi4 ( '-re', ire, 0, 0 )
      call argi4 ( '-rs', irs, 0, 0 )

      verbos = (argis('-V') .gt. 0)

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, nsamp, nsi, ntrc, nrec, irs, ire, 
     :     ns, ne, c_hw, c_hwc, c_hw_filename, num_horizons, null, 
     :     otap, verbos )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer nsamp, nsi, ntrc
      integer irs, ire, ns, ne, num_horizons

      real null

      character  ntap*(*), otap*(*)
      character*6 c_hw(num_horizons)
      character*10 c_hwc(num_horizons)
      character*255 c_hw_filename(num_horizons)

      logical    verbos

c declare local variables

      integer length

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name   =  ', ntap(1:length)
      else
        write(LERR,*) ' input data set        = stdin'
      endif
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' start record            =  ', irs 
      write(LERR,*) ' end record              =  ', ire 
      write(LERR,*) ' start trace             =  ', ns 
      write(LERR,*) ' end trace               =  ', ne 
      write(LERR,*) ' null value   = ', null
      if ( otap .ne. ' ' )  then
         length = lenth(otap)
         write(LERR,*)' output rootname          = ',otap(1:length)
      endif
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Horizons, Colours and File Names Requested '
      write(LERR,*)' '
      write(LERR,*)' '
      do i = 1, num_horizons
         write(LERR,'(a6,2x,a10,2x,a20)') c_hw(i), c_hwc(i), 
     :        c_hw_filename(i)
      enddo
      write(LERR,*)' '
      write(LERR,*)' '
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





