C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c    hdrstrip --- A USP program template
c
c    Execute "hdrstrip -h" for self documentation.
c
c    hdrstrip reads in a USP dataset (or a subset of the dataset, depending
c    on various command-line parameters), strips off the line header
c    and trace header info, writing them to an output dataset, and passes
c    the original unadulterated data to the output file or pipe.
c
c***********************************************************************

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

#define SLOP 5

      integer     llhed ( SZLNHD )
      integer * 2 ilhed ( SZLNHD*2 )
      real        rlhed ( SZLNHD )
      equivalence ( ilhed(1), llhed (1), rlhed(1) )

      integer     lthed
      integer * 2 ithed
      real        rthed

      pointer     (wkadrt, lthed(2))
      pointer     (wkadrt, ithed(2))
      pointer     (wkadrt, rthed(2))

      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lhbytes, nbytes
      integer     irs,ire,ns,ne
 
      integer     recnum, trcnum

      character   ntap * 100, otap * 100, otap2 * 100, name * 100
      logical     verbose, query, IKP
      integer     status, argis

      data name / 'HDRSTRP' /


      data lhbytes / 0 /, nbytes / 0 /

      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0
     1          .or. argis ( '-help' ) .gt. 0 )

      if ( query )then
            call help('hdrstrip')
            stop
      endif


#include <f77/open.h>

      call gcmdln('hdrstrip',ntap,otap,otap2,ns,ne,irs,ire,
     1             verbose)

      IKP = .false.
      if (in_ikp() .eq. 1) then
	IKP = .true.
      endif

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

      if (IKP) then
	status = 0
	call pipchk(3, status)
	if (status .eq. 0) then
	  call sisfdfit(luout2, 3)
	endif
      else
        call getln(luout2, otap2,'w', 3)
      endif

      call rtape  (luin, ilhed, lhbytes)

      if(lhbytes .eq. 0) then
         write(LER ,*) 'hdrstrip',
     :   ': no line header read from unit ', luin
         write(LERR,*) 'hdrstrip',
     :   ': no line header read from unit ', luin
         write(LER ,*) 'hdrstrip', ' FATAL'
         stop
      endif

      call saver(ilhed, 'NumSmp', nsamp, LINEHEADER)
      call saver(ilhed, 'SmpInt', nsi  , LINEHEADER)
      call saver(ilhed, 'NumTrc', ntrc , LINEHEADER)
      call saver(ilhed, 'NumRec', nrec , LINEHEADER)
      call saver(ilhed, 'Format', iform, LINEHEADER)

      if (nsamp .le. 0 .or. ntrc .le. 0 .or. nrec .le. 0) then
         write(LER ,*) 'hdrstrip',
     1            ': Input line header indicates null input dataset.'
         write(LERR,*) 'hdrstrip',
     1            ': Input line header indicates null input dataset.'
         write(LERR,*) 'NumSmp=', nsamp
         write(LERR,*) 'NumTrc=', ntrc
         write(LERR,*) 'NumRec=', nrec
         write(LER ,*) 'hdrstrip', ' FATAL'
         stop
      endif

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

      nrecout = ire - irs + 1
      call savew(ilhed, 'NumRec', nrecout, LINEHEADER)
      ntrcout   = ne - ns + 1
      call savew(ilhed, 'NumTrc', ntrcout  , LINEHEADER)

      obytes = SZTRHD + nsamp * SZSMPD

      call wrtape ( luout, ilhed, lhbytes  )

c
c    This dataset has no data; it is headers only.
c
      call savew(ilhed, 'NumSmp', 0  , LINEHEADER)
      call savhlh(ilhed,lhbytes,lhbytes)
      call wrtape ( luout2, ilhed, lhbytes  )

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)

c    Tell galloc not to abort in case of error;
c    we'll check the return code and print our own message.

      iabort = 0

c    Allocate space for a trace with a header attached

      call galloc (wkadrt, SZTRHD + (nsamp + SLOP) * SZSMPD,
     1                    ierr1, iabort)

      if (ierr1 .ne. 0) then
         write(LER ,*) 'hdrstrip',
     1            ': Could not allocate enough space for a trace ',
     2            nsamp, ' samples long.'
         write(LERR,*) 'hdrstrip',
     1            ': Could not allocate enough space for a trace ',
     2            nsamp, ' samples long.'
         write(LER ,*) 'hdrstrip', ' FATAL'
         stop
      endif

c     verbose output of all pertinent information before
c     processing begins

      if( verbose ) then
            call verbal(nsamp, nsi, ntrc, nrec, ntap, otap, otap2)
      end if
c
c*********************************************************************
c
c    BEGIN TRACE PROCESSING
c
c*********************************************************************

c-----
c    Process desired trace records;
c    Keep track of how many we've done in ireccount.
c    itottrcount is the total number of traces we've
c    processed in the entire input dataset so far.
c-----

      ireccount = 0
      itottrcount = 0
      do 1000 irecord = irs, ire
 
            call trcskp(irecord,1,ns-1,luin,ntrc,ithed)
            itrcount = 0
            do 1001  itrace = ns, ne

 
                  nbytes = 0
                  call rtape( luin, ithed, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*) 'hdrstrip',
     1                          ': Unexpected End of file on input,'
                     write(LERR,*)'  rec= ',irecord,'  trace= ',itrace
c
c    Bailing out (gracefully)!
c
                     go to 999
                  endif
c
                  itrcount = itrcount + 1
                  itottrcount = itottrcount + 1
 
                  call saver2(lthed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(lthed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)

		  call wrtape(luout, ithed, nbytes)
		  call wrtape(luout2, ithed, nbytes-nsamp*SZSMPD)

 1001       continue
            ireccount = ireccount + 1

            call trcskp(irecord,ne+1,ntrc,luin,ntrc,ithed)

 1000       continue

  999 continue

      call lbclos ( luin )
      call lbclos ( luout )
      call lbclos ( luout2 )
 
      write(LERR,*) 'End of "', 'hdrstrip',
     1   '"; processed', itottrcount, ' trace(s) in',
     2   ireccount, ' record(s).'
      write(LER ,*) 'End of "', 'hdrstrip',
     1   '"; processed', itottrcount, ' trace(s) in',
     2   ireccount, ' record(s).'

c
c-----

      stop      
      end
 


c***********************************************************************
c
c    Here's the routine that prints out the help message.
c
c
      subroutine help(name)
      character * (*)  name
#include <f77/iounit.h>


         write(LER,*)
     :'***************************************************************',
     :'****************'
        write(LER,*) ' '
        write(LER,*) name,
     :' will create a secondary dataset contain USP header info only.'
        write(LER,*)' '
        write(LER,*)
     :'Execute by typing "', name,
     :'" followed by the program parameters.'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default; stdin if not specified)'
        write(LER,*)
     :'                                   : input data file name'
        write(LER,*)
     :' -O [otap]    (no default; stdout if not specified)'
        write(LER,*)
     :'                                   : output data file name',
     :' (original data)'
        write(LER,*)
     :' -O2 [otap]    (no default)        : output data file name',
     :' (headers only)'
c       write(LER,*)
c    :'                                   : for headers only'
        write(LER,*)
     :' -rs[irs]     (default = first)    : start record number'
        write(LER,*)
     :' -re[ire]     (default = last)     : end record number'
        write(LER,*)
     :' -ns[ins]     (default = first)    : start trace number'
        write(LER,*)
     :' -ne[ine]     (default = last)     : end trace number'
        write(LER,*) ' '
        write(LER,*)
     :' -V                                : verbose printout'
        write(LER,*)
     :'usage:    ', name,
     :' -N[ntap] -O[otap] -O2[otap] -ns[ns] -ne[ne] -rs[irs]',
     :' -re[ire] [-V]'
        write(LER,*) ' '
        write(LER,*)
     :'self doc: ', name,
     :' -h'
        write(LER,*)
     :'***************************************************************',
     :'****************'
      return
      end
c
      subroutine gcmdln(name,ntap,otap,otap2,ns,ne,irs,ire,
     1                  verbose)
c-----
c    Set the following variables:
c
c     ntap       - C*100    input file name
c     otap       - C*100    output file name
c     ns         - I*4      starting trace index
c     ne         - I*4      ending trace index
c     irs        - I*4      starting record index
c     ire        - I*4      ending record index
c     verbose    - L        verbose output or not
c
c-----
      character   name*(*)
      character   ntap*(*), otap*(*), otap2*(*)
      integer     ns, ne, irs, ire
      logical     verbose
      integer     argis, argfre
      character   sargvv * 100
      character   args * 100
#include <f77/iounit.h>
 
c-------

            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O2', otap2, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
c
            verbose =   (argis('-V') .gt. 0)

 50         narg = argfre(0)
            if (narg .gt. 0) then
                 args = sargvv(narg)
                 write(LER ,*) name,
     :           ': unknown argument "', args(1:nblen(args)),
     :           '" ignored.'
                 write(LERR,*) name,
     :           ': unknown argument "', args(1:nblen(args)),
     :           '" ignored.'
                 call argeat (narg)
                 goto 50
            endif
c-----
 
            return
            end
 
c
c    Verbose output of processing parameters
c
      subroutine verbal(nsamp, nsi, ntrc, nrec, ntap, otap, otap2)
c
c     nsamp      - I*4     number of samples in trace
c     nsi        - I*4     sample interval in ms
c     ntrc       - I*4     traces per record
c     nrec       - I*4     number of records per line
c     ntap       - C*100   input file name
c     otap       - C*100   output file name
c
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*), otap2*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*) ' stripped output data set name=  ', otap2
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
