C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getlegnd(icolor,tracebuf,nh,nl,ns,npix,
     1                    mincvalue,ITRWRD,TRACEHEADER,
     2                    l_TrcNum,ifmt_TrcNum,ln_TrcNum,
     3                    l_RecNum,ifmt_RecNum,ln_RecNum,
     4                    lerr,lulegend,nbytes_out_legend)
c_________________________________________________________________
c     generate a simple usp format file that plots the color legend.
c     (angle number) as a function of (p,q) or (ptheta,phi).
c_________________________________________________________________
      integer  TRACEHEADER
      integer  icolor(nh,0:nl,ns)            
      real     tracebuf(-ITRWRD:nh*npix-1)
c_________________________________________________________________
c     write the color legend out as a cube of data.
c_________________________________________________________________
      write(lerr,*) 'in getlegnd'
      write(lerr,'(4a10)') 'jh','jl','js','icolor'
      write(lerr,'(4i10)') (((jh,jl,js,icolor(jh,jl,js),jh=1,nh),
     1                 jl=0,nl),js=1,ns)

      do 62000 js=1,ns          
       do 61000 jspix=1,npix
        jrec=(js-1)*npix+jspix
        call savew2(tracebuf,ifmt_RecNum,l_RecNum,ln_RecNum,
     1              jrec,TRACEHEADER)
        do 52000 jl=1,nl             
         do 51000 jlpix=1,npix
          jtr=(jl-1)*npix+jlpix 
          call savew2(tracebuf,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1                jtr,TRACEHEADER)
          do 42000 jh=1,nh
           do 41000 jhpix=1,npix
            jsamp=(jh-1)*npix+jhpix-1
            jcolor=icolor(jh,jl,js)
            tracebuf(jsamp)=mincvalue+4.*(jcolor-0)
41000      continue
42000     continue
          call wrtape(lulegend,tracebuf,nbytes_out_legend)
51000    continue
52000   continue
61000  continue
62000 continue
63000 continue
      write(lerr,*) 'exit getlegnd'
      write(lerr,'(4a10)') 'jh','jl','js','icolor'
      write(lerr,'(4i10)') (((jh,jl,js,icolor(jh,jl,js),jh=1,nh),
     1                 jl=0,nl),js=1,ns)
c
      return
      end
