C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine process(uh,ul,us,uout,tracebuf,
     1                   trchdr,icolor,nh,nl,ns,
     2                   nsamp,ITRWRD,nbytes_out,
     3                   istart,iend,starttrace,endtrace,ntr,
     4                   startline,endline,
     5                   luh,lul,lus,luout,lerr,ler,
     6                   hue,lightness,saturation,
     7                   uhmin,uhmax,chmin,chmax,
     8                   ulmin,ulmax,clmin,clmax,
     9                   usmin,usmax,csmin,csmax,mincvalue,
     a                   l_StaCor,ifmt_StaCor,ln_StaCor,TRACEHEADER)
c
      integer    starttrace,endtrace,startline,endline
      real       uh(istart:iend,starttrace:endtrace)
      real       ul(istart:iend,starttrace:endtrace)
      real       us(istart:iend,starttrace:endtrace)
      real       uout(istart:iend,starttrace:endtrace)
      real       tracebuf(-ITRWRD:nsamp-1)
c
      integer    trchdr(ITRWRD,starttrace:endtrace)
      integer    icolor(nh,0:nl,ns)
c
      integer    TRACEHEADER
c
      logical    hue,lightness,saturation
      logical    eof,goscale
c___________________________________________________________________
c     initialize
c___________________________________________________________________
      scaleh=0.
      scalel=0.
      scales=0.
      do 5000 jtr=starttrace,endtrace
       do 4000 k=istart,iend
        uh(k,jtr)=1.
        ul(k,jtr)=1.
        us(k,jtr)=1.
4000   continue
5000  continue
c___________________________________________________________________
c     read past data until we hit the starting line.
c     don't bother scaling.
c___________________________________________________________________
      goscale=.false.
      do 10000 jline=1,startline-1
       if(hue) then
          call rdgather(uh,live,luh,starttrace,endtrace,ntr,eof,
     1                  tracebuf,tracebuf,trchdr,ITRWRD,nsamp,lerr,
     2                  istart,iend,
     2                  scaleh,uhmin,uhmax,chmin,chmax,goscale,
     3                  l_StaCor,ifmt_StaCor,ln_StaCor,TRACEHEADER)
       endif
       if(lightness) then
          call rdgather(ul,live,lul,starttrace,endtrace,ntr,eof,
     1                  tracebuf,tracebuf,trchdr,ITRWRD,nsamp,lerr,
     2                  istart,iend,
     2                  scalel,ulmin,ulmax,clmin,clmax,goscale,
     3                  l_StaCor,ifmt_StaCor,ln_StaCor,TRACEHEADER)
       endif
       if(saturation) then
          call rdgather(us,live,lus,starttrace,endtrace,ntr,eof,
     1                  tracebuf,tracebuf,trchdr,ITRWRD,nsamp,lerr,
     2                  istart,iend,
     2                  scales,usmin,usmax,csmin,csmax,goscale,
     3                  l_StaCor,ifmt_StaCor,ln_StaCor,TRACEHEADER)
       endif
10000 continue
c___________________________________________________________________
c     read and scale data.
c     calculate color value.
c     write out the hls composite data.
c___________________________________________________________________
      goscale=.true.
      chmin=1
      chmax=nh
      clmin=0
      clmax=nl
      csmin=1
      csmax=ns
      do 90000 jline=startline,endline
       if(hue) then
          call rdgather(uh,live,luh,starttrace,endtrace,ntr,eof,
     1                  tracebuf,tracebuf,trchdr,ITRWRD,nsamp,lerr,
     2                  istart,iend,
     2                  scaleh,uhmin,uhmax,chmin,chmax,goscale,
     3                  l_StaCor,ifmt_StaCor,ln_StaCor,TRACEHEADER)
       endif
       if(lightness) then
          call rdgather(ul,live,lul,starttrace,endtrace,ntr,eof,
     1                  tracebuf,tracebuf,trchdr,ITRWRD,nsamp,lerr,
     2                  istart,iend,
     2                  scalel,ulmin,ulmax,clmin,clmax,goscale,
     3                  l_StaCor,ifmt_StaCor,ln_StaCor,TRACEHEADER)
       endif
       if(saturation) then
          call rdgather(us,live,lus,starttrace,endtrace,ntr,eof,
     1                  tracebuf,tracebuf,trchdr,ITRWRD,nsamp,lerr,
     2                  istart,iend,
     2                  scales,usmin,usmax,csmin,csmax,goscale,
     3                  l_StaCor,ifmt_StaCor,ln_StaCor,TRACEHEADER)
       endif
       write(lerr,*) 'jline = ',jline
       write(lerr,*) 'uhmin,uhmax ',uhmin,uhmax
       write(lerr,*) 'ulmin,ulmax ',ulmin,ulmax
       write(lerr,*) 'usmin,usmax ',usmin,usmax
c
       do 30000 jtr=starttrace,endtrace
        do 20000 k=istart,iend
         jhue=nint(uh(k,jtr))
         jlight=nint(ul(k,jtr))
         jsat=nint(us(k,jtr))
         uout(k,jtr)=mincvalue+4*(icolor(jhue,jlight,jsat)-0)
20000   continue
30000  continue

       call wrgather(uout,luout,starttrace,endtrace,istart,iend,
     1               tracebuf,tracebuf,trchdr,nsamp,ITRWRD,
     2               nbytes_out)
90000 continue

      return
      end

