C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdgather(uin,live,luin,starttrace,endtrace,ntr,eof,
     1                    tracebuf,ibuffer,trchdr,ITRWRD,nsamp,lerr,
     2                    istart,iend,
     3                    scale,umin,umax,cmin,cmax,goscale,
     4                    l_StaCor,ifmt_StaCor,ln_StaCor,TRACEHEADER)
c
      integer   starttrace,endtrace
      real      uin(istart:iend,starttrace:endtrace)
      real      tracebuf(-ITRWRD:nsamp-1)
      integer   ibuffer(ITRWRD)
      integer   trchdr(ITRWRD,starttrace:endtrace)
      logical   live(starttrace:endtrace)
      integer   TRACEHEADER
      logical   eof,goscale
c_______________________________________________________________________
c     this routine reads in a seismic record (or for 3d, one seismic 'line').
c     we store the trace header which will be reused on the output data
c     and a live trace flag for each trace.
c_______________________________________________________________________
      eof=.false.
c_______________________________________________________________________
c     read past the first starttrace-1 traces.              
c_______________________________________________________________________
      do 10000 jtr=1,starttrace-1
       nbytes_in=0
       call rtape(luin,tracebuf,nbytes_in)
       if(nbytes_in .le. 0) then
          eof=.true.
          write(lerr,*) 'eof hit in reading jtr = ',jtr
          return
       endif
10000 continue
c_______________________________________________________________________
c     read traces from starttrace to endtrace into memory.  
c     copy trace header into memory.
c_______________________________________________________________________
      do 40000 jtr=starttrace,endtrace
       nbytes_in=0
       call rtape(luin,tracebuf,nbytes_in)
       if(nbytes_in .le. 0) then
          eof=.true.
          write(lerr,*) 'eof hit in reading jtr = ',jtr
          return
       endif
       call saver2(ibuffer,ifmt_StaCor,l_StaCor,ln_StaCor,
     1             istat,TRACEHEADER)
       if(istat .eq. 30000) then
          live(jtr)=.false.
          do 22000 k=istart,iend
           uin(k,jtr)=0.
22000     continue
       else
          live(jtr)=.true.    
          do 23000 k=istart,iend
           uin(k,jtr)=tracebuf(k)
23000     continue
       endif
       do 30000 k=1,ITRWRD
        trchdr(k,jtr)=ibuffer(k)
30000  continue
40000 continue
c_______________________________________________________________________
c     read past the last ntr-endtrace+1 traces.              
c_______________________________________________________________________
      do 50000 jtr=endtrace+1,ntr
       nbytes_in=0
       call rtape(luin,tracebuf,nbytes_in)
       if(nbytes_in .le. 0) then
          eof=.true.
          write(lerr,*) 'eof hit in reading jtr = ',jtr
          return
       endif
50000 continue
      if(goscale) then
      if(umin .eq. umax) then
c_______________________________________________________________________
c           autoscale.
c           find the min and max values for the first live record. 
c_______________________________________________________________________
            umin=+1.e+20
            umax=-1.e+20
            u2=0.
            do 60000 jtr=starttrace,endtrace
             do 55000 k=istart,iend
              umin=min(uin(k,jtr),umin)
              umax=max(uin(k,jtr),umax)
55000        continue
60000       continue
         endif
         nsum=(endtrace-starttrace+1)*(iend-istart+1)
         if(umin .eq. umax) then
            scale=0.
         else
            scale=(cmax-cmin)/(umax-umin)
         endif
c_______________________________________________________________________
c        scale data to lie between cmin and cmax.
c        clip if necessary.
c_______________________________________________________________________
         do 70000 jtr=starttrace,endtrace
          do 65000 k=istart,iend
           uin(k,jtr)=cmin+(uin(k,jtr)-umin)*scale
           uin(k,jtr)=min(cmax,uin(k,jtr))
           uin(k,jtr)=max(cmin,uin(k,jtr))
65000     continue
70000    continue
      endif
c
      return
      end 
