C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine picker (ntrc,nsamp,nrec,nhor,nvel,jrec,si,velsem,log,
     1                   vello,velhi,recnum,times,data,vout,nord,dvel,
     2                   next,thr,linear,igate,vtr,pikout,svel,nseg,
     3                   currec,velav,LH,verbos,vmn,vmx,lunflt,xsd,
     4                   nrecs,gamma,iscl,depwrd,idepwrd,first)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real      times(nrec,nhor)
      integer   recnum(nrec,nhor)
      real      pikout(nvel,nhor,3)
      real      data(nsamp,ntrc)
      real      velsem(*), vello(*), velhi(*), vout(*), vtr(*)
      real      velav(*)
      integer   nseg(*)
      character depwrd * 6

      real      sem(SZLNHD), velf(SZLNHD), tf(SZLNHD), sig(SZLNHD)
      integer   jhor(SZLNHD), key(SZLNHD)
      real      vp(SZLNHD)
      integer   ip(SZLNHD)
      integer   pass, currec, idepwrd

      integer   nord,log
      logical   linear
      logical   verbos
      logical   xsd
      logical   gamma
      logical   first

      iflag = 0
      if (jrec .eq. 1) then
         unit1 = si
         unit2 = 1.0
         unit3 = 1.0
         off1  = 0.
         off2  = 0.
         off3  = 0.
         maxpik = nhor
      endif

      call vclr (vtr, 1, SZLNHD)

c++++++
c  do automatic picking of semblance matrices for each horizon
c++++++

      write(LERR,*)' '

      LH = 0
      LF = 0
      vlast = 0
      nord2 = 2*nord

c     write(0,*)'currec = ',currec,ntrc
c     do j = 1, ntrc
c     call maxmgv(data(1,j),1,xmax,loc,nsamp)
c     write(0,*)'j =',j,xmax
c     enddo

      DO  J = 1, nhor

          tj    = times(currec,j)

c-------------------------------------------------------------------------
        IF (tj .ge. 0.) THEN


          itj   = tj / si + 1
          itj1  = itj - igate
          if (itj1 .lt.     1) itj1 = 1
          itj2  = itj + igate
          if (itj2 .gt. nsamp) itj2 = nsamp

          vl    = vello(itj)
          vh    = velhi(itj)
          pass  = 0
          do  k = 1, ntrc
              sem (k) = 0.
              sig (k) = 0.
          enddo

c     write(0,*)'j= ',currec,j,tj,itj,vl,vh,recnum(currec,j)

          do  k = 1, ntrc

              vv = velsem(k)
              if (vv .ge. vl .AND. vv .le. vh) then
                 sem (k) = 0.
                 do  ii = itj1, itj2
                     amp = data(ii,k)
                     if (amp .gt. 0.0) then
                        sem (k) = sem (k) + amp
                        sig (k) = sig (k) + 1.0
                     endif
                 enddo
              else
                 sem (k) = 0.0
              endif

          enddo

c     write(0,*)(sem(ii),ii=1,ntrc)

          do  k = 1, ntrc
              if (sem(k) .ne. 0.0) then
                  ivs = k
                  go to 31
              endif
          enddo
31        continue

          do  k = ntrc, ivs, -1
              if (sem(k) .ne. 0.0) then
                  ive = k
                  go to 41
              endif
          enddo
41        continue

          nc  = ive - ivs + 1

c     write(0,*)'jrec, hor, ivs, ive, nc= ',jrec,j,ivs,ive,nc

          if (nc .lt. 3) then
              write(LERR,*)'WARNING: semblances were all zero for semb '
     1,                     ' rec ',jrec,' Skipped horz ',J
              go to 200
          endif
 
c----
c   smooth composite semblance
c----
          if ( (nc/2+1 .ge. nord) .AND. (nord .ge. 3) )
     1    call SmoothFit ( sem(ivs), nc, nord )
c    1    call nave (nc, nord, sem(ivs))

c----
c   normalize composite semblance
c----
          do  k = 1, ntrc
              if ( sig(k) .gt. 0.0 ) then
                 sem (k) = sem (k) / sig (k)
              endif
              sig (k) = 1.0
          enddo


          if (log .ne. 0) then
          if (mod(currec,log) .eq. 0) then

             write(LER,*)'"horz= ',J
             do l = 1, nc
                write(LER,*)ivs+l-1,sem(ivs+l-1)
             enddo
             write(LER,'()')

          endif
          endif

c     write(0,*)'rec ',jrec,'  hor ',j,thr
c     write(0,*)(sem(ivs+ii-1),ii=1,nc)

c----
c   accept only those semblance values above threshold
c----
          do  k = 1, ntrc
              if ( sem(k) .lt. thr ) sem (k) = 0.
          enddo


c----
c   for this location store semblance cuts in QC vector for each horizon
c----
          ipntr = (J - 1) * ntrc + 1
          call vmov (sem, 1, vtr(ipntr), 1, ntrc)

          call peak   (sem, ntrc, iflag, vp, ip, np)

          if (np .eq. 0) then
              write(LERR,*)'WARNING: semblances were all zero for'
              write(LERR,*)'stack rec ',currec,' semb rec ',jrec
              write(LERR,*)'horizon ',J,'  Horizon skipped.'
              go to 200
          endif

100       continue

          call maxmgv (vp, 1, vmax, lc, np)
          locv = ip (lc)
          if (locv .gt. ivs .and. locv .lt. ive) then
             c1 = sem(locv-1)
             c2 = sem(locv  )
             c3 = sem(locv+1)
             call parab (c1, c2, c3, fv, vdum)
             delv = 0.5 * ( velsem(locv+1) - velsem(locv-1) )
             velcur = velsem(locv) + fv * delv
          else
             velcur = velsem(locv)
          endif

c***********
          if (locv .le. ivs .OR. locv .ge. ive) then

             write(LERR,*)'WARNING: picker hit edge of fairway at'
             write(LERR,*)'rec= ',currec,' horz= ',J,' lo vel= ',vl,
     1                    ' vel= ',velcur,' hi vel= ',vh,ivs,locv,ive
             write(LERR,*)(vp(ii),ii=1,np)
             write(LERR,*)(ip(ii),ii=1,np)

             if (next .gt. 1) then
                 pass = pass + 1
                 if (pass .gt. next .or. pass+1 .gt. np) then
                    write(LERR,*)'Could not find alternate peak: horizon
     1 skipped'
                    go to 200
                 endif
                 write(LERR,*)'...trying alternate peak ',pass+1
                 vp (lc) = 0.
                 go to 100
              endif

          endif
c***********

            LH = LH + 1
            jhor(LH) = J
            velf(LH) = velcur
            tf  (LH) = times(currec,J)
            vlast = velcur

200       continue

        ENDIF
c-------------------------------------------------------------------------

      ENDDO

      IF (LH .lt. 1) THEN

         write(LERR,*)'Less than 1 horizons picked: location skipped'
         if ( gamma ) then
            do  i = 1, nsamp
                vout (i) = iscl
            enddo
         else
            do  i = 1, nsamp
                vout (i) = velav (i)
            enddo
         endif

         return

      ELSE

        call sortr (tf, key, LH)
        do  i = 1, LH
            sig (i) = velf (key(i))
            ip  (i) = jhor (key(i))
        enddo

        if (xsd) then

           do  j = 1, LH
               jhor(j) = ip(j)
               jh = jhor(j)
               velf (j) = sig (j)
               write(LERR,*)'Record= ',currec,'  Horz= ',jh,'  time = ',
     1                       tf(j),'  velocity= ', velf(j)
           enddo

           call pikw (nrecs,nsamp,ntrc,nhor,lunflt,currec,
     1                tf,velf,unit1,unit2,unit3,off1,off2,
     2                off3,maxpik,jrec,LH,depwrd,idepwrd,c2,
     3                first)
        else

           do  j = 1, LH
               jhor(j) = ip(j)
               jh = jhor(j)
               velf (j) = sig (j)
               write(LERR,*)'Record= ',currec,'  Horz= ',jh,'  time = ',
     1                       tf(j),'  velocity= ', velf(j)
               if (lunflt .gt. 0) then
                  itfj = tf(j)
                  ivfj = velf(j)
                  if (depwrd(1:1) .ne. ' ') then
                     write(lunflt,333) itfj, ivfj, currec, c2, idepwrd
                  else
                     write(lunflt,331) itfj, ivfj, currec
                  endif
               endif
           enddo

           if (lunflt .gt. 0) then
              itfj = -1
                  if (depwrd(1:1) .ne. ' ') then
                     write(lunflt,333) itfj, ivfj, currec, c2, idepwrd
                  else
                     write(lunflt,331) itfj, ivfj, currec
                  endif
           endif

        endif
331     format (i6, 4x, i6, 4x, i6)
333     format (i6, 4x, i6, 4x, i6, 4x, f6.4, 4x, i6)

        call pikgen (nvel,nhor,LH,jrec,currec,si,svel,dvel,velf,nseg,
     1               jhor, ntrc, pikout)

        LHi = LH
        if (vmn .ne. 0.0) then
           do  i = LHi, 1, -1
               velf (i+1) = velf (i)
               tf   (i+1) = tf   (i)
           enddo
           velf (1) = vmn
           tf   (1) = 0.
           LHi = LHi + 1
        endif
        if (vmx .ne. 0.0) then
           LHi = LHi + 1
           velf (LHi) = vmx
           tf   (LHi) = float(nsamp-1) * si
        endif

        call vel (tf, velf, nsamp, si, LHi, vout)

      ENDIF


      return
      end
