C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine pikvel (jrec,irec,ntrstk,nhor,mseg,nsamp,si,
     1                   vout,piktrn,verbos,vmin,vmax,lunflt,
     2                   ntrc,nrecs,depwrd,idepwrd)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real      vout(*), piktrn(nhor,ntrstk,3)
      integer   mseg(*)
      real      velf(SZLNHD), tf(SZLNHD), tmp(SZLNHD)
      integer   jhor(SZLNHD), key(SZLNHD), itmp(SZLNHD)
      character depwrd * 6
      logical   verbos, xsd
      
      c2 = 0.0

      if (jrec .eq. 1) then
         unit1 = si
         unit2 = 1.0
         unit3 = 1.0
         off1  = 0.
         off2  = 0.
         off3  = 0.
         maxpik = nhor
      endif

      LH    = mseg(jrec)
c     write(0,*)'jrec= ',jrec,LH,nhor,ntrstk,nsamp,si
      ic = 0
      do  j = 1, LH

          tt  = piktrn (j, jrec, 1)
          vv  = piktrn (j, jrec, 2)
          ir  = nint (piktrn (j, jrec, 3) )
          if (vv .gt. 0.0) then
             ic = ic + 1
             tf (ic)   = tt
             velf (ic) = vv
             jhor (ic) = j
             irec  = nint (piktrn (j, jrec, 3) )
c     write(0,*)'func= ',tf(ic),velf(ic),irec
          endif
      enddo

      LH  = ic
      LHi = ic
      call sortr (tf, key, LHi)
      do  i = 1, LHi
          tmp  (i) = velf (key(i))
          itmp (i) = jhor (key(i))
      enddo
      do  i = 1, LHi
          velf (i) = tmp  (i)
          jhor (i) = itmp (i)
      enddo

      if (LHi .lt. 2) then
         write(LERR,*)' '
         write(LERR,*)'HORVEL WARNING - edit mode:'
         write(LERR,*)'Ground location found at ',jrec
         write(LERR,*)'with no picks.  Will use last velocity'
         write(LERR ,*)' '
         return
      endif

      write(LERR,*)' '

      IF (xsd) THEN

           call pikw (nrecs,nsamp,ntrc,nhor,lunflt,currec,
     1                tf,velf,unit1,unit2,unit3,off1,off2,
     2                off3,maxpik,jrec,LHi,depwrd,idepwrd,c2)

      ELSE

      do  j = 1, LHi
          
          write(LERR,*)'Record= ',irec,'  Horz= ',jhor(j),'  time = ',
     1                 tf(j),'  velocity= ',velf(j)
          if (lunflt .gt. 0) then
             itfj = tf(j)
             ivfj = velf(j)
             write(lunflt,*) itfj, ivfj, irec
          endif
      enddo

      if (lunflt .gt. 0) then
         itfj = -1
         write(lunflt,*) itfj, ivfj, irec
      endif

      ENDIF



        LHi = LH
        if (vmin .ne. 0.0) then
           do  i = LHi, 1, -1
               velf (i+1) = velf (i)
               tf   (i+1) = tf   (i)
           enddo
           velf (1) = vmin
           tf   (1) = 0.
           LHi = LHi + 1
        endif
        if (vmax .ne. 0.0) then
           LHi = LHi + 1
           velf (LHi) = vmax
           tf   (LHi) = float(nsamp-1) * si
        endif

        call vel (tf, velf, nsamp, si, LHi, vout)


      return
      end
