C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
      program ICH
c_______________________________________________________________________
c     program to identify and characterize seismic data by taking xsd format
c     pick files and either generating a synthetic or masking selected
c     portions of the original data.
c_______________________________________________________________________
c
c     CHANGES:
c
c     Aug95 - cleaned up help routine for clarity
c           - initialized ierror to be zero
c           - cleaned up fnyquist assign using nsamp before it is defined
c             ...Garossino [STAT REquest]
c_______________________________________________________________________

#include     <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>
c
      parameter (maxs = 0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)
      parameter (maxseg=1000)
      parameter (ndiv=100,adiv=ndiv)
C
      integer   hbegin, ierror
      integer   argis
C
      integer   sheader(SZLNHD)
      integer   ipwr(4)
      logical   spike
      logical   verbose,mask,mult_by_color

      logical   extrapleft,extrapright
C
      character*256 file_in,file_out,file_picks
      character*40 segname(maxseg)
      data         lupicks/21/
      data         undefined/-999999./
      character*3  name
c     parameter (i2fact=8/szsmpd, lenhed=lntrhd/i2fact, hbegin=1-lenhed )
#include <save_defs.h>
      data ierror/0/
C
      data name     /'ICH'/
c____________________________________________________________________
c     get online help if necessary
c____________________________________________________________________
      if (argis('-?') .gt.0 .or. 
     :    argis('-h') .gt.0 .or. 
     :    argis('-help') .gt.0 ) then
         call help(ler)
         call exit(0)
      endif
c____________________________________________________________________
c     open printer image output files
c____________________________________________________________________
      call openpr(lupprt,lerr,name,jerr)
c____________________________________________________________________
c     read input/output file names
c____________________________________________________________________
      call argstr('-N',file_in,' ',' ')
      call argstr('-P',file_picks,' ',' ')
      call argstr('-O',file_out,' ',' ')
c____________________________________________________________________
c     read additional parameters
c____________________________________________________________________
c      fnyquist=1./(nsamp*dt) - i commented this out as nsamp has yet to 
c                               be defined - Garossino
      call argr4('-f1',f1,0.,0.)
      call argr4('-f2',f2,0.,0.)
      call argr4('-f3',f3,0.,0.)
      call argr4('-f4',f4,0.,0.)
      call argr4('-tw',tw,0.,0.)
      call argr4('-ttaper',ttaper,0.,0.)
      call argi4('-nxtaper',nxtaper,0.,0.)
      call argi4('-smooth',nsmooth,11,11)
      nsmooth=2*(nsmooth/2)+1
      verbose=(argis('-V') .gt. 0)
      mask=(argis('-M') .gt. 0)
      spike=(argis('-S') .gt. 0)
      mult_by_color=(argis('-C') .gt. 0)
      if(f1 .gt. f2 .or. f2 .gt. f3 .or. f3 .gt. f4) then
         write(lerr,*) 'error in defining wavelet spectrum'
         write(lerr,*) 'f1,f2,f3,f4 must be in increasing order!'
         write(lerr,*) 'f1 = ',f1
         write(lerr,*) 'f2 = ',f2
         write(lerr,*) 'f3 = ',f3
         write(lerr,*) 'f2 = ',f4
         ierror=ierror+1
      endif
      if(nsmooth .lt. 0) then
         write(lerr,*) 'command line error!'
         write(lerr,*) 'smoothing operator must be > 0 !'
         write(lerr,*) 'nsmooth = ',nsmooth
         ierror=ierror+1
      endif
c____________________________________________________________________
c     open input and output seismic file names.
c____________________________________________________________________
      call getln(luin,file_in,'r',0)
      call getln(luout,file_out,'w',1)
c
      if(file_picks .ne. ' ') then
c____________________________________________________________________
c        open input xsd format horizon pick file.
c____________________________________________________________________
         open(lupicks,file=file_picks,status='UNKNOWN',
     1         form='FORMATTED',iostat=ioerror)
         if(ioerror .ne. 0) then
            write(lerr,*) 'error opening file ',file_picks
            ierror=ierror+1
         endif
      else
         write(lerr,*) 'must enter pick file name after -P option!'
         ierror=ierror+1
      endif
c
      if(ierror .gt. 0) then
         write(lerr,*) 'program ich aborted due to ',ierror,
     1                 ' command line errors'
         call exit(1110)
      endif
      read(lupicks,100)recunit,trcunit,smpunit,nrec,ntrace,nsamp,
     *                 recoff,trcoff,smpoff,nsegments,maxpicks
100   format(6x,f12.6,1x,f12.6,1x,f12.6,1x,i5,1x,i5,1x,i5,
     *       7x,f12.6,1x,f12.6,1x,f12.6,8x,i5,1x,i5)
      nsi_xsd=nint(smpunit)
      call rtape(luin,sheader,lensh)
      call hlhprt(sheader,lensh,name,4,lerr)
c_______________________________________________________________________
C     pull input data parameters off the line header.
C     check against xsd pick file headers!
c_______________________________________________________________________
      call saver(sheader,'NumTrc',ntrace_seismic,LINEHEADER)
      call saver(sheader,'NumSmp',nsamp_seismic,LINEHEADER)
      call saver(sheader,'NumRec',nrec_seismic,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      call saver(sheader, 'UnitSc', unitsc, LINEHEADER)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(sheader, 'UnitSc', unitsc, LINEHEADER)
      endif
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
 
      lenhed = ITRWRD
      hbegin = 1-lenhed
 
      if(nrec .ne. nrec_seismic .or. ntrace .ne. ntrace_seismic
     1     .or. nsamp .ne. nsamp_seismic) then
         write(lerr,*) 'discrepency between xsd and seismic files!'
         write(lerr,'(/,3a20)') 'variable','xsd file','seismic file'
         write(lerr,'(a20,2i20)') 'NumRec',nrec,nrec_seismic
         write(lerr,'(a20,2i20)') 'NumTrc',ntrace,ntrace_seismic
         write(lerr,'(a20,2i20)') 'NumSmp',nsamp,nsamp_seismic
         ierror=ierror+1
      endif
      call nrfft(nsamp,2,nfft,ipwr)
      dt = float(nsi) * unitsc

      dtmsec = 1000 * dt
      fnyquist=1./(2.*dt)
      df=1./(nfft*dt)
      if(f1 .le. 0.) f1=0.1*fnyquist
      if(f2 .le. 0.) f2=0.2*fnyquist
      if(f3 .le. 0.) f3=0.9*fnyquist
      if(f4 .le. 0.) f4=1.0*fnyquist
      if(tw .le. 0.) tw=25.*dtmsec
      if(ttaper .le. 0.) ttaper=5.*dtmsec
      maxw=.5*tw/dtmsec
      minw=-maxw
C_______________________________________________________________________
c     write out the line header.
C_______________________________________________________________________
      call savhlh(sheader,lensh,lbyout)
      call wrtape(luout,sheader,lbyout)
c______________________________________________________________________
c     print out relevent information.
c______________________________________________________________________
      write(lerr,*)
      write(lerr,*) 'files'
      write(lerr,*) 'file_in:     ',file_in
      write(lerr,*) 'file_picks:  ',file_picks
      write(lerr,*) 'file_out:    ',file_out
      write(lerr,*)
      write(lerr,*) ' samples per trace     =  ', nsamp
      write(lerr,*) ' samples for fft       =  ', nfft
      write(lerr,*) ' Traces per Record     =  ', ntrace
      write(lerr,*) ' smoothing operator    =  ', nsmooth
      write(lerr,*) ' trace taper (traces)  =  ', nxtaper
      write(lerr,*) ' Records per Line      =  ', nrec
      write(lerr,*) ' Sample Interval (msec)=  ', dtmsec
      write(lerr,*) ' time window (msec)    =  ', tw
      write(lerr,*) ' time taper  (msec)    =  ', ttaper
      write(lerr,*) ' minw (samples)        =  ', minw
      write(lerr,*) ' maxw (samples)        =  ', maxw
      write(lerr,*) ' f1   (Hz or kHz)      =  ', f1
      write(lerr,*) ' f2   (Hz or kHz)      =  ', f2
      write(lerr,*) ' f3   (Hz or kHz)      =  ', f3
      write(lerr,*) ' f4   (Hz or kHz)      =  ', f4
      write(lerr,*) ' df   (Hz or kHz)      =  ', df
      write(lerr,*) ' fnyquist (Hz or kHz)  =  ', fnyquist
      write(lerr,*) ' convolve with spike?        ', spike
      write(lerr,*) ' form mask for seismic data? ',mask
      write(lerr,*) ' multiply reflector by segcolor?',
     1               mult_by_color
      write(lerr,*) ' verbose output?              ',verbose
      if(nsegments .gt. maxseg) then
         write(lerr,*) 'error in routine ich'
         write(lerr,*) 'number of pick segments ',nsegments
         write(lerr,*) 'hardcoded dimension of maxseg = ',maxseg
         write(lerr,*) 'call programmer to recompile with larger limits'
         ierror=ierror+1
      endif
      if(ierror .gt. 0) then
         write(lerr,*) 'program ich aborted due to ',ierror,
     1                 ' data errors'
         call exit(1111)
      endif
 
      lensh=0
      call hlhprt(sheader,lensh,name,3,lerr)
c
      lenu=(lenhed+nsamp)*ntrace
      lenw=maxw-minw+1
C***********************************************************************
C     calculate memory requirements for velocity model processing.
C***********************************************************************
      WRITE(lerr,'(///,80A1)') ('_',I=1,80)
      WRITE(lerr,'(A)')'STORAGE MAP OF MAJOR ARRAYS'
      WRITE(lerr,'(80A1)') ('_',I=1,80)
      WRITE(lerr,'(A20,3A10)')'VARIABLE NAME','BEGIN','END','LENGTH'
C
      l_free=1
      call mapmem('u',l_u,l_free,lenu,lerr)
      call mapmem('umask',l_umask,l_free,nsamp*ntrace,lerr)
      call mapmem('wavelet',l_wavelet,l_free,lenw*(ndiv+1),lerr)
      call mapmem('fwgt',l_fwgt,l_free,nfft/2,lerr)
      call mapmem('twgt',l_twgt,l_free,maxw-minw+1,lerr)
      call mapmem('xwgt',l_xwgt,l_free,ntrace,lerr)
      call mapmem('worka',l_worka,l_free,nfft,lerr)
      call mapmem('workb',l_workb,l_free,nfft,lerr)
      call mapmem('zhorizon',l_zhorizon,l_free,ntrace,lerr)
      call mapmem('ztemp',l_ztemp,l_free,ntrace+nsmooth,lerr)
      call mapmem('npicks',l_npicks,l_free,nsegments,lerr)
      call mapmem('segnum',l_segnum,l_free,nsegments,lerr)
      call mapmem('segcolor',l_segcolor,l_free,nsegments,lerr)
      call mapmem('trace',l_trace,l_free,nsegments*maxpicks,lerr)
      call mapmem('record',l_record,l_free,nsegments*maxpicks,lerr)
      call mapmem('sample',l_sample,l_free,nsegments*maxpicks,lerr)
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(lerr,'(//,a)') 'allocate dynamic memory for ICH: '
      write(lerr,*) 1.e-6*lens,' Mwords'
      write(lerr,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(ler,'(//,a)') 'allocate dynamic memory for ICH: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)'program ICH aborted'
         call exit(101)
      endif
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
C_______________________________________________________________________
C     go read in the picks.
C_______________________________________________________________________
      call rdpicks(segname,s(l_segnum),s(l_segcolor),s(l_npicks),
     1             s(l_record),s(l_trace),s(l_sample),
     2             recunit,trcunit,smpunit,recoff,trcoff,smpoff,
     3             maxpicks,nsegments,lupicks,lerr,
     4             nsamp,ntrace,nrec)
C_______________________________________________________________________
C     calculate wavelet.
C_______________________________________________________________________
      call getw(s(l_wavelet),s(l_fwgt),s(l_worka),s(l_workb),s(l_twgt),
     1          nfft,minw,maxw,f1,f2,f3,f4,tw,dt,ndiv,ttaper,
     2          dtmsec,lerr)
C_______________________________________________________________________
C     loop over all records.
C_______________________________________________________________________
      do 20000 irec=1,nrec
C_______________________________________________________________________
C      read in seismic record, thereby obtaining trace header info.
C_______________________________________________________________________
       call rdsis(s(l_u),nsamp,1,ntrace,hbegin,luin,nbyptr)
       if(nbyptr .eq. 0) go to 20001
C_______________________________________________________________________
c      characterize the data by interpolating picks and convolving
c      with a wavelet.
C_______________________________________________________________________
       extrapleft=.false.
       extrapright=.false.
       call ichsub(s(l_u),hbegin,nsamp,
     1             s(l_zhorizon),undefined,ntrace,irec,
     2             s(l_ztemp),nsmooth,extrapleft,extrapright,
     3             segname,s(l_segnum),s(l_segcolor),s(l_npicks),
     4             s(l_record),s(l_trace),s(l_sample),
     5             s(l_wavelet),minw,maxw,mask,spike,
     6             s(l_xwgt),s(l_twgt),s(l_umask),ndiv,adiv,nxtaper,
     7             maxpicks,nsegments,lerr,verbose,
     8             mult_by_color)

C_______________________________________________________________________
c      write out the data.
C_______________________________________________________________________
      call wrsis(s(l_u),nsamp,1,ntrace,hbegin,luout,nbyptr)
20000 continue
      call lbclos(luout)
      write(lerr,*) 'Normal completion of routine ICH'
      close(lerr)
      write(ler,*) 'Normal completion of routine ICH'
 
      call exit(0)
20001 continue
      write(lerr,*) 'End of data encountered in routine rdsis'
      write(lerr,*) 'record irec = ',irec,' out of nrec = ',nrec
      write(ler,*) 'End of data encountered in routine rdsis'
      write(ler,*) 'record irec = ',irec,' out of nrec = ',nrec
      call exit(666)
      end
      subroutine  help(ler)
      write(ler,*)' '
      write(ler,*)'Command Line Arguments for ICH: '
      write(ler,*)'Identify and CHaracterize seismic signal and or'
     1            //' noise events'
      write(ler,*)' '
      write(ler,*)'Input....................................... (def)'
      write(ler,*)' '
      write(ler,*)'-N [file_in] (stdin)          :'
      write(ler,*)'             Input seismic data file to be'
     1                          //' characterized'
      write(ler,*)'-P [file_picks] (stdin)       :'
      write(ler,*)'             Input xsd format pick file'
     1                          //' corresponding to file_in'
      write(ler,*)'-O [file_out] (stdout)      :'
      write(ler,*)'             Output characterized seismic data file'
      write(ler,*)'-f1       -- first frequency of 4 point'//
     1                          'Hamming tapers (.1*fnyquist)'
      write(ler,*)'-f2       -- second frequency of 4 point'//
     1                          'Hamming tapers (.2*fnyquist)'
      write(ler,*)'-f3       -- third frequency of 4 point'//
     1                          'Hamming tapers (.9*fnyquist)'
      write(ler,*)'-f4       -- fourth frequency of 4 point'//
     1                          'Hamming tapers (fnyquist)'
      write(ler,*)'-tw       -- temporal length of wavelet in msec'
     1                          //' (25 samples)'
      write(ler,*)'-ttaper   -- temporal taper on  wavelet in msec'
     1                          //' (5 samples)'
      write(ler,*)'-smooth   -- run a n=point smooth operator over'
     1                          //' the picks (11)'
      write(ler,*)'-nxtaper  -- amplitude taper on edges of picks'
     1                          //' in traces (0) '
      write(ler,*)'-S        -- generate a spike at pick location'
c
      write(ler,*)'-M        -- if present, form mask over data'
      write(ler,*)'-V        -- verbose output'
      write(ler,*)' '
      write(ler,*)'Usage:'
      write(ler,*)'        ich -N[] -P[] -O[] '
      write(ler,*)'            -f1[] -f2[] -f3[] -f4[] '
      write(ler,*)'            -tw[] -ttaper[] -smooth[]'
      write(ler,*)'            [-S -M -V]'
      write(ler,*)' '
 
      return
      end
