/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>

#include "ikp_defines.h"
#include "ikp_externs.h"

extern void net_monitor();

int batch(char *filenm)
{
  
  if (net_read(0, 0, filenm) != IKP_SUCCESS)
    return(IKP_FAILURE);
  
  if (net_fork(curr_net) != IKP_SUCCESS)
    return(IKP_FAILURE);
  
  /* intermittently check for return status of child processes */
  batch_status= IKP_SUCCESS;
  while (run_net != (Net *) NULL) {
    if (poll_count > POLL_LIMIT) {
      sleep(2);
      poll_count= 0;
    }
    poll_count++;
    net_monitor();
  }
  
  return(batch_status);
}
