/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>

#include "ikp_defines.h"
#include "ikp_externs.h"
#include "globalE.h"

#define MAGIC_SPACING 18     /* Spacing of widget for label next to text */

extern void cnt_highlight(Connector *,int);

void file_grnd_okCB(Widget w,
		    XtPointer client_data,
		    XmFileSelectionBoxCallbackStruct *call_data);
void file_grnd_cancelCB(Widget w,
			XtPointer client_data,
			XmFileSelectionBoxCallbackStruct *call_data);


static Widget form=NULL;
static Widget toggle_truncate=NULL;
static Widget toggle_append=NULL;
static Widget text_desc=NULL;
static Widget file_cnt=NULL;
static Widget separator=NULL;
static Widget label_mode=NULL;
static Widget label_desc=NULL;
static Widget radio=NULL;

void init_file_grn()
{

  form=XmCreateFormDialogVa(top_level,"form",
			    XmNmarginWidth,10,
			    XmNmarginHeight,10,
			    XmNtitle,"File Selection",
			    XtNmanageChild,False,
			    NULL);

  label_mode=XmCreateLabelVa(form,"File mode:",
			     XmNtopOffset,MAGIC_SPACING,
			     XmNtopAttachment,XmATTACH_FORM,
			     XmNleftAttachment,XmATTACH_FORM,
			     NULL);
  
  radio=XmCreateRadioBoxVa(form,"radio",
			   XmNorientation,XmHORIZONTAL,
			   XmNtopAttachment,XmATTACH_FORM,
			   XmNleftAttachment,XmATTACH_WIDGET,
			   XmNleftWidget,label_mode,
			   NULL);

  toggle_truncate=XmCreateToggleButtonVa(radio,"Truncate",
					 NULL);
  XmToggleButtonSetState(toggle_truncate,True,False);

  toggle_append=XmCreateToggleButtonVa(radio,"Append",
				       NULL);
  XmToggleButtonSetState(toggle_append,False,False);
  
  label_desc=XmCreateLabelVa(form,"File descriptor:",
			     XmNtopOffset,MAGIC_SPACING,
			     XmNtopAttachment,XmATTACH_WIDGET,
			     XmNtopWidget,label_mode,
			     XmNleftAttachment,XmATTACH_FORM,
			     NULL);
  
  text_desc=XmCreateTextVa(form,"text",
			   XmNtopAttachment,XmATTACH_WIDGET,
			   XmNtopWidget,radio,
			   XmNleftAttachment,XmATTACH_WIDGET,
			   XmNleftWidget,label_desc,
			   XmNcolumns,3,
			   NULL);

  separator=XmCreateSeparatorVa(form,"separator",
				XmNtopAttachment,XmATTACH_WIDGET,
				XmNtopWidget,text_desc,
				XmNtopOffset,10,
				XmNleftAttachment,XmATTACH_FORM,
				XmNrightAttachment,XmATTACH_FORM,
				NULL);
				
  
  file_cnt=XmCreateFileSelectionBoxVa(form,"file",
				      XmNtopAttachment,XmATTACH_WIDGET,
				      XmNtopWidget,separator,
				      XmNtopOffset,10,
				      XmNbottomAttachment,XmATTACH_FORM,
				      XmNleftAttachment,XmATTACH_FORM,
				      XmNrightAttachment,XmATTACH_FORM,
				      NULL);
  return;
}

int cnt_adjgrnd(Connector *c)
{
  Process *p;
  char desc[4];
  
  XtManageChild(form);

  p= (Process *) c->cnt_process;
  
  XtVaSetValues(file_cnt,
		XmNokCallback,CBl(file_grnd_okCB,c),
		XmNcancelCallback,CBl(file_grnd_cancelCB,c),
		NULL);
  
  if (c->cnt_filename == (char *) NULL)
    XtVaSetValues(file_cnt,
		  XmNtextString,XMstr(""),
		  NULL);
  else
    XtVaSetValues(file_cnt,
		  XmNtextString,XMstr(c->cnt_filename),
		  NULL);

  if (c->cnt_iodir == CNT_INPUT) {
    XtVaSetValues(label_mode,
		  XmNsensitive,False,
		  NULL);
    XtVaSetValues(toggle_truncate,
		  XmNsensitive,False,
		  NULL);
    XtVaSetValues(toggle_append,
		  XmNsensitive,False,
		  NULL);
  } else {
    if (c->cnt_flags & CNT_APPEND) { 
      XmToggleButtonSetState(toggle_append,True,False);
      XmToggleButtonSetState(toggle_truncate,False,False);
    } else {
      XmToggleButtonSetState(toggle_append,False,False);
      XmToggleButtonSetState(toggle_truncate,True,False);
    }      
    XtVaSetValues(label_mode,
		  XmNsensitive,True,
		  NULL);
    XtVaSetValues(toggle_truncate,
		  XmNsensitive,True,
		  NULL);
    XtVaSetValues(toggle_append,
		  XmNsensitive,True,
		  NULL);
  }

  if (p->prc_type == PRC_CUSTOM) {
    sprintf(buf1,"%0d",c->cnt_desc);
    XtVaSetValues(text_desc,
		  XmNvalue,buf1,
		  XmNsensitive,True,
		  NULL);
    XtVaSetValues(label_desc,
		  XmNsensitive,True,
		  NULL);
  } else {
    XtVaSetValues(text_desc,
		  XmNsensitive,False,
		  NULL);
    XtVaSetValues(label_desc,
		  XmNsensitive,False,
		  NULL);
  }

  return(IKP_SUCCESS);
}

void file_grnd_okCB(Widget w,
		    XtPointer client_data,
		    XmFileSelectionBoxCallbackStruct *call_data)
{
  Connector *c=(Connector *)client_data;
  Connector *d;
  Process *p;
  char *str;
  int newfd;

  net_op= MAIN_MENU;
  cnt_highlight(c,1);

  p= (Process *) c->cnt_process;
  
                                  /* Set if a filename was entered. */
  XmStringGetLtoR(call_data->value,XmSTRING_DEFAULT_CHARSET,&str);

  if (strlen(str) == 0) {
    if (c->cnt_filename != (char *) NULL)
      cfree(c->cnt_filename);
    c->cnt_filename= (char *) NULL;
  } else 
    if (c->cnt_filename == (char *) NULL) {
      if ((c->cnt_filename= calloc((unsigned) (strlen(str)+1), sizeof(char))) == (char *) NULL)
	ikp_err("Memory allocation error.", FATAL);
      strcpy(c->cnt_filename,str);
    } else 
      if (strcmp(str, c->cnt_filename)) {
	if (c->cnt_filename != (char *) NULL)
	  cfree(c->cnt_filename);
	if ((c->cnt_filename= calloc((unsigned) (strlen(str)+1), sizeof(char))) == (char *) NULL)
	  ikp_err("Memory allocation error.", FATAL);
	strcpy(c->cnt_filename,str);
      }
  
  if (c->cnt_iodir != CNT_INPUT) {
    if (XmToggleButtonGetState(toggle_truncate))
      c->cnt_flags&= ~CNT_APPEND;
    else
      c->cnt_flags|= CNT_APPEND;
  }
  
  if (p->prc_type == PRC_CUSTOM) {
    XtVaGetValues(text_desc,
		  XmNvalue,&str,
		  NULL);
    if (sscanf(str, "%d", &newfd) != 1) {
      ikp_err("Unspecified descriptor value.", NONFATAL);
      return;
    }
    if ((newfd < 0) || (newfd >= getdtablesize())) {
      ikp_err("Invalid descriptor value.", NONFATAL);
      return;
    }
    for (d= p->prc_input; d != (Connector *) NULL; d= d->cnt_next) {
      if ((c != d) && (newfd == d->cnt_desc)) {
	ikp_err("Duplicate connector descriptor.", NONFATAL);
	return;
      }
    }
    for (d= p->prc_output; d != (Connector *) NULL; d= d->cnt_next) {
      if ((c != d) && (newfd == d->cnt_desc)) {
	ikp_err("Duplicate connector descriptor.", NONFATAL);
	return;
      }
    }
    for (d= p->prc_diag; d != (Connector *) NULL; d= d->cnt_next) {
      if ((c != d) && (newfd == d->cnt_desc)) {
	ikp_err("Duplicate connector descriptor.", NONFATAL);
	return;
      }
    }
    
    prc_erase(p);
    c->cnt_desc= newfd;
    prc_draw(p);
  }
  XtUnmanageChild(form);
}

void file_grnd_cancelCB(Widget w,
			XtPointer client_data,
			XmFileSelectionBoxCallbackStruct *call_data)
{
  Connector *c=(Connector *)client_data;

  net_op= MAIN_MENU;
  cnt_highlight(c,1);

  XtUnmanageChild(form);
}


