/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "globalE.h"
#include "ikp_defines.h"
#include "ikp_externs.h"

draw_line(GC gc,int x1,int y1,int x2,int y2)
{
  x1=(float)x1*net_scale; 
  y1=(float)y1*net_scale;
  x2=(float)x2*net_scale;
  y2=(float)y2*net_scale;
  XDrawLine(display,net_cpm,gc,x1,y1,x2,y2);
}

draw_point(GC gc,int x1,int y1)
{
  x1=(float)x1*net_scale; 
  y1=(float)y1*net_scale;
  XDrawPoint(display,net_cpm,gc,x1,y1);
}

change_font()
{
  if (net_scale<.6) {
    strcpy(small_fontnm,"6x10");
    strcpy(reg_fontnm,"6x10");
  } else
    if (net_scale<1.0) {
      strcpy(small_fontnm,"6x10");
      strcpy(reg_fontnm,"7x14");
    } else {
      strcpy(small_fontnm,"6x10");
      strcpy(reg_fontnm,"10x20");
    }

  /* small size font */
  if ((small_font= XLoadQueryFont(display,small_fontnm)) == NULL) {
    fprintf(stderr, "%s: display %s doesn't know font %s\n", 
	    progname, DisplayString(display), small_fontnm);
    exit(1);
  }
  small_fontht= small_font->max_bounds.ascent+small_font->max_bounds.descent;
  small_charwd= XTextWidth(small_font, "X", strlen("X"));

  if ((reg_font= XLoadQueryFont(display, reg_fontnm)) == NULL) {
    fprintf(stderr, "%s: cannot load font %s\n", 
	    progname, DisplayString(display), reg_fontnm);
    exit(-1);
  }
  reg_fontht= reg_font->max_bounds.ascent+reg_font->max_bounds.descent;
  reg_charwd= XTextWidth(reg_font, "X", strlen("X"));


  XSetFont(display,net_sfxgc,XLoadFont(display,small_fontnm));
  XSetFont(display,net_gc,XLoadFont(display,reg_fontnm));
}




draw_fill_rectangle(GC gc,int x1,int y1,unsigned int width,unsigned int height)
{
  x1=(float)x1*net_scale;
  y1=(float)y1*net_scale;
  width=(float)width*net_scale;
  height=(float)height*net_scale;
  XFillRectangle(display,net_cpm,gc,x1,y1,width,height);
}
