/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>
#include <ctype.h>

#include "ikp_defines.h"
#include "ikp_externs.h"

/*
   Read fp until a line whose initial
   token matches the key is found.
   Null-terminate all input lines.
*/
int ikp_matchkey(char *key,FILE *fp)
{
  char *c, token[MAXTOKENSZ+1];
  
  while (fgets(ikp_iobuf, IOBUFSZ, fp) != (char *) NULL) {
    ikp_linenum++;
    for (c= ikp_iobuf; *c != '\n'; c++);
    *c= '\0';
    if (ikp_gettoken(ikp_iobuf, 0, token, MAXTOKENSZ) != IKP_SUCCESS)
      continue;
    
    if (!strcmp(key, token))
      return(IKP_SUCCESS);
  }

  return(IKP_FAILURE);
}

/*
   Replace newline with NULL,
   set key to point to first token if any.
*/
int ikp_getline(char **key,FILE *fp)
{
  char *c, *d;
  
  if (fgets(ikp_iobuf, IOBUFSZ, fp) == (char *) NULL)
    return(IKP_FAILURE);
  ikp_linenum++;
  for (c= ikp_iobuf; (*c != '\n') && !isgraph(*c); c++);
  for (d= c; *d != '\n'; d++);
  *d= '\0';
  *key= c;
  return(IKP_SUCCESS);
}
