/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>
#include <signal.h>

#include "ikp_defines.h"
#include "ikp_externs.h"
#include "globalE.h"



Library *lib_create(char *name)
{
  Library *l, *m;
  char *c;
  
  if (name == (char *) NULL) {
    ikp_err("Null library name.", NONFATAL);
    return((Library *) NULL);
  }
  if (strlen(name) == 0) {
    ikp_err("Null library name.", NONFATAL);
    return((Library *) NULL);
  }
  
  if ((l= (Library *) calloc(1, sizeof(Library))) == (Library *) NULL)
    ikp_err("Memory allocation error.", FATAL);
  if ((l->lib_name= calloc((unsigned) (strlen(name)+1), sizeof(char *))) == (char *) NULL)
    ikp_err("Memory allocation error.", FATAL);
  (void) strcpy(l->lib_name, name);
  l->lib_modules= (Module *) NULL;
  l->lib_next= (Library *) NULL;
  
  /* make sure no duplicate library name exists */
  for (;;) {
    for (m= libs; m != (Library *) NULL; m= m->lib_next) {
      if (!strcmp(l->lib_name, m->lib_name))
	break;
    }
    if (m == (Library *) NULL)
      break;
    else {
      if ((c= calloc((unsigned) (strlen(l->lib_name)+2), sizeof(char *))) == (char *) NULL)
	ikp_err("Memory allocation error.", FATAL);
      (void) strcpy(c, l->lib_name);
      (void) strcat(c, "+");
      cfree(l->lib_name);
      l->lib_name= c;
    }
  }
  
  return(l);
}

int lib_free(Library *l)
{
  Module *p, *q;
  
  for (p= l->lib_modules; p != (Module *) NULL; p= q) {
    q= p->mdl_next;
    mdl_free(p);
  }
  
  if (l->lib_name != (char *) NULL)
    cfree(l->lib_name);
  cfree((char *) l);
  
  return(IKP_SUCCESS);
}
