/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

#include "globalE.h"

                                /* Prototype of callback functions. */
extern void openCB(Widget,XtPointer,XtPointer);
extern void saveCB(Widget,XtPointer,XtPointer);
extern void appendCB(Widget,XtPointer,XtPointer);
extern void dirCB(Widget,XtPointer,XtPointer);
extern void printCB(Widget,XtPointer,XtPointer);

extern void netselCB(Widget,XtPointer,XtPointer);
extern void netrunCB(Widget,XtPointer,XtPointer);
extern void netcpCB(Widget,XtPointer,XtPointer);
extern void netstopCB(Widget,XtPointer,XtPointer);
extern void netrestartCB(Widget,XtPointer,XtPointer);
extern void netnameCB(Widget,XtPointer,XtPointer);
extern void netabortCB(Widget,XtPointer,XtPointer);
extern void netdstCB(Widget,XtPointer,XtPointer);

extern void sourceCB(Widget,XtPointer,XtPointer);
extern void sinkCB(Widget,XtPointer,XtPointer);
extern void filterCB(Widget,XtPointer,XtPointer);
extern void teeCB(Widget,XtPointer,XtPointer);
extern void customCB(Widget,XtPointer,XtPointer);
extern void scriptCB(Widget,XtPointer,XtPointer);

extern void cntlnkCB(Widget,XtPointer,XtPointer);
extern void cntunlnkCB(Widget,XtPointer,XtPointer);
extern void cntgrndfileCB(Widget,XtPointer,XtPointer);
extern void cntgrndnullCB(Widget,XtPointer,XtPointer);
extern void cnteditCB(Widget,XtPointer,XtPointer);
extern void cntmvCB(Widget,XtPointer,XtPointer);

extern void prccpCB(Widget,XtPointer,XtPointer);
extern void prcmvCB(Widget,XtPointer,XtPointer);
extern void prcopenCB(Widget,XtPointer,XtPointer);
extern void prcdstCB(Widget,XtPointer,XtPointer);

extern void net_scaleCB(Widget,XtPointer,XtPointer);

extern void host_listCB(Widget,XtPointer,XtPointer);

extern void redisplayCB(Widget,XtPointer,XtPointer call_data);
extern void exitCB(Widget,XtPointer,XtPointer);

void fileMenu();
void netMenu();
void createMenu();
void processMenu();
void connectorMenu();
void hostMenu();
void viewMenu();
void helpMenu();

extern Widget menu_bar;

void menubar(Widget main_window)
{
  menu_bar=XmCreateMenuBarVa(main_window,"menu",
			     NULL);

  fileMenu();
  netMenu();
  createMenu();
  processMenu();
  connectorMenu();
  hostMenu();
  viewMenu();
  helpMenu();
}


				/* Create "File" pulldown. */
void fileMenu()
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menu_bar,"pulldown",
                                  XtNmanageChild,False,
                                  NULL);
 
  cascade=XmCreateCascadeButtonVa(menu_bar,"File",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,'F',
                                  NULL);

  button=XmCreatePushButtonVa(pulldown,"Open...",
                              XmNmnemonic,'O',
                              XmNacceleratorText,XMstr("O"),
                              XmNaccelerator,"<Key>O",
			      XmNactivateCallback,CBl(openCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Save As...",
                              XmNmnemonic,'A',
			      XmNactivateCallback,CBl(saveCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Save Append...",
                              XmNmnemonic,'A',
			      XmNactivateCallback,CBl(appendCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Directory",
                              XmNmnemonic,'D',
			      XmNactivateCallback,CBl(dirCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Redisplay",
                              XmNmnemonic,'R',
                              XmNacceleratorText,XMstr("Ctrl+L"),
                              XmNaccelerator,"Ctrl <Key>L",
			      XmNactivateCallback,CBl(redisplayCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Exit",
                              XmNmnemonic,'E',
			      XmNactivateCallback,CBl(exitCB,0),
                              NULL);
}
 

				/* Create "Net" pulldown. */
void netMenu()
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menu_bar,"pulldown",
                                  XtNmanageChild,False,
                                  NULL);
 
  cascade=XmCreateCascadeButtonVa(menu_bar,"Net",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,'N',
                                  NULL);

  button=XmCreatePushButtonVa(pulldown,"Run",
                              XmNmnemonic,'R',
                              XmNacceleratorText,XMstr("Ctrl+R"),
                              XmNaccelerator,"Ctrl <Key>R",
			      XmNactivateCallback,CBl(netrunCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Name",
                              XmNmnemonic,'N',
                              XmNacceleratorText,XMstr("N"),
                              XmNaccelerator,"<Key>N",
			      XmNactivateCallback,CBl(netnameCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Abort",
                              XmNmnemonic,'A',
                              XmNacceleratorText,XMstr("Ctrl+C"),
                              XmNaccelerator,"Ctrl <Key>C",
			      XmNactivateCallback,CBl(netabortCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Select",
                              XmNmnemonic,'S',
                              XmNacceleratorText,XMstr("S"),
                              XmNaccelerator,"<Key>S",
			      XmNactivateCallback,CBl(netselCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Copy",
                              XmNmnemonic,'C',
                              XmNacceleratorText,XMstr("Shift+C"),
                              XmNaccelerator,"Shift <Key>C",
			      XmNactivateCallback,CBl(netcpCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Destroy",
                              XmNmnemonic,'D',
                              XmNacceleratorText,XMstr("Shift+D"),
                              XmNaccelerator,"Shift <Key>D",
			      XmNactivateCallback,CBl(netdstCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Stop",
                              XmNmnemonic,'S',
			      XmNactivateCallback,CBl(netstopCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Restart",
                              XmNmnemonic,'e',
			      XmNactivateCallback,CBl(netrestartCB,0),
                              NULL);
 
}


				/* Create "Create" pulldown. */
void createMenu()
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menu_bar,"pulldown",
                                  XtNmanageChild,False,
                                  NULL);
 
  cascade=XmCreateCascadeButtonVa(menu_bar,"Create",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,'C',
                                  NULL);

 
  button=XmCreatePushButtonVa(pulldown,"Source",
                              XmNmnemonic,'S',
			      XmNactivateCallback,CBl(sourceCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Sink",
                              XmNmnemonic,'n',
			      XmNactivateCallback,CBl(sinkCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Filter",
                              XmNmnemonic,'F',
			      XmNactivateCallback,CBl(filterCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Tee",
                              XmNmnemonic,'T',
			      XmNactivateCallback,CBl(teeCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Custom",
                              XmNmnemonic,'C',
			      XmNactivateCallback,CBl(customCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Script",
                              XmNmnemonic,'S',
			      XmNactivateCallback,CBl(scriptCB,0),
                              NULL);
}



				/* Create "Process" pulldown. */
void processMenu()
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menu_bar,"pulldown",
                                  XtNmanageChild,False,
                                  NULL);
 
  cascade=XmCreateCascadeButtonVa(menu_bar,"Process",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,'P',
                                  NULL);

   button=XmCreatePushButtonVa(pulldown,"Copy",
                              XmNmnemonic,'C',
                              XmNacceleratorText,XMstr("C"),
                              XmNaccelerator,"<Key>C",
			      XmNactivateCallback,CBl(prccpCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Move",
                              XmNmnemonic,'M',
                              XmNacceleratorText,XMstr("M"),
                              XmNaccelerator,"<Key>M",
			      XmNactivateCallback,CBl(prcmvCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Destroy",
                              XmNmnemonic,'D',
                              XmNacceleratorText,XMstr("D"),
                              XmNaccelerator,"<Key>D",
			      XmNactivateCallback,CBl(prcdstCB,0),
                              NULL);


}

				/* Create "Connector" pulldown. */
void connectorMenu()
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menu_bar,"pulldown",
                                  XtNmanageChild,False,
                                  NULL);
 
  cascade=XmCreateCascadeButtonVa(menu_bar,"Connector",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,'C',
                                  NULL);

 
  button=XmCreatePushButtonVa(pulldown,"File",
                              XmNmnemonic,'F',
                              XmNacceleratorText,XMstr("F"),
                              XmNaccelerator,"<Key>F",
			      XmNactivateCallback,CBl(cntgrndfileCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Ground",
                              XmNmnemonic,'G',
                              XmNacceleratorText,XMstr("G"),
                              XmNaccelerator,"<Key>G",
			      XmNactivateCallback,CBl(cntgrndnullCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Unlink",
                              XmNmnemonic,'U',
                              XmNacceleratorText,XMstr("U"),
                              XmNaccelerator,"<Key>U",
			      XmNactivateCallback,CBl(cntunlnkCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Move",
                              XmNmnemonic,'M',
                              XmNacceleratorText,XMstr("Shift+M"),
                              XmNaccelerator,"Shift <Key>M",
			      XmNactivateCallback,CBl(cntmvCB,0),
                              NULL);
}

				/* Create "Host" pulldown. */
void hostMenu()
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menu_bar,"pulldown",
                                  XtNmanageChild,False,
                                  NULL);
  
  cascade=XmCreateCascadeButtonVa(menu_bar,"Host",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,'H',
                                  NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Host List",
                              XmNmnemonic,'H',
			      XmNactivateCallback,CBl(host_listCB,0), 
                              NULL);
}
				/* Create "View" pulldown. */
void viewMenu()
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menu_bar,"pulldown",
                                  XtNmanageChild,False,
                                  NULL);
  
  cascade=XmCreateCascadeButtonVa(menu_bar,"View",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,'V',
                                  NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Net Scale",
                              XmNmnemonic,'N',
			      XmNactivateCallback,CBl(net_scaleCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Drawing Area",
                              XmNmnemonic,'D',
/*			      XmNactivateCallback,CBl(cntmvCB,0), */
                              NULL);
}

				/* Create "Help" pulldown. */
void helpMenu()
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menu_bar,"pulldown",
                                  XtNmanageChild,False,
                                  NULL);
  
  cascade=XmCreateCascadeButtonVa(menu_bar,"Help",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,'H',
                                  NULL);
 
  XtVaSetValues(menu_bar,
                XmNmenuHelpWidget,cascade,
                NULL);
 
  button=XmCreatePushButtonVa(pulldown,"On Context",
                              XmNmnemonic,'C',
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"On Window",
                              XmNmnemonic,'W',
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"On Keys",
                              XmNmnemonic,'K',
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Index",
                              XmNmnemonic,'I',
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"On Help",
                              XmNmnemonic,'H',
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Tutorial",
                              XmNmnemonic,'T',
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"On Version",
                              XmNmnemonic,'V',
                              NULL);
}
