/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "globalE.h"

static Widget text=NULL;
extern Widget message_window;

message_area(Widget main_window)
{
  Widget label=NULL;
 
  message_window=XmCreateFormVa(main_window,"form",
				NULL);
 
  label=XmCreateLabelVa(message_window,"Message:",
                        XmNtopAttachment,XmATTACH_FORM,
                        XmNleftAttachment,XmATTACH_FORM,
                        XmNbottomAttachment,XmATTACH_FORM,
                        NULL);

  text=XmCreateTextVa(message_window,"text",
                      XmNleftAttachment,XmATTACH_WIDGET,
                      XmNleftWidget,label,
                      XmNrightAttachment,XmATTACH_FORM,
                      NULL);
}

  
void message_update(char *str)
{
  XtVaSetValues(text,
                XmNvalue,str,
                NULL);
}

void prompt_box()
{
  prompt=XmCreatePromptDialogVa(top_level,"Prompt",
				XtNmanageChild,False,
				XmNautoUnmanage,True,
				NULL);

}

void confirm_box()
{
  confirm=XmCreateQuestionDialogVa(top_level,"Prompt",
				   XtNmanageChild,False,
				   XmNautoUnmanage,True,
				   NULL);
}

void helpCB(Widget w,XtPointer client_data,XtPointer call_data)
{
  static Widget form=NULL;
  static Widget text=NULL;
  static Widget button=NULL;
  static int init=1;

  if (init) {
    init=0;
    form=XmCreateFormDialogVa(top_level,"form",
			      XmNmarginHeight,10,
			      XmNmarginWidth,10,
			      XtNmanageChild,False,
			      XmNdeleteResponse,XmDO_NOTHING,
			      XmNdialogTitle,XMstr("Help Dialog"),
			      NULL);
    
    button=XmCreatePushButtonVa(form,"Cancel",
				XmNbottomAttachment,XmATTACH_FORM,
				XmNleftAttachment,XmATTACH_FORM,
				NULL);
    
    text=XmCreateScrolledTextVa(form,"text",
				XmNbottomAttachment,XmATTACH_WIDGET,
				XmNbottomWidget,button,
				XmNtopAttachment,XmATTACH_FORM,
				XmNleftAttachment,XmATTACH_FORM,
				XmNrightAttachment,XmATTACH_FORM,
				XmNrows,15,
				XmNcolumns,60,
				XmNwordWrap,True,
				XmNeditable,False,
				XmNeditMode,XmMULTI_LINE_EDIT,
				XmNscrollHorizontal,False,
				NULL);
  }

  if ((client_data==NULL)||(strlen((char *)client_data)==0)) {
    XtVaSetValues(text,
		  XmNvalue,"No help available for this item.",
		  NULL);
  } else {
    XtVaSetValues(text,
		  XmNvalue,(char *)client_data,
		  NULL);
  }

  XtManageChild(form);

  return;
}
 
void ikp_filer_box()
{
  file=XmCreateFileSelectionDialogVa(top_level,"file",
				     XtNmanageChild,False,
				     XmNautoUnmanage,True,
				     XmNdialogTitle,XMstr("??????"),
				     (char *)0);
}


