C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
        subroutine iphase(tri,triphz,nsamp,npts,npts21,
     1                    npoint,dt,fl,fh, sqr, rect)

c  routine to compute instantaneous phase

c  input
c       tri  --  inpute data
c     nsamp  --  number input data samples
c        dt  --  sample interval in sec
c      npts  --  power of 2 # samples
c    npts21  --  npts/2 + 1
c    npoint  --  length of smoother
c        fl  --  lo cut freq
c        fh  --  hi cut freq

c  output
c    triphz  --  inst phase vector

#include <f77/lhdrsz.h>

        parameter (deg = 57.2957795)
        real      tri(*), triphz(*)
        complex   data(SZSMPM)
        real      h(SZSMPM), q(SZSMPM)
        logical   sqr, rect

        if     (sqr)  then
           call vssq (tri, 1, tri, 1, nsamp)
        elseif (rect) then
           call vsq  (tri, 1, tri, 1, nsamp)
        endif

        do 2000 i=1,NPTS
                if(i.le.nsamp)then
                        data(i) = cmplx(tri(i),0.0)
                else
                        data(i) = cmplx(0.0,0.0)
                endif
 2000   continue

        call four(data,npts,-1,dt,df)
c-----
c       form spectra to get quadrature
c-----
        do 3000 i=1, npts
                if(i.lt.npts21)then
                        data(i) = 2.0*data(i)
                else
                        data(i) = cmplx(0.0,0.0)
                endif
 3000   continue
        call four(data,npts,+1,dt,df)

c-----
c       now real(data) is the original time series
c       and aimag(data) is the quadrature series
c-----
        do 4000 i=1,nsamp
                h(i) = real(data(i))
                q(i) = aimag(data(i))
 4000   continue

c-----
c       weighted average of frequency
c       use a NPOINT smoothing operator
c-----
        do 6000 i=1,nsamp
                sumn = 0.0
                sumd = 0.0
                jlow = i - NPOINT/2
                jup  = i + NPOINT/2
                if(jlow.lt.1)jlow = 1
                if(jup .gt.nsamp)jup=nsamp
                do 6001 j=jlow,jup
                        sumn = sumn + q(j)
                        sumd = sumd + h(j)
 6001           continue
                triphz(i) = deg * atan2( sumn,sumd )
 6000   continue
                        
        return
        end


